/*
 * Decompiled with CFR 0.152.
 */
package de.eobs.setuptool.remoteservice;

import de.eobs.setuptool.util.BuildProperties;
import de.eobs.setuptool.util.UnexpectedSwitchValueException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public interface RemoteServiceCompatibilityCheck {
    public ServiceInfo checkCompatibility(ClientInfo var1);

    public static final class ServiceInfo
    implements Serializable {
        static final long serialVersionUID = 1L;
        private static final int OVER_THE_WIRE_PROTOCOL_VERSION = 1;
        private boolean isClientSupported;
        private boolean isClientUpdateAvailable;
        private String message;
        private String homePageUrl;
        private String updateServiceUrl;
        private Map<String, String> auxiliaryData = new HashMap<String, String>();

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            int version = in.readInt();
            switch (version) {
                case 1: {
                    this.isClientSupported = in.readBoolean();
                    this.isClientUpdateAvailable = in.readBoolean();
                    this.message = in.readUTF();
                    this.homePageUrl = in.readUTF();
                    this.updateServiceUrl = in.readUTF();
                    int auxiliaryDataSize = in.readInt();
                    this.auxiliaryData = new HashMap<String, String>(auxiliaryDataSize * 2);
                    for (int i = 0; i < auxiliaryDataSize; ++i) {
                        this.auxiliaryData.put(in.readUTF(), in.readUTF());
                    }
                    break;
                }
                default: {
                    throw new UnexpectedSwitchValueException(version);
                }
            }
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeInt(1);
            out.writeBoolean(this.isClientSupported);
            out.writeBoolean(this.isClientUpdateAvailable);
            out.writeUTF(this.orEmptyString(this.message));
            out.writeUTF(this.orEmptyString(this.homePageUrl));
            out.writeUTF(this.orEmptyString(this.updateServiceUrl));
            ArrayList<Map.Entry<String, String>> auxiliaryDataList = new ArrayList<Map.Entry<String, String>>(this.auxiliaryData.entrySet());
            out.writeInt(auxiliaryDataList.size());
            for (Map.Entry<String, String> entry : auxiliaryDataList) {
                out.writeUTF(entry.getKey());
                out.writeUTF(entry.getValue());
            }
        }

        public ServiceInfo(boolean isClientSupported, boolean isClientUpdateAvailable, String message, URL homePageUrl, URL updateServiceUrl) {
            this.isClientSupported = isClientSupported;
            this.isClientUpdateAvailable = isClientUpdateAvailable;
            this.message = message == null ? "" : message;
            this.homePageUrl = homePageUrl == null ? "" : homePageUrl.toExternalForm();
            this.updateServiceUrl = updateServiceUrl == null ? "" : updateServiceUrl.toExternalForm();
        }

        private String orEmptyString(String str) {
            return str == null ? "" : str;
        }

        public boolean isClientSupported() {
            return this.isClientSupported;
        }

        public boolean isClientUpdateAvailable() {
            return this.isClientUpdateAvailable;
        }

        public boolean hasMessage() {
            return this.message != null && !this.message.trim().isEmpty();
        }

        public String getMessage() {
            return this.message == null ? "" : this.message.trim();
        }

        public boolean hasHomePageUrl() {
            return this.homePageUrl != null && !this.homePageUrl.isEmpty() && this.getHomePageUrl() != null;
        }

        public URL getHomePageUrl() {
            if (this.homePageUrl == null) {
                return null;
            }
            if (this.homePageUrl.isEmpty()) {
                return null;
            }
            try {
                return new URL(this.homePageUrl);
            }
            catch (MalformedURLException e) {
                return null;
            }
        }

        public boolean hasUpdateServiceUrl() {
            return this.updateServiceUrl != null && !this.updateServiceUrl.isEmpty() && this.getUpdateServiceUrl() != null;
        }

        public URL getUpdateServiceUrl() {
            if (this.updateServiceUrl == null) {
                return null;
            }
            if (this.updateServiceUrl.isEmpty()) {
                return null;
            }
            try {
                return new URL(this.updateServiceUrl);
            }
            catch (MalformedURLException e) {
                return null;
            }
        }

        public void putAuxiliaryData(String key, String value) {
            this.auxiliaryData.put(key, value);
        }

        public String getAuxiliaryData(String key) {
            return this.auxiliaryData.get(key);
        }

        public boolean hasAuxiliaryData(String key) {
            return this.auxiliaryData.containsKey(key);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("ServiceInfo{");
            sb.append("isClientSupported=").append(this.isClientSupported);
            sb.append(", isClientUpdateAvailable=").append(this.isClientUpdateAvailable);
            sb.append(", message='").append(this.message).append('\'');
            sb.append(", homePageUrl=").append(this.homePageUrl);
            sb.append(", updateServiceUrl=").append(this.updateServiceUrl);
            sb.append(", auxiliaryData=").append(this.auxiliaryData);
            sb.append('}');
            return sb.toString();
        }
    }

    public static final class ClientInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private static final int OVER_THE_WIRE_PROTOCOL_VERSION = 1;
        private String clientName;
        private String gitTag;
        private String gitTagLong;
        private String gitBranch;
        private boolean gitDirty;
        private String gitCommitHash;
        private String gitCommitTimestamp;
        private String uniqueClientId;
        private Map<String, String> auxiliaryData = new HashMap<String, String>();

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            int version = in.readInt();
            switch (version) {
                case 1: {
                    this.clientName = in.readUTF();
                    this.gitTag = in.readUTF();
                    this.gitTagLong = in.readUTF();
                    this.gitBranch = in.readUTF();
                    this.gitDirty = in.readBoolean();
                    this.gitCommitHash = in.readUTF();
                    this.gitCommitTimestamp = in.readUTF();
                    this.uniqueClientId = in.readUTF();
                    int auxiliaryDataSize = in.readInt();
                    this.auxiliaryData = new HashMap<String, String>(auxiliaryDataSize * 2);
                    for (int i = 0; i < auxiliaryDataSize; ++i) {
                        this.auxiliaryData.put(in.readUTF(), in.readUTF());
                    }
                    break;
                }
                default: {
                    throw new UnexpectedSwitchValueException(version);
                }
            }
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeInt(1);
            out.writeUTF(this.orEmptyString(this.clientName));
            out.writeUTF(this.orEmptyString(this.gitTag));
            out.writeUTF(this.orEmptyString(this.gitTagLong));
            out.writeUTF(this.orEmptyString(this.gitBranch));
            out.writeBoolean(this.gitDirty);
            out.writeUTF(this.orEmptyString(this.gitCommitHash));
            out.writeUTF(this.orEmptyString(this.gitCommitTimestamp));
            out.writeUTF(this.orEmptyString(this.uniqueClientId));
            ArrayList<Map.Entry<String, String>> auxiliaryDataList = new ArrayList<Map.Entry<String, String>>(this.auxiliaryData.entrySet());
            out.writeInt(auxiliaryDataList.size());
            for (Map.Entry<String, String> entry : auxiliaryDataList) {
                out.writeUTF(entry.getKey());
                out.writeUTF(entry.getValue());
            }
        }

        public ClientInfo(String clientName, BuildProperties buildProperties, String uniqueClientId) {
            this(clientName, buildProperties.getGitTag(), buildProperties.getGitTagLong(), buildProperties.getGitBranch(), buildProperties.getGitDirty(), buildProperties.getGitCommitHash(), buildProperties.getGitCommitTimestamp(), uniqueClientId);
        }

        public ClientInfo(String clientName, String gitTag, String gitTagLong, String gitBranch, boolean gitDirty, String gitCommitHash, String gitCommitTimestamp, String uniqueClientId) {
            this.clientName = this.orEmptyString(clientName);
            this.gitTag = this.orEmptyString(gitTag);
            this.gitTagLong = this.orEmptyString(gitTagLong);
            this.gitBranch = this.orEmptyString(gitBranch);
            this.gitDirty = gitDirty;
            this.gitCommitHash = this.orEmptyString(gitCommitHash);
            this.gitCommitTimestamp = this.orEmptyString(gitCommitTimestamp);
            this.uniqueClientId = this.orEmptyString(uniqueClientId);
        }

        private String orEmptyString(String str) {
            return str == null ? "" : str;
        }

        public String getClientName() {
            return this.orEmptyString(this.clientName);
        }

        public String getGitTag() {
            return this.orEmptyString(this.gitTag);
        }

        public String getGitTagLong() {
            return this.orEmptyString(this.gitTagLong);
        }

        public String getGitBranch() {
            return this.orEmptyString(this.gitBranch);
        }

        public boolean getGitDirty() {
            return this.gitDirty;
        }

        public String getGitCommitHash() {
            return this.orEmptyString(this.gitCommitHash);
        }

        public String getGitCommitTimestamp() {
            return this.orEmptyString(this.gitCommitTimestamp);
        }

        public String getUniqueClientId() {
            return this.orEmptyString(this.uniqueClientId);
        }

        public void putAuxiliaryData(String key, String value) {
            this.auxiliaryData.put(key, value);
        }

        public String getAuxiliaryData(String key) {
            return this.auxiliaryData.get(key);
        }

        public boolean hasAuxiliaryData(String key) {
            return this.auxiliaryData.containsKey(key);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("ClientInfo{");
            sb.append("clientName='").append(this.clientName).append('\'');
            sb.append(", gitTag='").append(this.gitTag).append('\'');
            sb.append(", gitTagLong='").append(this.gitTagLong).append('\'');
            sb.append(", gitBranch='").append(this.gitBranch).append('\'');
            sb.append(", gitDirty=").append(this.gitDirty);
            sb.append(", gitCommitHash='").append(this.gitCommitHash).append('\'');
            sb.append(", gitCommitTimestamp='").append(this.gitCommitTimestamp).append('\'');
            sb.append(", uniqueClientId='").append(this.uniqueClientId).append('\'');
            sb.append(", auxiliaryData=").append(this.auxiliaryData);
            sb.append('}');
            return sb.toString();
        }
    }
}

