/*
 * Decompiled with CFR 0.152.
 */
package de.eobs.setuptool.rest.api;

import com.google.common.base.Preconditions;
import de.eobs.setuptool.rest.api.TagId;
import de.eobs.setuptool.tagconfig.CfgHeader;
import de.eobs.setuptool.tagconfig.TagConfigFactory;
import de.eobs.setuptool.tagconfig.TagConfigGeneric;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Optional;

public class TagInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int tagId;
    private boolean isCurrentConfig;
    private boolean expertOptionsEnabled;
    private TagConfigGeneric config;
    private CfgHeader currentCfgHeader;
    private TagConfigGeneric currentConfig;
    private TagConfigGeneric updateConfig;

    @Deprecated
    public TagInfo(int tagId, TagConfigGeneric config, boolean isCurrentConfig, boolean expertOptionsEnabled) {
        Preconditions.checkNotNull((Object)config, (Object)"config");
        this.tagId = tagId;
        this.config = config;
        this.isCurrentConfig = isCurrentConfig;
        this.expertOptionsEnabled = expertOptionsEnabled;
        this.currentCfgHeader = null;
        this.currentConfig = null;
        this.updateConfig = null;
    }

    public TagInfo(int tagId, TagConfigGeneric config, boolean isCurrentConfig, boolean expertOptionsEnabled, CfgHeader cfgHeader, TagConfigGeneric currentConfig, TagConfigGeneric updateConfig) {
        Preconditions.checkNotNull((Object)config, (Object)"config");
        Preconditions.checkNotNull((Object)cfgHeader, (Object)"cfgHeader");
        Preconditions.checkNotNull((Object)currentConfig, (Object)"currentConfig");
        Preconditions.checkNotNull((Object)updateConfig, (Object)"updateConfig");
        this.tagId = tagId;
        this.config = config;
        this.isCurrentConfig = isCurrentConfig;
        this.expertOptionsEnabled = expertOptionsEnabled;
        this.currentCfgHeader = cfgHeader;
        this.currentConfig = currentConfig;
        this.updateConfig = updateConfig;
    }

    public TagInfo(int tagId, TagConfigGeneric config, boolean isCurrentConfig, boolean expertOptionsEnabled, CfgHeader cfgHeader, TagConfigGeneric currentConfig) {
        Preconditions.checkNotNull((Object)config, (Object)"config");
        Preconditions.checkNotNull((Object)cfgHeader, (Object)"cfgHeader");
        Preconditions.checkNotNull((Object)currentConfig, (Object)"currentConfig");
        this.tagId = tagId;
        this.config = config;
        this.isCurrentConfig = isCurrentConfig;
        this.expertOptionsEnabled = expertOptionsEnabled;
        this.currentCfgHeader = cfgHeader;
        this.currentConfig = currentConfig;
        this.updateConfig = null;
    }

    public TagId getTagId() {
        return new TagId(this.tagId);
    }

    @Deprecated
    public TagConfigGeneric getConfig() {
        return this.config;
    }

    @Deprecated
    public boolean isCurrentConfig() {
        return this.isCurrentConfig;
    }

    public boolean exportOptionsEnabled() {
        return this.expertOptionsEnabled;
    }

    public CfgHeader getCurrentHeader() {
        return this.currentCfgHeader;
    }

    public TagConfigGeneric getCurrentConfig() {
        return this.currentConfig;
    }

    public Optional<TagConfigGeneric> getUpdateConfig() {
        return Optional.ofNullable(this.updateConfig);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeInt(1);
        stream.writeInt(this.tagId);
        stream.writeBoolean(this.isCurrentConfig);
        stream.writeBoolean(this.expertOptionsEnabled);
        byte[] configBytes = this.config.toBytes();
        stream.writeInt(configBytes.length);
        stream.write(configBytes);
        byte[] currentCfgHeaderBytes = this.currentCfgHeader.toBytes();
        stream.writeInt(currentCfgHeaderBytes.length);
        stream.write(currentCfgHeaderBytes);
        byte[] currentConfigBytes = this.currentConfig.toBytes();
        stream.writeInt(currentConfigBytes.length);
        stream.write(currentConfigBytes);
        if (this.updateConfig == null) {
            stream.writeInt(0);
        } else {
            byte[] updateConfigBytes = this.updateConfig.toBytes();
            stream.writeInt(updateConfigBytes.length);
            stream.write(updateConfigBytes);
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        int version = stream.readInt();
        if (version != 1) {
            throw new IllegalStateException("unexpected version: " + version);
        }
        this.tagId = stream.readInt();
        this.isCurrentConfig = stream.readBoolean();
        this.expertOptionsEnabled = stream.readBoolean();
        byte[] configBytes = new byte[stream.readInt()];
        stream.readFully(configBytes);
        this.config = TagConfigFactory.fromBytes(configBytes);
        byte[] currentCfgHeaderBytes = new byte[stream.readInt()];
        stream.readFully(currentCfgHeaderBytes);
        this.currentCfgHeader = new CfgHeader(currentCfgHeaderBytes);
        byte[] currentConfigBytes = new byte[stream.readInt()];
        stream.readFully(currentConfigBytes);
        this.currentConfig = TagConfigFactory.fromBytes(currentConfigBytes);
        int updateConfigBytesSize = stream.readInt();
        if (updateConfigBytesSize == 0) {
            this.updateConfig = null;
        } else {
            byte[] updateConfigBytes = new byte[updateConfigBytesSize];
            stream.readFully(updateConfigBytes);
            this.updateConfig = TagConfigFactory.fromBytes(updateConfigBytes);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TagInfo{");
        sb.append("tagId=").append(this.tagId);
        sb.append(", isCurrentConfig=").append(this.isCurrentConfig);
        sb.append(", expertOptionsEnabled=").append(this.expertOptionsEnabled);
        sb.append(", config=").append(this.config);
        sb.append(", currentCfgHeader=").append(this.currentCfgHeader);
        sb.append(", currentConfig=").append(this.currentConfig);
        sb.append(", updateConfig=").append(this.updateConfig);
        sb.append('}');
        return sb.toString();
    }
}

