/*
 * Decompiled with CFR 0.152.
 */
package de.eobs.setuptool.rest.api;

import com.google.common.base.Preconditions;
import de.eobs.setuptool.tagconfig.CfgHeader;
import de.eobs.setuptool.tagconfig.TagConfigGeneric;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class TagRawConfig {
    private int tagId;
    private int ticketId;
    private TagConfigGeneric tagConfig;

    public TagRawConfig(int tagId, int ticketId, TagConfigGeneric tagConfig) {
        this.tagId = tagId;
        this.ticketId = ticketId;
        this.tagConfig = (TagConfigGeneric)Preconditions.checkNotNull((Object)tagConfig, (Object)"tagConfig");
    }

    public void writeTo(ZipOutputStream zip) throws IOException {
        byte[] cfgHeaderBuffer = new CfgHeader(this.tagId, this.ticketId).toBytes();
        byte[] tagConfigBuffer = this.tagConfig.toBytes();
        ZipEntry zipEntry = new ZipEntry(String.format("cfg%d.eob", this.tagId));
        zipEntry.setSize(cfgHeaderBuffer.length + tagConfigBuffer.length);
        zip.putNextEntry(zipEntry);
        zip.write(cfgHeaderBuffer);
        zip.write(tagConfigBuffer);
    }
}

