/*
 * Decompiled with CFR 0.152.
 */
package de.eobs.setuptool.tagconfig;

import com.google.common.base.Preconditions;
import de.eobs.setuptool.tagconfig.S32;
import de.eobs.setuptool.tagconfig.S64;
import de.eobs.setuptool.tagconfig.Ticket;
import de.eobs.setuptool.tagconfig.U16;
import de.eobs.setuptool.tagconfig.U32;
import de.eobs.setuptool.tagconfig.U8Array;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import java.util.StringJoiner;

public class CfgHeader {
    private static final int SIZE_OF_STRUCT_TS_CFG_HEADER_V0 = 256;
    static final int HEADER_MAGICNUMBER = 17224;
    private static final int HEADER_VERSION = 0;
    private static final int RESERVERD_SIZE = 186;
    private static final int TS_CFG_HEADER_FLAGS0_TICKET_IS_VALID = 0;
    private static final int TS_CFG_HEADER_FLAGS0_SAME_CFGDATA = 1;
    private static final int TS_CFG_HEADER_FLAGS0_ERROR = 2;
    private static final int TS_CFG_HEADER_FLAGS0_CFGDATA_MANIPULATED = 3;
    private final U16 magic = new U16(17224);
    private final U32 version = new U32(0L);
    private final U32 tag_id = new U32(0L);
    private final U32 ticket = new U32(0L);
    private final U32 flags0 = new U32(0L);
    private final U32 error_code = new U32(0L);
    private final S64 timestamp = new S64(0L);
    private final S32 batvoltage = new S32(0);
    private final S32 longitude = new S32(0);
    private final S32 latitude = new S32(0);
    private final S64 gpsfixtime = new S64(0L);
    private final S32 bytes_available = new S32(0);
    private final S32 bytes_downloaded = new S32(0);
    private final S64 tag_connect_times = new S64(0L);
    private final S32 gprs_duration = new S32(0);
    private final U8Array reserved = new U8Array(186);

    public CfgHeader(byte[] bytes) {
        this();
        this.fromBytes(bytes);
    }

    public CfgHeader(int tagId) {
        this();
        this.tag_id.setValue(tagId);
        this.ticket.setValue(0L);
    }

    public CfgHeader(int tagId, int ticketId) {
        this();
        this.tag_id.setValue(tagId);
        this.ticket.setValue(ticketId);
        this.setTicketIsValid();
    }

    public CfgHeader(int tagId, int ticketId, int errorCode) {
        this();
        this.tag_id.setValue(tagId);
        this.ticket.setValue(ticketId);
        this.setTicketIsValid();
        this.error_code.setValue(errorCode);
        if (errorCode == 0) {
            this.flags0.clearBit(2);
        } else {
            this.flags0.setBit(2);
        }
    }

    private CfgHeader() {
    }

    public static byte[] removeHeaderIfPresent(byte[] configBytes) {
        if (CfgHeader.isPresent(configBytes)) {
            return Arrays.copyOfRange(configBytes, 256, configBytes.length);
        }
        return configBytes;
    }

    private void fromBytes(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        this.magic.readFrom(buffer);
        this.version.readFrom(buffer);
        this.tag_id.readFrom(buffer);
        this.ticket.readFrom(buffer);
        this.flags0.readFrom(buffer);
        this.error_code.readFrom(buffer);
        this.timestamp.readFrom(buffer);
        this.batvoltage.readFrom(buffer);
        this.longitude.readFrom(buffer);
        this.latitude.readFrom(buffer);
        this.gpsfixtime.readFrom(buffer);
        this.bytes_available.readFrom(buffer);
        this.bytes_downloaded.readFrom(buffer);
        this.tag_connect_times.readFrom(buffer);
        this.gprs_duration.readFrom(buffer);
        this.reserved.readFrom(buffer);
        Preconditions.checkArgument((boolean)this.checkHeaderFields(), (Object)("Illegal values in header fields: " + this.dumpHeaderFields()));
    }

    private boolean checkHeaderFields() {
        if (this.magic.getValue() != 17224) {
            return false;
        }
        return this.version.getValue() == 0L;
    }

    private String dumpHeaderFields() {
        return String.format("magic=0x%04x, version=0x%04x", this.magic.getValue(), this.version.getValue());
    }

    public byte[] toBytes() {
        ByteBuffer buffer = ByteBuffer.allocate(256);
        this.magic.writeTo(buffer);
        this.version.writeTo(buffer);
        this.tag_id.writeTo(buffer);
        this.ticket.writeTo(buffer);
        this.flags0.writeTo(buffer);
        this.error_code.writeTo(buffer);
        this.timestamp.writeTo(buffer);
        this.batvoltage.writeTo(buffer);
        this.longitude.writeTo(buffer);
        this.latitude.writeTo(buffer);
        this.gpsfixtime.writeTo(buffer);
        this.bytes_available.writeTo(buffer);
        this.bytes_downloaded.writeTo(buffer);
        this.tag_connect_times.writeTo(buffer);
        this.gprs_duration.writeTo(buffer);
        this.reserved.writeTo(buffer);
        return buffer.array();
    }

    public int getTagId() {
        return (int)this.tag_id.getValue();
    }

    public Ticket getTicket() {
        if (this.isTicketValid()) {
            return new Ticket((int)this.ticket.getValue(), this.hasError(), this.getErrorCode(), this.cfgDataSame(), this.cfgDataManipulated());
        }
        return Ticket.createInvalidTicket();
    }

    private boolean isTicketValid() {
        return this.flags0.getBit(0);
    }

    private void setTicketIsValid() {
        this.flags0.setBit(0);
    }

    private boolean cfgDataSame() {
        return this.flags0.getBit(1);
    }

    public boolean hasError() {
        return this.flags0.getBit(2);
    }

    public long getErrorCode() {
        return this.error_code.getValue();
    }

    private boolean cfgDataManipulated() {
        return this.flags0.getBit(3);
    }

    public S64 getTimestamp() {
        return this.timestamp;
    }

    public S32 getBatvoltage() {
        return this.batvoltage;
    }

    public S32 getLatitude() {
        return this.latitude;
    }

    public S32 getLongitude() {
        return this.longitude;
    }

    public S64 getGpsfixtime() {
        return this.gpsfixtime;
    }

    public S32 getBytesAvailable() {
        return this.bytes_available;
    }

    public S32 getBytesDownloaded() {
        return this.bytes_downloaded;
    }

    public S64 getTagConnectTimes() {
        return this.tag_connect_times;
    }

    public S32 getGprsDuration() {
        return this.gprs_duration;
    }

    public static boolean isPresent(byte[] bytes) {
        return CfgHeader.isPresent(ByteBuffer.wrap(bytes));
    }

    public static boolean isPresent(ByteBuffer buffer) {
        if (buffer.remaining() < 2) {
            return false;
        }
        U16 u16 = new U16();
        int position = buffer.position();
        u16.readFrom(buffer);
        buffer.position(position);
        return u16.getValue() == 17224;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CfgHeader cfgHeader = (CfgHeader)o;
        return Arrays.equals(this.toBytes(), cfgHeader.toBytes());
    }

    public int hashCode() {
        return Objects.hash(this.magic, this.version, this.tag_id, this.ticket, this.flags0, this.error_code, this.reserved);
    }

    public String toString() {
        return new StringJoiner(", ", CfgHeader.class.getSimpleName() + "[", "]").add("magic=" + this.magic).add("version=" + this.version).add("tag_id=" + this.tag_id).add("ticket=" + this.ticket).add("flags0=" + this.flags0).add("error_code=" + this.error_code).add("timestamp=" + this.timestamp).add("batvoltage=" + this.batvoltage).add("gpsfixtime=" + this.gpsfixtime).add("bytes_available=" + this.bytes_available).add("bytes_downloaded=" + this.bytes_downloaded).add("tag_connect_times=" + this.tag_connect_times).add("reserved=" + this.reserved).toString();
    }
}

