/*
 * Decompiled with CFR 0.152.
 */
package de.eobs.setuptool.tagconfig;

import de.eobs.setuptool.tagconfig.TagConfigGenericImpl;
import de.eobs.setuptool.tagconfig.U8;

class CheckSum {
    final U8 ck0 = new U8();
    final U8 ck1 = new U8();

    CheckSum(byte[] buffer, int count) {
        int CRC_acc = 65535;
        for (int k = 0; k < count; ++k) {
            int CRC_input = buffer[k] & 0xFF;
            CRC_acc ^= CRC_input << 8;
            for (int i = 0; i < 8; ++i) {
                if ((CRC_acc & 0x8000) != 0) {
                    CRC_acc <<= 1;
                    CRC_acc ^= 0x1021;
                } else {
                    CRC_acc <<= 1;
                }
                CRC_acc &= 0xFFFF;
            }
        }
        this.ck0.setValue(CRC_acc >> 0 & 0xFF);
        this.ck1.setValue(CRC_acc >> 8 & 0xFF);
    }

    void updateCheckSum(TagConfigGenericImpl tagConfig) {
        tagConfig.ck0().setValue(this.ck0.getValue());
        tagConfig.ck1().setValue(this.ck1.getValue());
    }

    boolean verifyChecksum(TagConfigGenericImpl tagConfig) {
        return tagConfig.ck0().getValue() == this.ck0.getValue() && tagConfig.ck1().getValue() == this.ck1.getValue();
    }
}

