/*
 * Decompiled with CFR 0.152.
 */
package de.eobs.setuptool.tagconfig;

import com.google.common.collect.ImmutableList;
import de.eobs.setuptool.tagconfig.U16;
import de.eobs.setuptool.tagconfig.U32;
import de.eobs.setuptool.tagconfig.U8;
import java.util.List;

public interface HeaderFields {
    public static final int CFG_MAGICNUMBER_SINCE_2009_12_27 = 39738;

    public U16 magic();

    public U8 eobs_tag_type();

    public U8 software_major_version();

    public U8 other_version();

    public U32 swfeatures();

    public boolean hasSwFeaturesEnabled(Feature ... var1);

    public boolean hasSwFeaturesDisabled(Feature ... var1);

    public static enum Feature {
        WITH_SOLAR_POWER(0),
        WITH_ACC_VARIANCE(1),
        DEAD_PINGER(2),
        WITH_PING2ONTIME(3),
        WITH_GSM(4),
        WITH_BURST_MODE(5),
        WITH_DELAYED_START(6),
        WITH_GPS_NOT_EVERY_DAY(7),
        WITH_EIDOLON_FEATURES(8),
        WITH_SUPER_BURST(9),
        WITH_ROIHAREL_FACTORS(10),
        WITH_MMA8452_SMBUS(11),
        WITH_BAND_916MHZ(12),
        WITH_BAND_920MHZ(13),
        WITH_GPSACCGSMV2(14),
        WITH_SOLARVARIANCE(15),
        WITH_BOTHSENSORSBOTTOMSIDE(16),
        WITH_ON2TIMES(17);

        final int bit;

        private Feature(int bit) {
            this.bit = bit;
        }

        void set(HeaderFields headerFields) {
            this.set(headerFields.swfeatures());
        }

        void set(U32 register) {
            register.setBit(this.bit);
        }

        boolean get(HeaderFields headerFields) {
            return this.get(headerFields.swfeatures());
        }

        boolean get(U32 register) {
            return register.getBit(this.bit);
        }

        public void clear(HeaderFields headerFields) {
            this.clear(headerFields.swfeatures());
        }

        void clear(U32 register) {
            register.clearBit(this.bit);
        }

        static int firstUnusedBit() {
            return Feature.values().length;
        }

        public static List<Feature> enabledFlags(U32 swfeatures) {
            ImmutableList.Builder enabledFeatures = new ImmutableList.Builder();
            for (Feature f : Feature.values()) {
                if (!f.get(swfeatures)) continue;
                enabledFeatures.add((Object)f);
            }
            return enabledFeatures.build();
        }

        public long getAsLongFlag() {
            return 1L << this.bit;
        }
    }
}

