/*
 * Decompiled with CFR 0.152.
 */
package de.eobs.setuptool.tagconfig;

import com.google.common.base.Preconditions;
import de.eobs.setuptool.tagconfig.Primitive;
import java.nio.ByteBuffer;

public class S64
implements Primitive {
    public static final long LOWER_BOUND = Long.MIN_VALUE;
    public static final long UPPER_BOUND = Long.MAX_VALUE;
    private long value;

    S64() {
        this(0L);
    }

    S64(long value) {
        this.setValue(value);
    }

    public void setValue(long value) {
        this.value = value;
    }

    public long getValue() {
        return this.value;
    }

    @Override
    public int sizeInBytes() {
        return 8;
    }

    @Override
    public void writeTo(ByteBuffer buffer) {
        buffer.put((byte)(this.value >> 0 & 0xFFL));
        buffer.put((byte)(this.value >> 8 & 0xFFL));
        buffer.put((byte)(this.value >> 16 & 0xFFL));
        buffer.put((byte)(this.value >> 24 & 0xFFL));
        buffer.put((byte)(this.value >> 32 & 0xFFL));
        buffer.put((byte)(this.value >> 40 & 0xFFL));
        buffer.put((byte)(this.value >> 48 & 0xFFL));
        buffer.put((byte)(this.value >> 56 & 0xFFL));
    }

    @Override
    public void readFrom(ByteBuffer buffer) {
        this.value = 0L;
        this.value += ((long)buffer.get() & 0xFFL) << 0;
        this.value += ((long)buffer.get() & 0xFFL) << 8;
        this.value += ((long)buffer.get() & 0xFFL) << 16;
        this.value += ((long)buffer.get() & 0xFFL) << 24;
        this.value += ((long)buffer.get() & 0xFFL) << 32;
        this.value += ((long)buffer.get() & 0xFFL) << 40;
        this.value += ((long)buffer.get() & 0xFFL) << 48;
        this.value += ((long)buffer.get() & 0xFFL) << 56;
    }

    public String toString() {
        return String.format("%016X", this.value);
    }

    public void setBit(int bit) {
        Preconditions.checkArgument((bit >= 0 ? 1 : 0) != 0, (Object)("bit lower than 0: " + bit));
        Preconditions.checkArgument((bit <= 63 ? 1 : 0) != 0, (Object)("bit greater than 63: " + bit));
        this.value |= 1L << bit;
    }

    public void clearBit(int bit) {
        Preconditions.checkArgument((bit >= 0 ? 1 : 0) != 0, (Object)("bit lower than 0: " + bit));
        Preconditions.checkArgument((bit <= 63 ? 1 : 0) != 0, (Object)("bit greater than 63: " + bit));
        this.value &= 1L << bit ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public boolean getBit(int bit) {
        Preconditions.checkArgument((bit >= 0 ? 1 : 0) != 0, (Object)("bit lower than 0: " + bit));
        Preconditions.checkArgument((bit <= 63 ? 1 : 0) != 0, (Object)("bit greater than 63: " + bit));
        return (this.value & 1L << bit) == 1L << bit;
    }
}

