/*
 * Decompiled with CFR 0.152.
 */
package de.eobs.setuptool.tagconfig;

import de.eobs.setuptool.tagconfig.Primitive;
import java.nio.ByteBuffer;

public class S8
implements Primitive {
    public static final int LOWER_BOUND = -128;
    public static final int UPPER_BOUND = 127;
    private int value;

    S8() {
        this(0);
    }

    S8(int value) {
        this.setValue(value);
    }

    public void setValue(int value) {
        if (value < -128) {
            throw new IllegalArgumentException(Integer.toString(value));
        }
        if (value > 127) {
            throw new IllegalArgumentException(Integer.toString(value));
        }
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    @Override
    public int sizeInBytes() {
        return 1;
    }

    @Override
    public void writeTo(ByteBuffer buffer) {
        buffer.put((byte)(this.value >> 0 & 0xFF));
    }

    @Override
    public void readFrom(ByteBuffer buffer) {
        this.value = buffer.get();
    }

    public String toString() {
        return String.format("%02X", this.value);
    }

    boolean hasMask(int flag) {
        return (this.getValue() & flag) == flag;
    }

    void clearMask(int flag) {
        this.setValue(this.getValue() & ~flag);
    }

    void setMask(int flag) {
        this.setValue(this.getValue() | flag);
    }
}

