/*
 * Decompiled with CFR 0.152.
 */
package de.eobs.setuptool.tagconfig;

import de.eobs.setuptool.tagconfig.Od;
import de.eobs.setuptool.tagconfig.TagConfigGeneric;
import de.eobs.setuptool.tagconfig.TagConfigV0;
import de.eobs.setuptool.tagconfig.TagConfigV0Impl;
import de.eobs.setuptool.tagconfig.TagConfigV1;
import de.eobs.setuptool.tagconfig.TagConfigV1Impl;
import de.eobs.setuptool.tagconfig.TagConfigV2;
import de.eobs.setuptool.tagconfig.TagConfigV2Impl;
import de.eobs.setuptool.tagconfig.U8;
import de.eobs.setuptool.util.UnexpectedSwitchValueException;
import java.nio.ByteBuffer;

public class TagConfigFactory {
    public static final byte[] defaultConfigV0AsByteArray() {
        return Od.undump("0000000 3a 9b 05 0a 00 f1 00 00 00 7f a2 34 0c 7b 0c eb\n0000020 0b 90 0a ae 0b f6 08 14 00 84 03 58 02 58 02 58\n0000040 02 bc 02 01 49 1f 20 00 08 85 02 c1 02 08 07 10\n0000060 0e 10 0e 96 00 01 01 32 00 01 00 01 00 00 01 00\n0000100 00 9f 05 58 02 3f 00 03 01 38 04 00 00 00 00 10\n0000120 27 00 00 50 c3 00 00 05 02 04 00 ff ff ff 00 00\n0000140 00 00 00 ff ff ff 00 00 00 00 e8 03 00 00 14 00\n0000160 e8 03 00 00 05 00 ce 15 20 00 2b 34 39 31 35 31\n0000200 36 32 36 33 30 30 39 35 00 00 00 00 00 00 00 00\n0000220 00 00 d7 0b 21 43 65 ff 80 3a 09 00 00 00 2c 01\n0000240 10 0e 3c 00 ff 00 58 02 c3 09 05 57 ce\n0000255\n");
    }

    public static final byte[] defaultConfigV1AsByteArray() {
        return Od.undump("0000000 3a 9b 05 0a 01 f1 06 00 00 7f a2 34 0c 7b 0c eb\n0000020 0b 90 0a ae 0b f6 08 14 00 84 03 58 02 58 02 58\n0000040 02 bc 02 01 49 1f 20 00 08 85 02 c1 02 08 07 10\n0000060 0e 10 0e 96 00 01 01 32 00 01 00 01 00 00 01 00\n0000100 00 9f 05 58 02 3f 00 03 01 38 04 00 00 00 00 10\n0000120 27 00 00 50 c3 00 00 05 02 04 00 ff ff ff 00 00\n0000140 00 00 00 ff ff ff 00 00 00 00 e8 03 00 00 14 00\n0000160 e8 03 00 00 05 00 ce 15 20 00 2b 34 39 31 35 31\n0000200 36 32 36 33 30 30 39 35 00 00 00 00 00 00 00 00\n0000220 00 00 d7 0b 21 43 65 ff 80 3a 09 00 00 00 2c 01\n0000240 10 0e 3c 00 ff 00 58 02 c3 09 05 a0 0f 58 02 2c\n0000260 01 04 00 d6 83\n0000265\n");
    }

    public static final byte[] defaultConfigV2AsByteArray() {
        return Od.undump("0000400 3a 9b 05 0a 02 11 48 00 00 7f a2 34 0c a0 0f 7b\n0000420 0c d7 0b eb 0b 0a 0b e2 0a ae 0b 0a 0b 84 03 58\n0000440 02 58 02 01 62 34 20 00 00 00 9f 05 2c 01 08 07\n0000460 20 1c 96 00 01 01 00 01 05 01 00 01 00 00 01 00\n0000500 00 9f 05 2c 01 1e 00 58 02 b4 00 05 01 38 00 00\n0000520 00 00 00 10 27 00 00 05 1e 00 05 02 02 01 64 00\n0000540 64 00 64 00 64 00 03 00 00 00 00 e8 03 00 00 14\n0000560 00 e8 03 00 00 05 00 ce 15 20 00 80 3a 09 00 00\n0000600 00 58 02 00 00 10 0e 3c 00 58 02 84 03 05 84 03\n0000620 01 2c 01 04 00 2c 01 1e 00 01 02 01 00 00 00 00\n0000640 00 00 00 00 00 00 00 00 00 00 00 00 28 00 00 00\n0000660 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00\n0000700 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00\n0000720 00 00 be e2\n0000724\n");
    }

    public static TagConfigV0 defaultConfigV0() {
        return (TagConfigV0)TagConfigFactory.fromBytes(TagConfigFactory.defaultConfigV0AsByteArray());
    }

    public static TagConfigV1 defaultConfigV1() {
        return (TagConfigV1)TagConfigFactory.fromBytes(TagConfigFactory.defaultConfigV1AsByteArray());
    }

    public static TagConfigV2 defaultConfigV2() {
        return (TagConfigV2)TagConfigFactory.fromBytes(TagConfigFactory.defaultConfigV2AsByteArray());
    }

    public static TagConfigGeneric fromBytes(byte[] rawTagConfig) {
        if (rawTagConfig.length < 5) {
            throw new IllegalArgumentException("raw tag config bytes to short: " + rawTagConfig.length);
        }
        rawTagConfig = TagConfigFactory.stripCfgHeader(rawTagConfig);
        int structVersion = TagConfigFactory.getStructVersion(rawTagConfig);
        switch (structVersion) {
            case 0: {
                return new TagConfigV0Impl(rawTagConfig);
            }
            case 1: {
                return new TagConfigV1Impl(rawTagConfig);
            }
            case 2: {
                return new TagConfigV2Impl(rawTagConfig);
            }
        }
        throw new UnexpectedSwitchValueException(structVersion);
    }

    static byte[] stripCfgHeader(byte[] rawTagConfig) {
        if (rawTagConfig[0] == 72 && rawTagConfig[1] == 67) {
            byte[] configBytes = new byte[rawTagConfig.length - 256];
            System.arraycopy(rawTagConfig, 256, configBytes, 0, configBytes.length);
            return configBytes;
        }
        return rawTagConfig;
    }

    private static int getStructVersion(byte[] byteArray) {
        ByteBuffer buffer = ByteBuffer.wrap(byteArray);
        buffer.position(4);
        U8 struct_version = new U8();
        struct_version.readFrom(buffer);
        return struct_version.getValue();
    }
}

