/*
 * Decompiled with CFR 0.152.
 */
package de.eobs.setuptool.tagconfig;

import com.google.common.collect.ImmutableSet;
import com.google.common.hash.HashCode;
import de.eobs.setuptool.tagconfig.CheckSum;
import de.eobs.setuptool.tagconfig.HeaderFields;
import de.eobs.setuptool.tagconfig.TagConfigGeneric;
import de.eobs.setuptool.tagconfig.U32;
import de.eobs.setuptool.tagconfig.U8;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Set;

abstract class TagConfigGenericImpl
implements TagConfigGeneric {
    private final int sizeOfStructTagConfig;

    protected TagConfigGenericImpl(int sizeOfStructTagConfig) {
        this.sizeOfStructTagConfig = sizeOfStructTagConfig;
    }

    protected abstract U8 ck0();

    protected abstract U8 ck1();

    @Override
    public byte[] toBytes() {
        ByteBuffer buffer = ByteBuffer.allocate(this.sizeOfStructTagConfig);
        this.writeWithoutChecksum(buffer);
        new CheckSum(buffer.array(), this.sizeOfStructTagConfig - 2).updateCheckSum(this);
        this.ck0().writeTo(buffer);
        this.ck1().writeTo(buffer);
        return buffer.array();
    }

    protected abstract void writeWithoutChecksum(ByteBuffer var1);

    public int hashCode() {
        return HashCode.fromBytes((byte[])this.toBytes()).hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TagConfigGeneric that = (TagConfigGeneric)o;
        return Arrays.equals(this.toBytes(), that.toBytes());
    }

    @Override
    public boolean hasSwFeaturesEnabled(HeaderFields.Feature ... features) {
        for (HeaderFields.Feature f : features) {
            if (f.get(this)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasSwFeaturesDisabled(HeaderFields.Feature ... features) {
        for (HeaderFields.Feature f : features) {
            if (!f.get(this)) continue;
            return false;
        }
        return true;
    }

    Set<HeaderFields.Feature> getEnabledFeatures() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (HeaderFields.Feature f : HeaderFields.Feature.values()) {
            if (!f.get(this)) continue;
            builder.add((Object)f);
        }
        return builder.build();
    }

    boolean hasUnsupportedSwFeatures(HeaderFields.Feature ... supportedFeatures) {
        U32 features = new U32(this.swfeatures().getValue());
        for (HeaderFields.Feature f : supportedFeatures) {
            f.clear(features);
        }
        return features.getValue() > 0L;
    }
}

