/*
 * Decompiled with CFR 0.152.
 */
package de.eobs.setuptool.tagconfig;

import com.google.common.base.Preconditions;
import de.eobs.setuptool.tagconfig.CheckSum;
import de.eobs.setuptool.tagconfig.HeaderFields;
import de.eobs.setuptool.tagconfig.TagConfigDispatch;
import de.eobs.setuptool.tagconfig.TagConfigGenericImpl;
import de.eobs.setuptool.tagconfig.TagConfigV1;
import de.eobs.setuptool.tagconfig.TimeLimits;
import de.eobs.setuptool.tagconfig.U16;
import de.eobs.setuptool.tagconfig.U32;
import de.eobs.setuptool.tagconfig.U8;
import de.eobs.setuptool.tagconfig.U8Array;
import java.nio.ByteBuffer;

class TagConfigV1Impl
extends TagConfigGenericImpl
implements TagConfigV1 {
    private static final int SIZE_OF_STRUCT_TAG_CONFIG_V0 = 181;
    private static final int CFG0_USE_ROI_HAREL_FACTORS = 2;
    private static final int CFG0_ACC_USE_X = 8;
    private static final int CFG0_ACC_USE_Y = 16;
    private static final int CFG0_ACC_USE_Z = 32;
    private static final int CFG0_ACC_INVERSE_SPEED_FACTOR = 64;
    private static final int CFG1_ACC_CHECK_X = 1;
    private static final int CFG1_ACC_CHECK_Y = 2;
    private static final int CFG1_ACC_CHECK_Z = 4;
    private static final int CFG1_USE_869_85_TX = 8;
    private static final int TELNUMBERBUFSIZE = 24;
    public static final int CFG_MAGICNUMBER = 39738;
    public static final int FEATURE_WITH_SOLAR_POWER = 1;
    public static final int FEATURE_WITH_ACC_VARIANCE = 2;
    public static final int FEATURE_DEAD_PINGER = 4;
    public static final int FEATURE_WITH_PING2ONTIME = 8;
    public static final int FEATURE_WITH_GSM = 16;
    public static final int FEATURE_WITH_BURST_MODE = 32;
    public static final int FEATURE_WITH_DELAYED_START = 64;
    public static final int FEATURE_WITH_GPS_NOT_EVERY_DAY = 128;
    public static final int FEATURE_WITH_EIDOLON_FEATURES = 256;
    private final U16 magic = new U16(0);
    private final U8 eobs_tag_type = new U8(0);
    private final U8 software_major_version = new U8(0);
    private final U8 struct_version = new U8(0);
    private final U32 swfeatures = new U32(0L);
    private final U8 security_switch = new U8(0);
    private final U16 secret_key = new U16(0);
    private final U8 access_key = new U8(0);
    private final U16 bat_threshold2 = new U16(0);
    private final U16 bat_threshold1 = new U16(0);
    private final U16 bat_threshold0 = new U16(0);
    private final U16 bat_acc_threshold = new U16(0);
    private final U16 maccess_voltlimit = new U16(0);
    private final U16 radio_interval = new U16(0);
    private final U16 radio_longdelay = new U16(0);
    private final TimeLimits ping_ontime = new TimeLimits(0, 0);
    private final TimeLimits ping2_ontime = new TimeLimits(0, 0);
    private final U8 pinger_interval = new U8(0);
    private final U32 freq_pinger = new U32(0L);
    private final U8 rf_pingpower = new U8(0);
    private final TimeLimits gps_ontime = new TimeLimits(0, 0);
    private final U16 gps_interval = new U16(0);
    private final U16 gps_medium_res_interval = new U16(0);
    private final U16 gps_low_res_interval = new U16(0);
    private final U16 gps_timeout = new U16(0);
    private final U8 gps_interval_retry_factor = new U8(0);
    private final U8 lowspeed_gps_interval_factor = new U8(0);
    private final U16 gps_speed_thr = new U16(0);
    private final U16 burst_length = new U16(0);
    private final U8 burst_qperiod = new U8(0);
    private final U16 gps_hourshift = new U16(0);
    private final U8 gps_daydivisor = new U8(0);
    private final TimeLimits acc_ontime = new TimeLimits(0, 0);
    private final U16 acc_interval = new U16(0);
    private final U16 acc_bytecnt = new U16(0);
    private final U8 acc_samplerate = new U8(0);
    private final U8 lowspeed_acc_interval_factor = new U8(0);
    private final U8 flags0 = new U8(0);
    private final U8 flags1 = new U8(0);
    private final U32 device_start_time = new U32(0L);
    private final U32 acc_l_threshold = new U32(0L);
    private final U32 acc_h_threshold = new U32(0L);
    private final U8 acc_param_n1 = new U8(0);
    private final U8 acc_param_n2 = new U8(0);
    private final U8 acc_param_n4 = new U8(0);
    private final U32 max_gpsacctime = new U32(0L);
    private final U32 ping_start_time = new U32(0L);
    private final U32 ping_stop_time = new U32(0L);
    private final U32 radiolink_start_time = new U32(0L);
    private final U32 acc_dead_threshold = new U32(0L);
    private final U16 dead_counter_threshold = new U16(0);
    private final U32 acc_alive_threshold = new U32(0L);
    private final U16 alive_counter_threshold = new U16(0);
    private final U32 freq_dead_pinger = new U32(0L);
    private final U8Array sms_number = new U8Array(24);
    private final U16 bat_gsm_threshold = new U16(0);
    private final U32 gsm_stop_time = new U32(0L);
    private final U32 gsm_bigger_interval = new U32(0L);
    private final U16 sms_time = new U16(5);
    private final U16 gprs_time = new U16(5);
    private final U16 sms_gps_collect_interval1 = new U16(0);
    private final U16 sms_gps_collect_offset1 = new U16(0);
    private final U16 sms_timeout = new U16(0);
    private final U16 gprs_timeout = new U16(0);
    private final U16 bat_gprs_download_threshold = new U16(0);
    private final U8 gprs_min_pk_freq = new U8(0);
    private final U16 bat_threshold3 = new U16(0);
    private final U16 super_burst_length = new U16(0);
    private final U16 super_low_speed_gps_interval = new U16(0);
    private final U16 super_memory_limit = new U16(0);
    private final U8 ck0 = new U8(0);
    private final U8 ck1 = new U8(0);

    @Override
    protected U8 ck0() {
        return this.ck0;
    }

    @Override
    protected U8 ck1() {
        return this.ck1;
    }

    TagConfigV1Impl(byte[] rawConfig) {
        this();
        this.fromBytes(rawConfig);
    }

    private TagConfigV1Impl() {
        super(181);
    }

    @Override
    public U16 magic() {
        return this.magic;
    }

    @Override
    public U8 eobs_tag_type() {
        return this.eobs_tag_type;
    }

    @Override
    public U8 software_major_version() {
        return this.software_major_version;
    }

    @Override
    public U8 other_version() {
        return this.struct_version;
    }

    @Override
    public U32 swfeatures() {
        return this.swfeatures;
    }

    @Override
    public boolean checkHeaderFields() {
        if (this.magic().getValue() != 39738) {
            return false;
        }
        if (this.eobs_tag_type().getValue() != 5) {
            return false;
        }
        if (this.software_major_version().getValue() != 10) {
            return false;
        }
        if (this.other_version().getValue() != 1) {
            return false;
        }
        if (!this.hasSwFeaturesEnabled(HeaderFields.Feature.WITH_SOLAR_POWER, HeaderFields.Feature.WITH_GSM, HeaderFields.Feature.WITH_BURST_MODE, HeaderFields.Feature.WITH_DELAYED_START, HeaderFields.Feature.WITH_GPS_NOT_EVERY_DAY)) {
            return false;
        }
        if (!this.hasSwFeaturesDisabled(HeaderFields.Feature.WITH_ACC_VARIANCE, HeaderFields.Feature.DEAD_PINGER, HeaderFields.Feature.WITH_PING2ONTIME, HeaderFields.Feature.WITH_EIDOLON_FEATURES)) {
            return false;
        }
        return !this.hasUnsupportedSwFeatures(HeaderFields.Feature.WITH_SOLAR_POWER, HeaderFields.Feature.WITH_ACC_VARIANCE, HeaderFields.Feature.DEAD_PINGER, HeaderFields.Feature.WITH_PING2ONTIME, HeaderFields.Feature.WITH_GSM, HeaderFields.Feature.WITH_BURST_MODE, HeaderFields.Feature.WITH_DELAYED_START, HeaderFields.Feature.WITH_GPS_NOT_EVERY_DAY, HeaderFields.Feature.WITH_EIDOLON_FEATURES, HeaderFields.Feature.WITH_SUPER_BURST, HeaderFields.Feature.WITH_ROIHAREL_FACTORS, HeaderFields.Feature.WITH_MMA8452_SMBUS, HeaderFields.Feature.WITH_BAND_916MHZ, HeaderFields.Feature.WITH_GPSACCGSMV2);
    }

    String dumpHeaderFields() {
        StringBuilder sb = new StringBuilder();
        sb.append("magic:");
        sb.append(Integer.toHexString(this.magic.getValue()));
        sb.append(", ");
        sb.append("eobs_tag_type:");
        sb.append(Integer.toHexString(this.eobs_tag_type.getValue()));
        sb.append(", ");
        sb.append("software_major_version:");
        sb.append(Integer.toHexString(this.software_major_version().getValue()));
        sb.append(", ");
        sb.append("other_version:");
        sb.append(Integer.toHexString(this.other_version().getValue()));
        sb.append(", ");
        sb.append("swfeatures:");
        sb.append(Long.toBinaryString(this.swfeatures.getValue()));
        return sb.toString();
    }

    @Override
    public U8 security_switch() {
        return this.security_switch;
    }

    @Override
    public U16 gps_medium_res_interval() {
        return this.gps_medium_res_interval;
    }

    @Override
    public U16 gps_interval() {
        return this.gps_interval;
    }

    @Override
    public TimeLimits gps_ontime() {
        return this.gps_ontime;
    }

    @Override
    public TimeLimits ping_ontime() {
        return this.ping_ontime;
    }

    @Override
    public U16 acc_interval() {
        return this.acc_interval;
    }

    @Override
    public U16 acc_bytecnt() {
        return this.acc_bytecnt;
    }

    @Override
    public U8 acc_samplerate() {
        return this.acc_samplerate;
    }

    @Override
    public TimeLimits acc_ontime() {
        return this.acc_ontime;
    }

    @Override
    public void setAccUseXAxis() {
        this.flags0.setMask(8);
    }

    @Override
    public void clearAccUseXAxis() {
        this.flags0.clearMask(8);
    }

    @Override
    public boolean getAccUseXAxis() {
        return this.flags0.hasMask(8);
    }

    @Override
    public void setAccUseYAxis() {
        this.flags0.setMask(16);
    }

    @Override
    public void clearAccUseYAxis() {
        this.flags0.clearMask(16);
    }

    @Override
    public boolean getAccUseYAxis() {
        return this.flags0.hasMask(16);
    }

    @Override
    public void setAccUseZAxis() {
        this.flags0.setMask(32);
    }

    @Override
    public void clearAccUseZAxis() {
        this.flags0.clearMask(32);
    }

    @Override
    public boolean getAccUseZAxis() {
        return this.flags0.hasMask(32);
    }

    @Override
    public void setUse_869_85_TX() {
        this.flags1.setMask(8);
    }

    @Override
    public void clearUse_869_85_TX() {
        this.flags1.clearMask(8);
    }

    @Override
    public boolean getUse_869_85_TX() {
        return this.flags1.hasMask(8);
    }

    @Override
    public U8 lowspeed_acc_interval_factor() {
        return this.lowspeed_acc_interval_factor;
    }

    @Override
    public U8 gps_daydivisor() {
        return this.gps_daydivisor;
    }

    @Override
    public U16 gps_hourshift() {
        return this.gps_hourshift;
    }

    @Override
    public U8 gps_interval_retry_factor() {
        return this.gps_interval_retry_factor;
    }

    @Override
    public U8 lowspeed_gps_interval_factor() {
        return this.lowspeed_gps_interval_factor;
    }

    @Override
    public U16 gps_speed_thr() {
        return this.gps_speed_thr;
    }

    @Override
    public U16 gps_timeout() {
        return this.gps_timeout;
    }

    @Override
    public U16 burst_length() {
        return this.burst_length;
    }

    @Override
    public U8 burst_qperiod() {
        return this.burst_qperiod;
    }

    @Override
    public U32 device_start_time() {
        return this.device_start_time;
    }

    @Override
    public U8 pinger_interval() {
        return this.pinger_interval;
    }

    @Override
    public U16 secret_key() {
        return this.secret_key;
    }

    @Override
    public U8 access_key() {
        return this.access_key;
    }

    @Override
    public U16 sms_time() {
        return this.sms_time;
    }

    @Override
    public U16 gprs_time() {
        return this.gprs_time;
    }

    @Override
    public U16 sms_gps_collect_interval1() {
        return this.sms_gps_collect_interval1;
    }

    @Override
    public U16 sms_gps_collect_offset1() {
        return this.sms_gps_collect_offset1;
    }

    @Override
    public U32 gsm_bigger_interval() {
        return this.gsm_bigger_interval;
    }

    @Override
    public U32 gsm_stop_time() {
        return this.gsm_stop_time;
    }

    @Override
    public void setInverseLowSpeedIntervalFactor() {
        this.flags0.setMask(64);
    }

    @Override
    public void clearInverseLowSpeedIntervalFactor() {
        this.flags0.clearMask(64);
    }

    @Override
    public boolean getInverseLowSpeedIntervalFactor() {
        return this.flags0.hasMask(64);
    }

    @Override
    public U32 freq_pinger() {
        return this.freq_pinger;
    }

    @Override
    public U16 super_burst_length() {
        return this.super_burst_length;
    }

    @Override
    public U16 super_low_speed_gps_interval() {
        return this.super_low_speed_gps_interval;
    }

    @Override
    public U16 super_memory_limit() {
        return this.super_memory_limit;
    }

    @Override
    public void setUseRoiHarelFactors() {
        this.flags0.setMask(2);
    }

    @Override
    public void clearUseRoiHarelFactors() {
        this.flags0.clearMask(2);
    }

    @Override
    public boolean getUseRoiHarelFactors() {
        return this.flags0.hasMask(2);
    }

    @Override
    public U16 bat_threshold2() {
        return this.bat_threshold2;
    }

    @Override
    public U16 bat_threshold1() {
        return this.bat_threshold1;
    }

    @Override
    public U16 bat_threshold0() {
        return this.bat_threshold0;
    }

    @Override
    public U16 bat_acc_threshold() {
        return this.bat_acc_threshold;
    }

    @Override
    public U16 bat_threshold3() {
        return this.bat_threshold3;
    }

    @Override
    public U16 bat_gsm_threshold() {
        return this.bat_gsm_threshold;
    }

    @Override
    public U16 sms_timeout() {
        return this.sms_timeout;
    }

    @Override
    public U16 gprs_timeout() {
        return this.gprs_timeout;
    }

    @Override
    public U16 bat_gprs_download_threshold() {
        return this.bat_gprs_download_threshold;
    }

    @Override
    public U8 gprs_min_pk_freq() {
        return this.gprs_min_pk_freq;
    }

    @Override
    public U16 maccess_voltlimit() {
        return this.maccess_voltlimit;
    }

    @Override
    public U16 radio_interval() {
        return this.radio_interval;
    }

    @Override
    public U16 radio_longdelay() {
        return this.radio_longdelay;
    }

    @Override
    public U32 freq_dead_pinger() {
        return this.freq_dead_pinger;
    }

    @Override
    protected void writeWithoutChecksum(ByteBuffer buffer) {
        this.magic.writeTo(buffer);
        this.eobs_tag_type.writeTo(buffer);
        this.software_major_version.writeTo(buffer);
        this.struct_version.writeTo(buffer);
        this.swfeatures.writeTo(buffer);
        this.security_switch.writeTo(buffer);
        this.secret_key.writeTo(buffer);
        this.access_key.writeTo(buffer);
        this.bat_threshold2.writeTo(buffer);
        this.bat_threshold1.writeTo(buffer);
        this.bat_threshold0.writeTo(buffer);
        this.bat_acc_threshold.writeTo(buffer);
        this.maccess_voltlimit.writeTo(buffer);
        this.radio_interval.writeTo(buffer);
        this.radio_longdelay.writeTo(buffer);
        this.ping_ontime.writeTo(buffer);
        this.ping2_ontime.writeTo(buffer);
        this.pinger_interval.writeTo(buffer);
        this.freq_pinger.writeTo(buffer);
        this.rf_pingpower.writeTo(buffer);
        this.gps_ontime.writeTo(buffer);
        this.gps_interval.writeTo(buffer);
        this.gps_medium_res_interval.writeTo(buffer);
        this.gps_low_res_interval.writeTo(buffer);
        this.gps_timeout.writeTo(buffer);
        this.gps_interval_retry_factor.writeTo(buffer);
        this.lowspeed_gps_interval_factor.writeTo(buffer);
        this.gps_speed_thr.writeTo(buffer);
        this.burst_length.writeTo(buffer);
        this.burst_qperiod.writeTo(buffer);
        this.gps_hourshift.writeTo(buffer);
        this.gps_daydivisor.writeTo(buffer);
        this.acc_ontime.writeTo(buffer);
        this.acc_interval.writeTo(buffer);
        this.acc_bytecnt.writeTo(buffer);
        this.acc_samplerate.writeTo(buffer);
        this.lowspeed_acc_interval_factor.writeTo(buffer);
        this.flags0.writeTo(buffer);
        this.flags1.writeTo(buffer);
        this.device_start_time.writeTo(buffer);
        this.acc_l_threshold.writeTo(buffer);
        this.acc_h_threshold.writeTo(buffer);
        this.acc_param_n1.writeTo(buffer);
        this.acc_param_n2.writeTo(buffer);
        this.acc_param_n4.writeTo(buffer);
        this.max_gpsacctime.writeTo(buffer);
        this.ping_start_time.writeTo(buffer);
        this.ping_stop_time.writeTo(buffer);
        this.radiolink_start_time.writeTo(buffer);
        this.acc_dead_threshold.writeTo(buffer);
        this.dead_counter_threshold.writeTo(buffer);
        this.acc_alive_threshold.writeTo(buffer);
        this.alive_counter_threshold.writeTo(buffer);
        this.freq_dead_pinger.writeTo(buffer);
        this.sms_number.writeTo(buffer);
        this.bat_gsm_threshold.writeTo(buffer);
        this.gsm_stop_time.writeTo(buffer);
        this.gsm_bigger_interval.writeTo(buffer);
        this.sms_time.writeTo(buffer);
        this.gprs_time.writeTo(buffer);
        this.sms_gps_collect_interval1.writeTo(buffer);
        this.sms_gps_collect_offset1.writeTo(buffer);
        this.sms_timeout.writeTo(buffer);
        this.gprs_timeout.writeTo(buffer);
        this.bat_gprs_download_threshold.writeTo(buffer);
        this.gprs_min_pk_freq.writeTo(buffer);
        this.bat_threshold3.writeTo(buffer);
        this.super_burst_length.writeTo(buffer);
        this.super_low_speed_gps_interval.writeTo(buffer);
        this.super_memory_limit.writeTo(buffer);
    }

    private void fromBytes(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        this.magic.readFrom(buffer);
        this.eobs_tag_type.readFrom(buffer);
        this.software_major_version.readFrom(buffer);
        this.struct_version.readFrom(buffer);
        this.swfeatures.readFrom(buffer);
        this.security_switch.readFrom(buffer);
        this.secret_key.readFrom(buffer);
        this.access_key.readFrom(buffer);
        this.bat_threshold2.readFrom(buffer);
        this.bat_threshold1.readFrom(buffer);
        this.bat_threshold0.readFrom(buffer);
        this.bat_acc_threshold.readFrom(buffer);
        this.maccess_voltlimit.readFrom(buffer);
        this.radio_interval.readFrom(buffer);
        this.radio_longdelay.readFrom(buffer);
        this.ping_ontime.readFrom(buffer);
        this.ping2_ontime.readFrom(buffer);
        this.pinger_interval.readFrom(buffer);
        this.freq_pinger.readFrom(buffer);
        this.rf_pingpower.readFrom(buffer);
        this.gps_ontime.readFrom(buffer);
        this.gps_interval.readFrom(buffer);
        this.gps_medium_res_interval.readFrom(buffer);
        this.gps_low_res_interval.readFrom(buffer);
        this.gps_timeout.readFrom(buffer);
        this.gps_interval_retry_factor.readFrom(buffer);
        this.lowspeed_gps_interval_factor.readFrom(buffer);
        this.gps_speed_thr.readFrom(buffer);
        this.burst_length.readFrom(buffer);
        this.burst_qperiod.readFrom(buffer);
        this.gps_hourshift.readFrom(buffer);
        this.gps_daydivisor.readFrom(buffer);
        this.acc_ontime.readFrom(buffer);
        this.acc_interval.readFrom(buffer);
        this.acc_bytecnt.readFrom(buffer);
        this.acc_samplerate.readFrom(buffer);
        this.lowspeed_acc_interval_factor.readFrom(buffer);
        this.flags0.readFrom(buffer);
        this.flags1.readFrom(buffer);
        this.device_start_time.readFrom(buffer);
        this.acc_l_threshold.readFrom(buffer);
        this.acc_h_threshold.readFrom(buffer);
        this.acc_param_n1.readFrom(buffer);
        this.acc_param_n2.readFrom(buffer);
        this.acc_param_n4.readFrom(buffer);
        this.max_gpsacctime.readFrom(buffer);
        this.ping_start_time.readFrom(buffer);
        this.ping_stop_time.readFrom(buffer);
        this.radiolink_start_time.readFrom(buffer);
        this.acc_dead_threshold.readFrom(buffer);
        this.dead_counter_threshold.readFrom(buffer);
        this.acc_alive_threshold.readFrom(buffer);
        this.alive_counter_threshold.readFrom(buffer);
        this.freq_dead_pinger.readFrom(buffer);
        this.sms_number.readFrom(buffer);
        this.bat_gsm_threshold.readFrom(buffer);
        this.gsm_stop_time.readFrom(buffer);
        this.gsm_bigger_interval.readFrom(buffer);
        this.sms_time.readFrom(buffer);
        this.gprs_time.readFrom(buffer);
        this.sms_gps_collect_interval1.readFrom(buffer);
        this.sms_gps_collect_offset1.readFrom(buffer);
        this.sms_timeout.readFrom(buffer);
        this.gprs_timeout.readFrom(buffer);
        this.bat_gprs_download_threshold.readFrom(buffer);
        this.gprs_min_pk_freq.readFrom(buffer);
        this.bat_threshold3.readFrom(buffer);
        this.super_burst_length.readFrom(buffer);
        this.super_low_speed_gps_interval.readFrom(buffer);
        this.super_memory_limit.readFrom(buffer);
        this.ck0.readFrom(buffer);
        this.ck1.readFrom(buffer);
        Preconditions.checkArgument((boolean)new CheckSum(bytes, 179).verifyChecksum(this), (Object)"Checksum error.");
        Preconditions.checkArgument((boolean)this.checkHeaderFields(), (Object)("Illegal values in header fields: " + this.dumpHeaderFields()));
    }

    @Override
    public TagConfigV1 copy() {
        return new TagConfigV1Impl(this.toBytes());
    }

    @Override
    public <T> T dispatch(TagConfigDispatch<T> tagConfigDispatch) {
        return tagConfigDispatch.onV1(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TagConfigV1Impl{");
        sb.append("magic=").append(this.magic);
        sb.append(", eobs_tag_type=").append(this.eobs_tag_type);
        sb.append(", software_major_version=").append(this.software_major_version);
        sb.append(", other_version=").append(this.struct_version);
        sb.append(", swfeatures=").append(this.swfeatures);
        sb.append(", security_switch=").append(this.security_switch);
        sb.append(", secret_key=").append(this.secret_key);
        sb.append(", access_key=").append(this.access_key);
        sb.append(", bat_threshold2=").append(this.bat_threshold2);
        sb.append(", bat_threshold1=").append(this.bat_threshold1);
        sb.append(", bat_threshold0=").append(this.bat_threshold0);
        sb.append(", bat_acc_threshold=").append(this.bat_acc_threshold);
        sb.append(", maccess_voltlimit=").append(this.maccess_voltlimit);
        sb.append(", radio_interval=").append(this.radio_interval);
        sb.append(", radio_longdelay=").append(this.radio_longdelay);
        sb.append(", ping_ontime=").append(this.ping_ontime);
        sb.append(", ping2_ontime=").append(this.ping2_ontime);
        sb.append(", pinger_interval=").append(this.pinger_interval);
        sb.append(", freq_pinger=").append(this.freq_pinger);
        sb.append(", rf_pingpower=").append(this.rf_pingpower);
        sb.append(", gps_ontime=").append(this.gps_ontime);
        sb.append(", gps_interval=").append(this.gps_interval);
        sb.append(", gps_medium_res_interval=").append(this.gps_medium_res_interval);
        sb.append(", gps_low_res_interval=").append(this.gps_low_res_interval);
        sb.append(", gps_timeout=").append(this.gps_timeout);
        sb.append(", gps_interval_retry_factor=").append(this.gps_interval_retry_factor);
        sb.append(", lowspeed_gps_interval_factor=").append(this.lowspeed_gps_interval_factor);
        sb.append(", gps_speed_thr=").append(this.gps_speed_thr);
        sb.append(", burst_length=").append(this.burst_length);
        sb.append(", burst_qperiod=").append(this.burst_qperiod);
        sb.append(", gps_hourshift=").append(this.gps_hourshift);
        sb.append(", gps_daydivisor=").append(this.gps_daydivisor);
        sb.append(", acc_ontime=").append(this.acc_ontime);
        sb.append(", acc_interval=").append(this.acc_interval);
        sb.append(", acc_bytecnt=").append(this.acc_bytecnt);
        sb.append(", acc_samplerate=").append(this.acc_samplerate);
        sb.append(", lowspeed_acc_interval_factor=").append(this.lowspeed_acc_interval_factor);
        sb.append(", flags0=").append(this.flags0);
        sb.append(", flags1=").append(this.flags1);
        sb.append(", device_start_time=").append(this.device_start_time);
        sb.append(", acc_l_threshold=").append(this.acc_l_threshold);
        sb.append(", acc_h_threshold=").append(this.acc_h_threshold);
        sb.append(", acc_param_n1=").append(this.acc_param_n1);
        sb.append(", acc_param_n2=").append(this.acc_param_n2);
        sb.append(", acc_param_n4=").append(this.acc_param_n4);
        sb.append(", max_gpsacctime=").append(this.max_gpsacctime);
        sb.append(", ping_start_time=").append(this.ping_start_time);
        sb.append(", ping_stop_time=").append(this.ping_stop_time);
        sb.append(", radiolink_start_time=").append(this.radiolink_start_time);
        sb.append(", acc_dead_threshold=").append(this.acc_dead_threshold);
        sb.append(", dead_counter_threshold=").append(this.dead_counter_threshold);
        sb.append(", acc_alive_threshold=").append(this.acc_alive_threshold);
        sb.append(", alive_counter_threshold=").append(this.alive_counter_threshold);
        sb.append(", freq_dead_pinger=").append(this.freq_dead_pinger);
        sb.append(", sms_number=").append(this.sms_number);
        sb.append(", bat_gsm_threshold=").append(this.bat_gsm_threshold);
        sb.append(", gsm_stop_time=").append(this.gsm_stop_time);
        sb.append(", gsm_bigger_interval=").append(this.gsm_bigger_interval);
        sb.append(", sms_time=").append(this.sms_time);
        sb.append(", gprs_time=").append(this.gprs_time);
        sb.append(", sms_gps_collect_interval1=").append(this.sms_gps_collect_interval1);
        sb.append(", sms_gps_collect_offset1=").append(this.sms_gps_collect_offset1);
        sb.append(", sms_timeout=").append(this.sms_timeout);
        sb.append(", gprs_timeout=").append(this.gprs_timeout);
        sb.append(", bat_gprs_download_threshold=").append(this.bat_gprs_download_threshold);
        sb.append(", gprs_min_pk_freq=").append(this.gprs_min_pk_freq);
        sb.append(", bat_threshold3=").append(this.bat_threshold3);
        sb.append(", super_burst_length=").append(this.super_burst_length);
        sb.append(", super_low_speed_gps_interval=").append(this.super_low_speed_gps_interval);
        sb.append(", super_memory_limit=").append(this.super_memory_limit);
        sb.append(", ck0=").append(this.ck0);
        sb.append(", ck1=").append(this.ck1);
        sb.append('}');
        return sb.toString();
    }
}

