/*
 * Decompiled with CFR 0.152.
 */
package de.eobs.setuptool.tagconfig;

import com.google.common.base.Preconditions;
import de.eobs.setuptool.rest.api.TagId;
import de.eobs.setuptool.tagconfig.CheckSum;
import de.eobs.setuptool.tagconfig.HeaderFields;
import de.eobs.setuptool.tagconfig.S8;
import de.eobs.setuptool.tagconfig.TagConfigDispatch;
import de.eobs.setuptool.tagconfig.TagConfigGenericImpl;
import de.eobs.setuptool.tagconfig.TagConfigV2;
import de.eobs.setuptool.tagconfig.TimeLimits;
import de.eobs.setuptool.tagconfig.U16;
import de.eobs.setuptool.tagconfig.U32;
import de.eobs.setuptool.tagconfig.U8;
import de.eobs.setuptool.tagconfig.U8Array;
import java.nio.ByteBuffer;

class TagConfigV2Impl
extends TagConfigGenericImpl
implements TagConfigV2 {
    private static final int SIZE_OF_STRUCT_TAG_CONFIG_V0 = 212;
    private static final int CFG0_USE_ROI_HAREL_FACTORS = 2;
    private static final int CFG0_ACC_USE_X = 8;
    private static final int CFG0_ACC_USE_Y = 16;
    private static final int CFG0_ACC_USE_Z = 32;
    private static final int CFG0_ACC_INVERSE_SPEED_FACTOR = 64;
    private static final int CFG0_DOWNLOAD_TEST = 128;
    private static final int CFG1_AI_IGNORE_VAR1 = 1;
    private static final int CFG1_AI_IGNORE_ANG1 = 2;
    private static final int CFG1_AI_IGNORE_LOWRES = 4;
    private static final int CFG1_USE_869_85_TX = 8;
    private static final int TELNUMBERBUFSIZE = 24;
    public static final int CFG_MAGICNUMBER = 39738;
    public static final int FEATURE_WITH_SOLAR_POWER = 1;
    public static final int FEATURE_WITH_ACC_VARIANCE = 2;
    public static final int FEATURE_DEAD_PINGER = 4;
    public static final int FEATURE_WITH_PING2ONTIME = 8;
    public static final int FEATURE_WITH_GSM = 16;
    public static final int FEATURE_WITH_BURST_MODE = 32;
    public static final int FEATURE_WITH_DELAYED_START = 64;
    public static final int FEATURE_WITH_GPS_NOT_EVERY_DAY = 128;
    public static final int FEATURE_WITH_EIDOLON_FEATURES = 256;
    public static final int FEATURE_WITH_ON2TIMES = 8192;
    private final U16 magic = new U16(0);
    private final U8 eobs_tag_type = new U8(0);
    private final U8 software_major_version = new U8(0);
    private final U8 struct_version = new U8(0);
    private final U32 swfeatures = new U32(0L);
    private final U8 security_switch = new U8(0);
    private final U16 secret_key = new U16(0);
    private final U8 access_key = new U8(0);
    private final U16 bat_threshold3 = new U16(0);
    private final U16 bat_threshold2 = new U16(0);
    private final U16 bat_gsm_threshold = new U16(0);
    private final U16 bat_threshold1 = new U16(0);
    private final U16 bat_threshold0 = new U16(0);
    private final U16 bat_gprs_download_threshold = new U16(0);
    private final U16 bat_acc_threshold = new U16(0);
    private final U16 maccess_voltlimit = new U16(0);
    private final U16 radio_longdelay = new U16(0);
    private final TimeLimits ping_ontime = new TimeLimits(0, 0);
    private final U8 pinger_interval = new U8(0);
    private final U32 freq_pinger = new U32(0L);
    private final TimeLimits gps_ontime = new TimeLimits(0, 0);
    private final U16 gps_high_res_interval = new U16(0);
    private final U16 gps_low_res_interval = new U16(0);
    private final U16 gps_lowbat_interval = new U16(0);
    private final U16 gps_timeout = new U16(0);
    private final U8 gps_interval_retry_factor = new U8(0);
    private final U16 burst_length = new U16(0);
    private final U8 burst_qperiod = new U8(0);
    private final U8 burst_lowspd_fixcnt = new U8(0);
    private final U16 lowbat_burst_length = new U16(0);
    private final U8 lowbat_burst_qperiod = new U8(0);
    private final U16 gps_hourshift = new U16(0);
    private final U8 gps_daydivisor = new U8(0);
    private final TimeLimits acc_ontime = new TimeLimits(0, 0);
    private final U16 acc_interval = new U16(0);
    private final U16 variance_interval = new U16(0);
    private final U16 acc_lowbat_interval = new U16(0);
    private final U16 acc_bytecnt = new U16(0);
    private final U8 acc_samplerate = new U8(0);
    private final U8 lowspeed_acc_interval_factor = new U8(0);
    private final U8 flags0 = new U8(0);
    final U8 flags1 = new U8(0);
    private final U32 device_start_time = new U32(0L);
    private final U32 acc_var_threshold = new U32(0L);
    private final U8 acc_var_samplerate = new U8(0);
    private final U16 acc_var_bytecnt = new U16(0);
    private final U8 acc_param_n1 = new U8(0);
    private final U8 acc_param_n2 = new U8(0);
    private final U8 variance_axis = new U8(0);
    private final U8 tilt_second_axis = new U8(0);
    private final U16 speed_threshold1 = new U16(0);
    private final U16 speed_threshold2 = new U16(0);
    private final U16 speed_threshold3 = new U16(0);
    private final U16 speed_threshold4 = new U16(0);
    private final U8 speed_param_n1 = new U8(0);
    private final S8 acc_yf = new S8(0);
    private final S8 acc_zf = new S8(0);
    private final S8 accoffset_yf = new S8(0);
    private final S8 accoffset_zf = new S8(0);
    private final U32 acc_dead_threshold = new U32(0L);
    private final U16 dead_counter_threshold = new U16(0);
    private final U32 acc_alive_threshold = new U32(0L);
    private final U16 alive_counter_threshold = new U16(0);
    private final U32 freq_dead_pinger = new U32(0L);
    private final U32 gsm_bigger_interval = new U32(0L);
    private final U16 sms_time = new U16(5);
    private final U16 gprs_time = new U16(5);
    private final U16 gprs2_time = new U16(5);
    private final U16 sms_gps_collect_interval1 = new U16(0);
    private final U16 sms_gps_collect_offset1 = new U16(0);
    private final U16 sms_timeout = new U16(0);
    private final U16 gprs_timeout = new U16(0);
    private final U8 gprs_min_pk_freq = new U8(0);
    private final U16 sm_burst_length = new U16(0);
    private final U8 sm_burst_qperiod = new U8(0);
    private final U16 sm_low_res_gps_interval = new U16(0);
    private final U16 sm_memory_limit = new U16(0);
    private final U16 sm_acc_interval = new U16(0);
    private final U16 sm_variance_interval = new U16(0);
    private final U8 sm_acc_param_n1 = new U8(0);
    private final U8 sm_acc_param_n2 = new U8(0);
    private final U8 sm_burst_lowspd_fixcnt = new U8(0);
    private final U16 sm_imu_interval = new U16(0);
    private final U8 flags2 = new U8(0);
    private final U8 flags3 = new U8(0);
    private final U8 imu_acc_datasetcount = new U8(0);
    private final U8 res1 = new U8(0);
    private final U8 imu_quatcomp_datasetcount = new U8(0);
    private final U8 res2 = new U8(0);
    private final U16 imu_interval = new U16(0);
    private final U16 imu_lowbat_interval = new U16(0);
    private final TimeLimits imu_ontime = new TimeLimits(0, 0);
    private final U8 imu_start_delay = new U8(0);
    private final U16 gprs3_time = new U16(0);
    private TimeLimits gps_on2time = new TimeLimits(0, 0);
    private TimeLimits acc_on2time = new TimeLimits(0, 0);
    private TimeLimits imu_on2time = new TimeLimits(0, 0);
    private final U8Array reserved = new U8Array(23);
    private final U8 ck0 = new U8(0);
    private final U8 ck1 = new U8(0);

    @Override
    protected U8 ck0() {
        return this.ck0;
    }

    @Override
    protected U8 ck1() {
        return this.ck1;
    }

    TagConfigV2Impl(byte[] rawConfig) {
        this();
        this.fromBytes(rawConfig);
    }

    private TagConfigV2Impl() {
        super(212);
    }

    @Override
    public U16 magic() {
        return this.magic;
    }

    @Override
    public U8 eobs_tag_type() {
        return this.eobs_tag_type;
    }

    @Override
    public U8 software_major_version() {
        return this.software_major_version;
    }

    @Override
    public U8 other_version() {
        return this.struct_version;
    }

    @Override
    public U32 swfeatures() {
        return this.swfeatures;
    }

    @Override
    public boolean checkHeaderFields() {
        if (this.magic().getValue() != 39738) {
            return false;
        }
        if (this.eobs_tag_type().getValue() != 5) {
            return false;
        }
        if (this.software_major_version().getValue() != 10) {
            return false;
        }
        if (this.other_version().getValue() != 2) {
            return false;
        }
        if (!this.hasSwFeaturesEnabled(HeaderFields.Feature.WITH_SOLAR_POWER, HeaderFields.Feature.WITH_GSM, HeaderFields.Feature.WITH_MMA8452_SMBUS, HeaderFields.Feature.WITH_GPSACCGSMV2)) {
            return false;
        }
        if (!this.hasSwFeaturesDisabled(HeaderFields.Feature.WITH_ACC_VARIANCE, HeaderFields.Feature.DEAD_PINGER, HeaderFields.Feature.WITH_PING2ONTIME, HeaderFields.Feature.WITH_EIDOLON_FEATURES)) {
            return false;
        }
        return !this.hasUnsupportedSwFeatures(HeaderFields.Feature.WITH_SOLAR_POWER, HeaderFields.Feature.WITH_GSM, HeaderFields.Feature.WITH_MMA8452_SMBUS, HeaderFields.Feature.WITH_GPSACCGSMV2, HeaderFields.Feature.WITH_BAND_916MHZ, HeaderFields.Feature.WITH_BAND_920MHZ, HeaderFields.Feature.WITH_BOTHSENSORSBOTTOMSIDE, HeaderFields.Feature.WITH_ON2TIMES);
    }

    String dumpHeaderFields() {
        StringBuilder sb = new StringBuilder();
        sb.append("magic:");
        sb.append(Integer.toHexString(this.magic.getValue()));
        sb.append(", ");
        sb.append("eobs_tag_type:");
        sb.append(Integer.toHexString(this.eobs_tag_type.getValue()));
        sb.append(", ");
        sb.append("software_major_version:");
        sb.append(Integer.toHexString(this.software_major_version().getValue()));
        sb.append(", ");
        sb.append("other_version:");
        sb.append(Integer.toHexString(this.other_version().getValue()));
        sb.append(", ");
        sb.append("swfeatures:");
        sb.append(Long.toBinaryString(this.swfeatures.getValue()));
        sb.append(", ");
        sb.append(this.getEnabledFeatures());
        return sb.toString();
    }

    @Override
    public U8 security_switch() {
        return this.security_switch;
    }

    @Override
    public TimeLimits gps_ontime() {
        return this.gps_ontime;
    }

    @Override
    public TimeLimits gps_on2time() {
        return this.gps_on2time;
    }

    @Override
    public U16 gps_high_res_interval() {
        return this.gps_high_res_interval;
    }

    @Override
    public U16 gps_low_res_interval() {
        return this.gps_low_res_interval;
    }

    @Override
    public U16 gps_low_bat_interval() {
        return this.gps_lowbat_interval;
    }

    @Override
    public U16 speed_threshold1() {
        return this.speed_threshold1;
    }

    @Override
    public U16 speed_threshold2() {
        return this.speed_threshold2;
    }

    @Override
    public U16 speed_threshold3() {
        return this.speed_threshold3;
    }

    @Override
    public U16 acc_interval() {
        return this.acc_interval;
    }

    @Override
    public U16 acc_low_bat_interval() {
        return this.acc_lowbat_interval;
    }

    @Override
    public U16 variance_interval() {
        return this.variance_interval;
    }

    @Override
    public U16 acc_byte_count() {
        return this.acc_bytecnt;
    }

    @Override
    public U8 acc_samplerate() {
        return this.acc_samplerate;
    }

    @Override
    public TimeLimits acc_ontime() {
        return this.acc_ontime;
    }

    @Override
    public TimeLimits acc_on2time() {
        return this.acc_on2time;
    }

    @Override
    public U16 imu_interval() {
        return this.imu_interval;
    }

    @Override
    public U16 imu_lowbat_interval() {
        return this.imu_lowbat_interval;
    }

    @Override
    public TimeLimits imu_ontime() {
        return this.imu_ontime;
    }

    @Override
    public TimeLimits imu_on2time() {
        return this.imu_on2time;
    }

    @Override
    public U8 imu_acc_datasetcount() {
        return this.imu_acc_datasetcount;
    }

    @Override
    public U8 imu_quatcomp_datasetcount() {
        return this.imu_quatcomp_datasetcount;
    }

    @Override
    public U8 imu_start_delay() {
        return this.imu_start_delay;
    }

    @Override
    public void setAccUseXAxis() {
        this.flags0.setMask(8);
    }

    @Override
    public void clearAccUseXAxis() {
        this.flags0.clearMask(8);
    }

    @Override
    public boolean getAccUseXAxis() {
        return this.flags0.hasMask(8);
    }

    @Override
    public void setAccUseYAxis() {
        this.flags0.setMask(16);
    }

    @Override
    public void clearAccUseYAxis() {
        this.flags0.clearMask(16);
    }

    @Override
    public boolean getAccUseYAxis() {
        return this.flags0.hasMask(16);
    }

    @Override
    public void setAccUseZAxis() {
        this.flags0.setMask(32);
    }

    @Override
    public void clearAccUseZAxis() {
        this.flags0.clearMask(32);
    }

    @Override
    public boolean getAccUseZAxis() {
        return this.flags0.hasMask(32);
    }

    @Override
    public boolean supportsUse_869_85_TX() {
        return this.hasSwFeaturesDisabled(HeaderFields.Feature.WITH_BAND_916MHZ) && this.hasSwFeaturesDisabled(HeaderFields.Feature.WITH_BAND_920MHZ);
    }

    @Override
    public void setUse_869_85_TX() {
        if (!this.supportsUse_869_85_TX()) {
            throw new UnsupportedOperationException("CFG1_USE_869_85_TX requires disabled feature flag WITH_BAND_916MHZ or WITH_BAND_920MHZ");
        }
        this.flags1.setMask(8);
    }

    @Override
    public void clearUse_869_85_TX() {
        if (!this.supportsUse_869_85_TX()) {
            throw new UnsupportedOperationException("CFG1_USE_869_85_TX requires disabled feature flag WITH_BAND_916MHZ or WITH_BAND_920MHZ");
        }
        this.flags1.clearMask(8);
    }

    @Override
    public boolean getUse_869_85_TX() {
        if (!this.supportsUse_869_85_TX()) {
            throw new UnsupportedOperationException("CFG1_USE_869_85_TX requires disabled feature flag WITH_BAND_916MHZ or WITH_BAND_920MHZ");
        }
        return this.flags1.hasMask(8);
    }

    @Override
    public U8 lowspeed_acc_interval_factor() {
        return this.lowspeed_acc_interval_factor;
    }

    @Override
    public U8 gps_day_divisor() {
        return this.gps_daydivisor;
    }

    @Override
    public U16 gps_hour_shift() {
        return this.gps_hourshift;
    }

    @Override
    public U8 gps_interval_retry_factor() {
        return this.gps_interval_retry_factor;
    }

    @Override
    public U16 gps_timeout() {
        return this.gps_timeout;
    }

    @Override
    public U16 burst_length() {
        return this.burst_length;
    }

    @Override
    public U8 burst_qperiod() {
        return this.burst_qperiod;
    }

    @Override
    public U8 flags2() {
        return this.flags2;
    }

    @Override
    public U8 flags3() {
        return this.flags3;
    }

    @Override
    public U8 burst_low_speed_fix_count() {
        return this.burst_lowspd_fixcnt;
    }

    @Override
    public U16 lowbat_burst_length() {
        return this.lowbat_burst_length;
    }

    @Override
    public U8 lowbat_burst_qperiod() {
        return this.lowbat_burst_qperiod;
    }

    @Override
    public U32 device_start_time() {
        return this.device_start_time;
    }

    @Override
    public U16 sm_burst_length() {
        return this.sm_burst_length;
    }

    @Override
    public U8 sm_burst_qperiod() {
        return this.sm_burst_qperiod;
    }

    @Override
    public U8 sm_burst_low_speed_fix_count() {
        return this.sm_burst_lowspd_fixcnt;
    }

    @Override
    public U16 sm_low_res_gps_interval() {
        return this.sm_low_res_gps_interval;
    }

    @Override
    public U16 sm_gps_mem_limit() {
        return this.sm_memory_limit;
    }

    @Override
    public U16 sm_acc_interval() {
        return this.sm_acc_interval;
    }

    @Override
    public U16 sm_variance_interval() {
        return this.sm_variance_interval;
    }

    @Override
    public U16 sm_imu_interval() {
        return this.sm_imu_interval;
    }

    @Override
    public void setInverseLowSpeedIntervalFactor() {
        this.flags0.setMask(64);
    }

    @Override
    public void clearInverseLowSpeedIntervalFactor() {
        this.flags0.clearMask(64);
    }

    @Override
    public boolean getInverseLowSpeedIntervalFactor() {
        return this.flags0.hasMask(64);
    }

    @Override
    public U16 bat_threshold3() {
        return this.bat_threshold3;
    }

    @Override
    public U16 bat_threshold2() {
        return this.bat_threshold2;
    }

    @Override
    public U16 bat_threshold1() {
        return this.bat_threshold1;
    }

    @Override
    public U16 bat_gsm_threshold() {
        return this.bat_gsm_threshold;
    }

    @Override
    public U16 bat_acc_threshold() {
        return this.bat_acc_threshold;
    }

    @Override
    public U16 bat_threshold0() {
        return this.bat_threshold0;
    }

    @Override
    public U16 maccess_voltlimit() {
        return this.maccess_voltlimit;
    }

    @Override
    public U16 bat_gprs_download_threshold() {
        return this.bat_gprs_download_threshold;
    }

    @Override
    public U16 gprs_timeout() {
        return this.gprs_timeout;
    }

    @Override
    public U16 radio_longdelay() {
        return this.radio_longdelay;
    }

    @Override
    public void setDownloadTest() {
        this.flags0.setMask(128);
    }

    @Override
    public void clearDownloadTest() {
        this.flags0.clearMask(128);
    }

    @Override
    public boolean getDownloadTest() {
        return this.flags0.hasMask(128);
    }

    @Override
    public U8 item_2() {
        return null;
    }

    @Override
    public U32 acc_var_threshold() {
        return this.acc_var_threshold;
    }

    @Override
    public U8 acc_var_samplerate() {
        return this.acc_var_samplerate;
    }

    @Override
    public U16 acc_var_bytecnt() {
        return this.acc_var_bytecnt;
    }

    @Override
    public U8 acc_param_n1() {
        return this.acc_param_n1;
    }

    @Override
    public U8 acc_param_n2() {
        return this.acc_param_n2;
    }

    @Override
    public U8 speed_param_n1() {
        return this.speed_param_n1;
    }

    @Override
    public U8 variance_axis() {
        return this.variance_axis;
    }

    @Override
    public U8 tilt_second_axis() {
        return this.tilt_second_axis;
    }

    @Override
    public S8 acc_yf() {
        return this.acc_yf;
    }

    @Override
    public S8 accoffset_yf() {
        return this.accoffset_yf;
    }

    @Override
    public S8 acc_zf() {
        return this.acc_zf;
    }

    @Override
    public S8 accoffset_zf() {
        return this.accoffset_zf;
    }

    @Override
    public U8 sm_acc_param_n1() {
        return this.sm_acc_param_n1;
    }

    @Override
    public U8 sm_acc_param_n2() {
        return this.sm_acc_param_n2;
    }

    @Override
    public void setIgnoreVarianceInSupermodeWithHighGpsResolution() {
        this.flags1.setMask(1);
    }

    @Override
    public void clearIgnoreVarianceInSupermodeWithHighGpsResolution() {
        this.flags1.clearMask(1);
    }

    @Override
    public boolean getIgnoreVarianceInSupermodeWithHighGpsResolution() {
        return this.flags1.hasMask(1);
    }

    @Override
    public void setIgnoreAngleInSupermodeWithHighGpsResolution() {
        this.flags1.setMask(2);
    }

    @Override
    public void clearIgnoreAngleInSupermodeWithHighGpsResolution() {
        this.flags1.clearMask(2);
    }

    @Override
    public boolean getIgnoreAngleInSupermodeWithHighGpsResolution() {
        return this.flags1.hasMask(2);
    }

    @Override
    public void setIgnoreLowResolutionContinueGpsBurst() {
        this.flags1.setMask(4);
    }

    @Override
    public void clearIgnoreLowResolutionContinueGpsBurst() {
        this.flags1.clearMask(4);
    }

    @Override
    public boolean getIgnoreLowResolutionContinueGpsBurst() {
        return this.flags1.hasMask(4);
    }

    @Override
    public U32 freq_dead_pinger() {
        return this.freq_dead_pinger;
    }

    @Override
    public final TimeLimits ping_ontime() {
        return this.ping_ontime;
    }

    @Override
    public final U8 pinger_interval() {
        return this.pinger_interval;
    }

    @Override
    public final U16 secret_key() {
        return this.secret_key;
    }

    @Override
    public final U8 access_key() {
        return this.access_key;
    }

    @Override
    public final U16 gprs_time() {
        return this.gprs_time;
    }

    @Override
    public final U16 gprs_time2() {
        return this.gprs2_time;
    }

    @Override
    public final U16 gprs_time3() {
        return this.gprs3_time;
    }

    @Override
    public boolean supportsGprsTime3(TagId tagId) {
        return tagId.getValue() >= 8102;
    }

    @Override
    public final U8 gprs_min_pk_freq() {
        return this.gprs_min_pk_freq;
    }

    @Override
    public final U16 sms_time() {
        return this.sms_time;
    }

    @Override
    public final U16 sms_timeout() {
        return this.sms_timeout;
    }

    @Override
    public final U16 sms_gps_collect_interval1() {
        return this.sms_gps_collect_interval1;
    }

    @Override
    public final U16 sms_gps_collect_offset1() {
        return this.sms_gps_collect_offset1;
    }

    @Override
    public final U32 gsm_big_interval() {
        return this.gsm_bigger_interval;
    }

    @Override
    public final U32 ping_frequency() {
        return this.freq_pinger;
    }

    @Override
    protected void writeWithoutChecksum(ByteBuffer buffer) {
        this.magic.writeTo(buffer);
        this.eobs_tag_type.writeTo(buffer);
        this.software_major_version.writeTo(buffer);
        this.struct_version.writeTo(buffer);
        this.swfeatures.writeTo(buffer);
        this.security_switch.writeTo(buffer);
        this.secret_key.writeTo(buffer);
        this.access_key.writeTo(buffer);
        this.bat_threshold3.writeTo(buffer);
        this.bat_threshold2.writeTo(buffer);
        this.bat_gsm_threshold.writeTo(buffer);
        this.bat_threshold1.writeTo(buffer);
        this.bat_threshold0.writeTo(buffer);
        this.bat_gprs_download_threshold.writeTo(buffer);
        this.bat_acc_threshold.writeTo(buffer);
        this.maccess_voltlimit.writeTo(buffer);
        this.radio_longdelay.writeTo(buffer);
        this.ping_ontime.writeTo(buffer);
        this.pinger_interval.writeTo(buffer);
        this.freq_pinger.writeTo(buffer);
        this.gps_ontime.writeTo(buffer);
        this.gps_high_res_interval.writeTo(buffer);
        this.gps_low_res_interval.writeTo(buffer);
        this.gps_lowbat_interval.writeTo(buffer);
        this.gps_timeout.writeTo(buffer);
        this.gps_interval_retry_factor.writeTo(buffer);
        this.burst_length.writeTo(buffer);
        this.burst_qperiod.writeTo(buffer);
        this.burst_lowspd_fixcnt.writeTo(buffer);
        this.lowbat_burst_length.writeTo(buffer);
        this.lowbat_burst_qperiod.writeTo(buffer);
        this.gps_hourshift.writeTo(buffer);
        this.gps_daydivisor.writeTo(buffer);
        this.acc_ontime.writeTo(buffer);
        this.acc_interval.writeTo(buffer);
        this.variance_interval.writeTo(buffer);
        this.acc_lowbat_interval.writeTo(buffer);
        this.acc_bytecnt.writeTo(buffer);
        this.acc_samplerate.writeTo(buffer);
        this.lowspeed_acc_interval_factor.writeTo(buffer);
        this.flags0.writeTo(buffer);
        this.flags1.writeTo(buffer);
        this.device_start_time.writeTo(buffer);
        this.acc_var_threshold.writeTo(buffer);
        this.acc_var_samplerate.writeTo(buffer);
        this.acc_var_bytecnt.writeTo(buffer);
        this.acc_param_n1.writeTo(buffer);
        this.acc_param_n2.writeTo(buffer);
        this.variance_axis.writeTo(buffer);
        this.tilt_second_axis.writeTo(buffer);
        this.speed_threshold1.writeTo(buffer);
        this.speed_threshold2.writeTo(buffer);
        this.speed_threshold3.writeTo(buffer);
        this.speed_threshold4.writeTo(buffer);
        this.speed_param_n1.writeTo(buffer);
        this.acc_yf.writeTo(buffer);
        this.acc_zf.writeTo(buffer);
        this.accoffset_yf.writeTo(buffer);
        this.accoffset_zf.writeTo(buffer);
        this.acc_dead_threshold.writeTo(buffer);
        this.dead_counter_threshold.writeTo(buffer);
        this.acc_alive_threshold.writeTo(buffer);
        this.alive_counter_threshold.writeTo(buffer);
        this.freq_dead_pinger.writeTo(buffer);
        this.gsm_bigger_interval.writeTo(buffer);
        this.sms_time.writeTo(buffer);
        this.gprs_time.writeTo(buffer);
        this.gprs2_time.writeTo(buffer);
        this.sms_gps_collect_interval1.writeTo(buffer);
        this.sms_gps_collect_offset1.writeTo(buffer);
        this.sms_timeout.writeTo(buffer);
        this.gprs_timeout.writeTo(buffer);
        this.gprs_min_pk_freq.writeTo(buffer);
        this.sm_burst_length.writeTo(buffer);
        this.sm_burst_qperiod.writeTo(buffer);
        this.sm_low_res_gps_interval.writeTo(buffer);
        this.sm_memory_limit.writeTo(buffer);
        this.sm_acc_interval.writeTo(buffer);
        this.sm_variance_interval.writeTo(buffer);
        this.sm_acc_param_n1.writeTo(buffer);
        this.sm_acc_param_n2.writeTo(buffer);
        this.sm_burst_lowspd_fixcnt.writeTo(buffer);
        this.sm_imu_interval.writeTo(buffer);
        this.flags2.writeTo(buffer);
        this.flags3.writeTo(buffer);
        this.imu_acc_datasetcount.writeTo(buffer);
        this.res1.writeTo(buffer);
        this.imu_quatcomp_datasetcount.writeTo(buffer);
        this.res2.writeTo(buffer);
        this.imu_interval.writeTo(buffer);
        this.imu_lowbat_interval.writeTo(buffer);
        this.imu_ontime.writeTo(buffer);
        this.imu_start_delay.writeTo(buffer);
        this.gprs3_time.writeTo(buffer);
        this.gps_on2time.writeTo(buffer);
        this.acc_on2time.writeTo(buffer);
        this.imu_on2time.writeTo(buffer);
        this.reserved.writeTo(buffer);
    }

    private void fromBytes(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        this.magic.readFrom(buffer);
        this.eobs_tag_type.readFrom(buffer);
        this.software_major_version.readFrom(buffer);
        this.struct_version.readFrom(buffer);
        this.swfeatures.readFrom(buffer);
        this.security_switch.readFrom(buffer);
        this.secret_key.readFrom(buffer);
        this.access_key.readFrom(buffer);
        this.bat_threshold3.readFrom(buffer);
        this.bat_threshold2.readFrom(buffer);
        this.bat_gsm_threshold.readFrom(buffer);
        this.bat_threshold1.readFrom(buffer);
        this.bat_threshold0.readFrom(buffer);
        this.bat_gprs_download_threshold.readFrom(buffer);
        this.bat_acc_threshold.readFrom(buffer);
        this.maccess_voltlimit.readFrom(buffer);
        this.radio_longdelay.readFrom(buffer);
        this.ping_ontime.readFrom(buffer);
        this.pinger_interval.readFrom(buffer);
        this.freq_pinger.readFrom(buffer);
        this.gps_ontime.readFrom(buffer);
        this.gps_high_res_interval.readFrom(buffer);
        this.gps_low_res_interval.readFrom(buffer);
        this.gps_lowbat_interval.readFrom(buffer);
        this.gps_timeout.readFrom(buffer);
        this.gps_interval_retry_factor.readFrom(buffer);
        this.burst_length.readFrom(buffer);
        this.burst_qperiod.readFrom(buffer);
        this.burst_lowspd_fixcnt.readFrom(buffer);
        this.lowbat_burst_length.readFrom(buffer);
        this.lowbat_burst_qperiod.readFrom(buffer);
        this.gps_hourshift.readFrom(buffer);
        this.gps_daydivisor.readFrom(buffer);
        this.acc_ontime.readFrom(buffer);
        this.acc_interval.readFrom(buffer);
        this.variance_interval.readFrom(buffer);
        this.acc_lowbat_interval.readFrom(buffer);
        this.acc_bytecnt.readFrom(buffer);
        this.acc_samplerate.readFrom(buffer);
        this.lowspeed_acc_interval_factor.readFrom(buffer);
        this.flags0.readFrom(buffer);
        this.flags1.readFrom(buffer);
        this.device_start_time.readFrom(buffer);
        this.acc_var_threshold.readFrom(buffer);
        this.acc_var_samplerate.readFrom(buffer);
        this.acc_var_bytecnt.readFrom(buffer);
        this.acc_param_n1.readFrom(buffer);
        this.acc_param_n2.readFrom(buffer);
        this.variance_axis.readFrom(buffer);
        this.tilt_second_axis.readFrom(buffer);
        this.speed_threshold1.readFrom(buffer);
        this.speed_threshold2.readFrom(buffer);
        this.speed_threshold3.readFrom(buffer);
        this.speed_threshold4.readFrom(buffer);
        this.speed_param_n1.readFrom(buffer);
        this.acc_yf.readFrom(buffer);
        this.acc_zf.readFrom(buffer);
        this.accoffset_yf.readFrom(buffer);
        this.accoffset_zf.readFrom(buffer);
        this.acc_dead_threshold.readFrom(buffer);
        this.dead_counter_threshold.readFrom(buffer);
        this.acc_alive_threshold.readFrom(buffer);
        this.alive_counter_threshold.readFrom(buffer);
        this.freq_dead_pinger.readFrom(buffer);
        this.gsm_bigger_interval.readFrom(buffer);
        this.sms_time.readFrom(buffer);
        this.gprs_time.readFrom(buffer);
        this.gprs2_time.readFrom(buffer);
        this.sms_gps_collect_interval1.readFrom(buffer);
        this.sms_gps_collect_offset1.readFrom(buffer);
        this.sms_timeout.readFrom(buffer);
        this.gprs_timeout.readFrom(buffer);
        this.gprs_min_pk_freq.readFrom(buffer);
        this.sm_burst_length.readFrom(buffer);
        this.sm_burst_qperiod.readFrom(buffer);
        this.sm_low_res_gps_interval.readFrom(buffer);
        this.sm_memory_limit.readFrom(buffer);
        this.sm_acc_interval.readFrom(buffer);
        this.sm_variance_interval.readFrom(buffer);
        this.sm_acc_param_n1.readFrom(buffer);
        this.sm_acc_param_n2.readFrom(buffer);
        this.sm_burst_lowspd_fixcnt.readFrom(buffer);
        this.sm_imu_interval.readFrom(buffer);
        this.flags2.readFrom(buffer);
        this.flags3.readFrom(buffer);
        this.imu_acc_datasetcount.readFrom(buffer);
        this.res1.readFrom(buffer);
        this.imu_quatcomp_datasetcount.readFrom(buffer);
        this.res2.readFrom(buffer);
        this.imu_interval.readFrom(buffer);
        this.imu_lowbat_interval.readFrom(buffer);
        this.imu_ontime.readFrom(buffer);
        this.imu_start_delay.readFrom(buffer);
        this.gprs3_time.readFrom(buffer);
        this.gps_on2time.readFrom(buffer);
        this.acc_on2time.readFrom(buffer);
        this.imu_on2time.readFrom(buffer);
        this.reserved.readFrom(buffer);
        this.ck0.readFrom(buffer);
        this.ck1.readFrom(buffer);
        Preconditions.checkArgument((boolean)new CheckSum(bytes, 210).verifyChecksum(this), (Object)"Checksum error.");
        Preconditions.checkArgument((boolean)this.checkHeaderFields(), (Object)("Illegal values in header fields: " + this.dumpHeaderFields()));
    }

    @Override
    public TagConfigV2 copy() {
        return new TagConfigV2Impl(this.toBytes());
    }

    @Override
    public <T> T dispatch(TagConfigDispatch<T> tagConfigDispatch) {
        return tagConfigDispatch.onV2(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TagConfigV2Impl{");
        sb.append("magic=").append(this.magic);
        sb.append(",\neobs_tag_type=").append(this.eobs_tag_type);
        sb.append(",\nsoftware_major_version=").append(this.software_major_version);
        sb.append(",\nstruct_version=").append(this.struct_version);
        sb.append(",\nswfeatures=").append(this.swfeatures);
        sb.append(",\nsecurity_switch=").append(this.security_switch);
        sb.append(",\nsecret_key=").append(this.secret_key);
        sb.append(",\naccess_key=").append(this.access_key);
        sb.append(",\nbat_threshold3=").append(this.bat_threshold3);
        sb.append(",\nbat_threshold2=").append(this.bat_threshold2);
        sb.append(",\nbat_gsm_threshold=").append(this.bat_gsm_threshold);
        sb.append(",\nbat_threshold1=").append(this.bat_threshold1);
        sb.append(",\nbat_threshold0=").append(this.bat_threshold0);
        sb.append(",\nbat_gprs_download_threshold=").append(this.bat_gprs_download_threshold);
        sb.append(",\nbat_acc_threshold=").append(this.bat_acc_threshold);
        sb.append(",\nmaccess_voltlimit=").append(this.maccess_voltlimit);
        sb.append(",\nradio_longdelay=").append(this.radio_longdelay);
        sb.append(",\nping_ontime=").append(this.ping_ontime);
        sb.append(",\npinger_interval=").append(this.pinger_interval);
        sb.append(",\nfreq_pinger=").append(this.freq_pinger);
        sb.append(",\ngps_ontime=").append(this.gps_ontime);
        sb.append(",\ngps_high_res_interval=").append(this.gps_high_res_interval);
        sb.append(",\ngps_low_res_interval=").append(this.gps_low_res_interval);
        sb.append(",\ngps_lowbat_interval=").append(this.gps_lowbat_interval);
        sb.append(",\ngps_timeout=").append(this.gps_timeout);
        sb.append(",\ngps_interval_retry_factor=").append(this.gps_interval_retry_factor);
        sb.append(",\nburst_length=").append(this.burst_length);
        sb.append(",\nburst_qperiod=").append(this.burst_qperiod);
        sb.append(",\nburst_lowspd_fixcnt=").append(this.burst_lowspd_fixcnt);
        sb.append(",\nlowbat_burst_length=").append(this.lowbat_burst_length);
        sb.append(",\nlowbat_burst_qperiod=").append(this.lowbat_burst_qperiod);
        sb.append(",\ngps_hourshift=").append(this.gps_hourshift);
        sb.append(",\ngps_daydivisor=").append(this.gps_daydivisor);
        sb.append(",\nacc_ontime=").append(this.acc_ontime);
        sb.append(",\nacc_interval=").append(this.acc_interval);
        sb.append(",\nvariance_interval=").append(this.variance_interval);
        sb.append(",\nacc_lowbat_interval=").append(this.acc_lowbat_interval);
        sb.append(",\nacc_bytecnt=").append(this.acc_bytecnt);
        sb.append(",\nacc_samplerate=").append(this.acc_samplerate);
        sb.append(",\nlowspeed_acc_interval_factor=").append(this.lowspeed_acc_interval_factor);
        sb.append(",\nflags0=").append(this.flags0);
        sb.append(",\nflags1=").append(this.flags1);
        sb.append(",\ndevice_start_time=").append(this.device_start_time);
        sb.append(",\nacc_var_threshold=").append(this.acc_var_threshold);
        sb.append(",\nacc_var_samplerate=").append(this.acc_var_samplerate);
        sb.append(",\nacc_var_bytecnt=").append(this.acc_var_bytecnt);
        sb.append(",\nacc_param_n1=").append(this.acc_param_n1);
        sb.append(",\nacc_param_n2=").append(this.acc_param_n2);
        sb.append(",\nvariance_axis=").append(this.variance_axis);
        sb.append(",\ntilt_second_axis=").append(this.tilt_second_axis);
        sb.append(",\nspeed_threshold1=").append(this.speed_threshold1);
        sb.append(",\nspeed_threshold2=").append(this.speed_threshold2);
        sb.append(",\nspeed_threshold3=").append(this.speed_threshold3);
        sb.append(",\nspeed_threshold4=").append(this.speed_threshold4);
        sb.append(",\nspeed_param_n1=").append(this.speed_param_n1);
        sb.append(",\nacc_yf=").append(this.acc_yf);
        sb.append(",\nacc_zf=").append(this.acc_zf);
        sb.append(",\naccoffset_yf=").append(this.accoffset_yf);
        sb.append(",\naccoffset_zf=").append(this.accoffset_zf);
        sb.append(",\nacc_dead_threshold=").append(this.acc_dead_threshold);
        sb.append(",\ndead_counter_threshold=").append(this.dead_counter_threshold);
        sb.append(",\nacc_alive_threshold=").append(this.acc_alive_threshold);
        sb.append(",\nalive_counter_threshold=").append(this.alive_counter_threshold);
        sb.append(",\nfreq_dead_pinger=").append(this.freq_dead_pinger);
        sb.append(",\ngsm_bigger_interval=").append(this.gsm_bigger_interval);
        sb.append(",\nsms_time=").append(this.sms_time);
        sb.append(",\ngprs_time=").append(this.gprs_time);
        sb.append(",\ngprs2_time=").append(this.gprs2_time);
        sb.append(",\nsms_gps_collect_interval1=").append(this.sms_gps_collect_interval1);
        sb.append(",\nsms_gps_collect_offset1=").append(this.sms_gps_collect_offset1);
        sb.append(",\nsms_timeout=").append(this.sms_timeout);
        sb.append(",\ngprs_timeout=").append(this.gprs_timeout);
        sb.append(",\ngprs_min_pk_freq=").append(this.gprs_min_pk_freq);
        sb.append(",\nsm_burst_length=").append(this.sm_burst_length);
        sb.append(",\nsm_burst_qperiod=").append(this.sm_burst_qperiod);
        sb.append(",\nsm_low_res_gps_interval=").append(this.sm_low_res_gps_interval);
        sb.append(",\nsm_memory_limit=").append(this.sm_memory_limit);
        sb.append(",\nsm_acc_interval=").append(this.sm_acc_interval);
        sb.append(",\nsm_variance_interval=").append(this.sm_variance_interval);
        sb.append(",\nsm_acc_param_n1=").append(this.sm_acc_param_n1);
        sb.append(",\nsm_acc_param_n2=").append(this.sm_acc_param_n2);
        sb.append(",\nsm_burst_lowspd_fixcnt=").append(this.sm_burst_lowspd_fixcnt);
        sb.append(",\nsm_imu_interval=").append(this.sm_imu_interval);
        sb.append(",\nflags2=").append(this.flags2);
        sb.append(",\nflags3=").append(this.flags3);
        sb.append(",\nimu_acc_datasetcount=").append(this.imu_acc_datasetcount);
        sb.append(",\nres1=").append(this.res1);
        sb.append(",\nimu_quatcomp_datasetcount=").append(this.imu_quatcomp_datasetcount);
        sb.append(",\nres2=").append(this.res2);
        sb.append(",\nimu_interval=").append(this.imu_interval);
        sb.append(",\nimu_lowbat_interval=").append(this.imu_lowbat_interval);
        sb.append(",\nimu_ontime=").append(this.imu_ontime);
        sb.append(",\nimu_start_delay=").append(this.imu_start_delay);
        sb.append(",\ngprs3_time=").append(this.gprs3_time);
        sb.append(",\nreserved=").append(this.reserved);
        sb.append(",\nck0=").append(this.ck0);
        sb.append(",\nck1=").append(this.ck1);
        sb.append('}');
        return sb.toString();
    }
}

