/*
 * Decompiled with CFR 0.152.
 */
package de.eobs.setuptool.tagconfig;

public class Ticket {
    private final int id;
    private final boolean hasError;
    private final long errorCode;
    private final boolean cfgDataSame;
    private final boolean cfgDataManipulated;
    private final boolean isValid;

    public Ticket(int id) {
        this(id, false, 0L, false, false);
    }

    public Ticket(int id, int errorCode) {
        this(id, errorCode != 0, errorCode, false, false);
    }

    public static Ticket createInvalidTicket() {
        return new Ticket();
    }

    Ticket() {
        this(0, false, 0L, false, false, false);
    }

    Ticket(int id, boolean hasError, long errorCode, boolean cfgDataSame, boolean cfgDataManipulated) {
        this(id, hasError, errorCode, cfgDataSame, cfgDataManipulated, true);
    }

    private Ticket(int id, boolean hasError, long errorCode, boolean cfgDataSame, boolean cfgDataManipulated, boolean isValid) {
        this.id = id;
        this.hasError = hasError;
        this.errorCode = errorCode;
        this.cfgDataSame = cfgDataSame;
        this.cfgDataManipulated = cfgDataManipulated;
        this.isValid = isValid;
    }

    public int getId() {
        return this.id;
    }

    public boolean hasError() {
        return this.hasError;
    }

    public long getErrorCode() {
        return this.errorCode;
    }

    public boolean cfgDataSame() {
        return this.cfgDataSame;
    }

    public boolean cfgDataManipulated() {
        return this.cfgDataManipulated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Ticket ticket = (Ticket)o;
        if (this.cfgDataManipulated != ticket.cfgDataManipulated) {
            return false;
        }
        if (this.cfgDataSame != ticket.cfgDataSame) {
            return false;
        }
        if (this.errorCode != ticket.errorCode) {
            return false;
        }
        if (this.hasError != ticket.hasError) {
            return false;
        }
        return this.id == ticket.id;
    }

    public int hashCode() {
        int result = this.id;
        result = 31 * result + (this.hasError ? 1 : 0);
        result = 31 * result + (int)(this.errorCode ^ this.errorCode >>> 32);
        result = 31 * result + (this.cfgDataSame ? 1 : 0);
        result = 31 * result + (this.cfgDataManipulated ? 1 : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Ticket{");
        sb.append("id=").append(this.id);
        sb.append(", hasError=").append(this.hasError);
        sb.append(", errorCode=").append(this.errorCode);
        sb.append(", cfgDataSame=").append(this.cfgDataSame);
        sb.append(", cfgDataManipulated=").append(this.cfgDataManipulated);
        sb.append('}');
        return sb.toString();
    }

    public boolean isValid() {
        return this.isValid;
    }
}

