/*
 * Decompiled with CFR 0.152.
 */
package de.eobs.setuptool.tagconfig;

import de.eobs.setuptool.tagconfig.Primitive;
import java.nio.ByteBuffer;

public class U16
implements Primitive {
    public static final int UPPER_BOUND = 65535;
    private int value;

    U16() {
        this(0);
    }

    U16(int value) {
        this.setValue(value);
    }

    public void setValue(int value) {
        if (value < 0) {
            throw new IllegalArgumentException(Integer.toString(value));
        }
        if (value > 65535) {
            throw new IllegalArgumentException(Integer.toString(value));
        }
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    @Override
    public int sizeInBytes() {
        return 2;
    }

    @Override
    public void writeTo(ByteBuffer buffer) {
        buffer.put((byte)(this.value >> 0 & 0xFF));
        buffer.put((byte)(this.value >> 8 & 0xFF));
    }

    @Override
    public void readFrom(ByteBuffer buffer) {
        this.value = 0;
        this.value += (buffer.get() & 0xFF) << 0;
        this.value += (buffer.get() & 0xFF) << 8;
    }

    public String toString() {
        return String.format("%04X", this.value);
    }
}

