/*
 * Decompiled with CFR 0.152.
 */
package de.eobs.setuptool.tagconfig;

import com.google.common.base.Preconditions;
import de.eobs.setuptool.tagconfig.Primitive;
import java.nio.ByteBuffer;

public class U32
implements Primitive {
    public static final long UPPER_BOUND = 0xFFFFFFFFL;
    private long value;

    U32() {
        this(0L);
    }

    U32(long value) {
        this.setValue(value);
    }

    public void setValue(long value) {
        if (value < 0L) {
            throw new IllegalArgumentException(Long.toString(value));
        }
        if (value > 0xFFFFFFFFL) {
            throw new IllegalArgumentException(Long.toString(value));
        }
        this.value = value;
    }

    public long getValue() {
        return this.value;
    }

    @Override
    public int sizeInBytes() {
        return 4;
    }

    @Override
    public void writeTo(ByteBuffer buffer) {
        buffer.put((byte)(this.value >> 0 & 0xFFL));
        buffer.put((byte)(this.value >> 8 & 0xFFL));
        buffer.put((byte)(this.value >> 16 & 0xFFL));
        buffer.put((byte)(this.value >> 24 & 0xFFL));
    }

    @Override
    public void readFrom(ByteBuffer buffer) {
        this.value = 0L;
        this.value += ((long)buffer.get() & 0xFFL) << 0;
        this.value += ((long)buffer.get() & 0xFFL) << 8;
        this.value += ((long)buffer.get() & 0xFFL) << 16;
        this.value += ((long)buffer.get() & 0xFFL) << 24;
    }

    public String toString() {
        return String.format("%08X", this.value);
    }

    public void setBit(int bit) {
        Preconditions.checkArgument((bit >= 0 ? 1 : 0) != 0, (Object)("bit lower than 0: " + bit));
        Preconditions.checkArgument((bit <= 31 ? 1 : 0) != 0, (Object)("bit greater than 31: " + bit));
        this.value |= 1L << bit;
    }

    public void clearBit(int bit) {
        Preconditions.checkArgument((bit >= 0 ? 1 : 0) != 0, (Object)("bit lower than 0: " + bit));
        Preconditions.checkArgument((bit <= 31 ? 1 : 0) != 0, (Object)("bit greater than 31: " + bit));
        this.value &= 1L << bit ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public boolean getBit(int bit) {
        Preconditions.checkArgument((bit >= 0 ? 1 : 0) != 0, (Object)("bit lower than 0: " + bit));
        Preconditions.checkArgument((bit <= 31 ? 1 : 0) != 0, (Object)("bit greater than 31: " + bit));
        return (this.value & 1L << bit) == 1L << bit;
    }
}

