/*
 * Decompiled with CFR 0.152.
 */
package de.eobs.setuptool.tagconfig;

import de.eobs.setuptool.tagconfig.Primitive;
import java.nio.ByteBuffer;

public class U8
implements Primitive {
    public static final int UPPER_BOUND = 255;
    private int value;

    U8() {
        this(0);
    }

    U8(int value) {
        this.setValue(value);
    }

    public void setValue(int value) {
        if (value < 0) {
            throw new IllegalArgumentException(Integer.toString(value));
        }
        if (value > 255) {
            throw new IllegalArgumentException(Integer.toString(value));
        }
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    @Override
    public int sizeInBytes() {
        return 1;
    }

    @Override
    public void writeTo(ByteBuffer buffer) {
        buffer.put((byte)(this.value >> 0 & 0xFF));
    }

    @Override
    public void readFrom(ByteBuffer buffer) {
        this.value = buffer.get() & 0xFF;
    }

    public String toString() {
        return String.format("%02X", this.value);
    }

    public boolean hasMask(int flag) {
        return (this.getValue() & flag) == flag;
    }

    public void clearMask(int flag) {
        this.setValue(this.getValue() & ~flag);
    }

    public void setMask(int flag) {
        this.setValue(this.getValue() | flag);
    }
}

