/*
 * Decompiled with CFR 0.152.
 */
package de.eobs.setuptool.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedResource;

@ManagedResource
public class BuildProperties {
    private static final Logger LOGGER = LoggerFactory.getLogger(BuildProperties.class);
    private static final String BUILD_PROPERTIES = "/META-INF/build.properties";
    private final String gitTag;
    private final String gitTagLong;
    private final String gitBranch;
    private final boolean gitDirty;
    private final String gitCommitHash;
    private final String gitCommitTimestamp;
    private static BuildProperties INSTANCE;

    public static BuildProperties getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new BuildProperties();
        }
        return INSTANCE;
    }

    private BuildProperties() {
        this(BuildProperties.loadBuildProperties());
        LOGGER.info(this.toString());
    }

    private static Properties loadBuildProperties() {
        Properties properties = new Properties();
        InputStream resourceAsStream = BuildProperties.class.getResourceAsStream(BUILD_PROPERTIES);
        if (resourceAsStream == null) {
            LOGGER.error("File not found: /META-INF/build.properties");
            return properties;
        }
        try {
            properties.load(resourceAsStream);
        }
        catch (IOException e) {
            LOGGER.error("Can't read /META-INF/build.properties", (Throwable)e);
        }
        finally {
            try {
                resourceAsStream.close();
            }
            catch (IOException iOException) {}
        }
        return properties;
    }

    public BuildProperties(Properties properties) {
        this.gitTag = properties.getProperty("git.tag", "unknown");
        this.gitTagLong = properties.getProperty("git.tag.long", "unknown");
        this.gitBranch = properties.getProperty("git.branch", "unknown");
        this.gitDirty = Boolean.parseBoolean(properties.getProperty("git.dirty", "true"));
        this.gitCommitHash = properties.getProperty("git.commit.hash", "unknown");
        this.gitCommitTimestamp = properties.getProperty("git.commit.timestamp", "unknown");
    }

    @ManagedAttribute
    public String getGitTag() {
        return this.gitTag;
    }

    @ManagedAttribute
    public String getGitTagLong() {
        return this.gitTagLong;
    }

    @ManagedAttribute
    public String getGitBranch() {
        return this.gitBranch;
    }

    @ManagedAttribute
    public boolean getGitDirty() {
        return this.gitDirty;
    }

    @ManagedAttribute
    public String getGitCommitHash() {
        return this.gitCommitHash;
    }

    @ManagedAttribute
    public String getGitCommitTimestamp() {
        return this.gitCommitTimestamp;
    }

    @ManagedAttribute
    public DateTime getGitCommitTimestampAsDateTime() {
        return new DateTime((Object)this.gitCommitTimestamp);
    }

    @ManagedAttribute
    public DeploymentMode getDeploymentMode() {
        if ("release".equals(this.gitBranch)) {
            return DeploymentMode.RELEASE;
        }
        if ("test".equals(this.gitBranch)) {
            return DeploymentMode.TEST;
        }
        return DeploymentMode.DEVELOPMENT;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("BuildProperties{");
        sb.append("gitTag='").append(this.gitTag).append('\'');
        sb.append(", gitTagLong='").append(this.gitTagLong).append('\'');
        sb.append(", gitBranch='").append(this.gitBranch).append('\'');
        sb.append(", gitDirty=").append(this.gitDirty);
        sb.append(", gitCommitHash='").append(this.gitCommitHash).append('\'');
        sb.append(", gitCommitTimestamp='").append(this.gitCommitTimestamp).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public static enum DeploymentMode {
        DEVELOPMENT(false),
        TEST(true),
        RELEASE(true);

        public final boolean strictRemoteServiceCompatibilityCheck;

        private DeploymentMode(boolean strictRemoteServiceCompatibilityCheck) {
            this.strictRemoteServiceCompatibilityCheck = strictRemoteServiceCompatibilityCheck;
        }
    }
}

