/*
 * Decompiled with CFR 0.152.
 */
package de.eobs.setuptool.xx;

import java.io.FileOutputStream;

public class ByteTools {
    static int[] hexdigits = new int[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};

    public static byte IntToByte(int i) {
        if (i < 0) {
            i += 256;
        }
        return (byte)i;
    }

    public static int ByteToInt(byte b) {
        int i = b;
        if (i < 0) {
            i += 256;
        }
        return i;
    }

    public static int putU1(int ofs, byte[] buf, int v) {
        buf[ofs] = ByteTools.IntToByte(v);
        return ofs + 1;
    }

    public static int GetU1(int ofs, byte[] buf, int[] v) {
        v[0] = ByteTools.ByteToInt(buf[ofs]);
        return ofs + 1;
    }

    public static int GetU1V(int ofs, byte[] buf, byte[] out) {
        for (int i = 0; i < out.length; ++i) {
            out[i] = buf[ofs++];
        }
        return ofs;
    }

    public static int putU2(int ofs, byte[] buf, int v) {
        ofs = ByteTools.putU1(ofs, buf, v & 0xFF);
        ofs = ByteTools.putU1(ofs, buf, v >> 8 & 0xFF);
        return ofs;
    }

    public static int PutU4(int ofs, byte[] buf, long v) {
        ofs = ByteTools.putU1(ofs, buf, (int)(v & 0xFFL));
        ofs = ByteTools.putU1(ofs, buf, (int)(v >> 8 & 0xFFL));
        ofs = ByteTools.putU1(ofs, buf, (int)(v >> 16 & 0xFFL));
        ofs = ByteTools.putU1(ofs, buf, (int)(v >> 24 & 0xFFL));
        return ofs;
    }

    public static int PutS4(int ofs, byte[] buf, int v) {
        ofs = ByteTools.putU1(ofs, buf, v & 0xFF);
        ofs = ByteTools.putU1(ofs, buf, v >> 8 & 0xFF);
        ofs = ByteTools.putU1(ofs, buf, v >> 16 & 0xFF);
        ofs = ByteTools.putU1(ofs, buf, v >> 24 & 0xFF);
        return ofs;
    }

    public static int GetS4(int ofs, byte[] buf, int[] v) {
        int tmp = ByteTools.ByteToInt(buf[ofs + 0]);
        v[0] = tmp & 0xFF;
        tmp = ByteTools.ByteToInt(buf[ofs + 1]);
        v[0] = v[0] | (tmp & 0xFF) << 8;
        tmp = ByteTools.ByteToInt(buf[ofs + 2]);
        v[0] = v[0] | (tmp & 0xFF) << 16;
        tmp = ByteTools.ByteToInt(buf[ofs + 3]);
        v[0] = v[0] | (tmp & 0xFF) << 24;
        return ofs + 4;
    }

    public static int PutF4(int ofs, byte[] buf, float v) {
        return ByteTools.PutS4(ofs, buf, Float.floatToRawIntBits(v));
    }

    public static int GetF4(int ofs, byte[] buf, float[] v) {
        int[] tmp = new int[1];
        ofs = ByteTools.GetS4(ofs, buf, tmp);
        v[0] = Float.intBitsToFloat(tmp[0]);
        return ofs;
    }

    public static int GetString(int ofs, byte[] buf, String[] str) {
        StringBuffer sb = new StringBuffer();
        while (true) {
            int tmp = ByteTools.ByteToInt(buf[ofs]);
            ++ofs;
            if (tmp == 0) break;
            sb.append((char)tmp);
        }
        str[0] = sb.toString();
        return ofs;
    }

    public static void Dump(byte[] buf) {
        System.out.println("Byte Dump: ");
        for (int i = 0; i < buf.length; ++i) {
            System.out.print(Integer.toHexString(ByteTools.ByteToInt(buf[i])) + " ");
            if (i % 16 != 0) continue;
            System.out.println("");
        }
        System.out.println("");
    }

    public static void main2(String[] args) {
        byte[] buf = new byte[256];
        int ofs = 0;
        for (int i = -10; i <= 10; ++i) {
            System.out.println((int)((double)i * 1024.0));
            ofs = ByteTools.PutS4(ofs, buf, (int)((double)i * 0.5 * 1024.0));
        }
        try {
            FileOutputStream os = new FileOutputStream("/tmp/test.out");
            os.write(buf);
            os.close();
        }
        catch (Exception ex) {
            System.out.println("catch: " + ex);
        }
    }

    static int AsciiToValue(int b) {
        if (b >= 48 && b <= 57) {
            return b - 48;
        }
        if (b >= 97 && b <= 102) {
            return 10 + (b - 97);
        }
        if (b >= 65 && b <= 70) {
            return 10 + (b - 65);
        }
        return 0;
    }

    public static long HexstrToLong(String hexstr) {
        long l = 0L;
        int len = hexstr.length();
        byte[] bytes = hexstr.getBytes();
        for (int i = 0; i < len; ++i) {
            l <<= 4;
            l |= (long)ByteTools.AsciiToValue(bytes[i]);
        }
        return l;
    }

    public static long BytesLEToLong(byte[] b) {
        long l = 0L;
        if (b == null || b.length != 8) {
            return 0L;
        }
        for (int i = 7; i >= 0; --i) {
            l <<= 8;
            l |= (long)ByteTools.ByteToInt(b[i]);
        }
        return l;
    }

    public static String LongToHexstr(long l) {
        byte[] bytes = new byte[16];
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < 16; ++i) {
            bytes[15 - i] = (byte)hexdigits[(int)(l & 0xFL)];
            l >>= 4;
        }
        return new String(bytes);
    }

    public static byte[] LongToBytesLE(long l) {
        byte[] b = new byte[8];
        for (int i = 0; i < 8; ++i) {
            b[i] = (byte)(l & 0xFFL);
            l >>= 8;
        }
        return b;
    }

    public static byte[] HexstrLongToBytesLE(String v) {
        byte[] b = v.getBytes();
        byte[] out = new byte[8];
        if (b.length != 16) {
            return out;
        }
        for (int i = 0; i < 8; ++i) {
            int x = ByteTools.AsciiToValue(b[i * 2]) * 16;
            out[7 - i] = (byte)((x += ByteTools.AsciiToValue(b[i * 2 + 1])) & 0xFF);
        }
        return out;
    }

    public static void main(String[] args) {
        byte[] bid = new byte[]{-128, 0, 0, 0, 0, 0, 0, -128};
        ByteTools.Dump(bid);
        long lid = ByteTools.BytesLEToLong(bid);
        System.out.println("lid: " + lid);
        String sid = ByteTools.LongToHexstr(lid);
        System.out.println("sid: " + sid);
    }
}

