/*
 * Decompiled with CFR 0.152.
 */
package de.eobs.setuptool.xx;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;

public class LittleEndianBuffer {
    private OutputStream theOS = new ByteArrayOutputStream();

    public OutputStream getBackingStream() {
        return this.theOS;
    }

    public byte[] toByteArray() {
        if (this.theOS instanceof ByteArrayOutputStream) {
            return ((ByteArrayOutputStream)this.theOS).toByteArray();
        }
        return null;
    }

    public void putU1(int u1) {
        try {
            this.theOS.write(u1);
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public void putS2(short s2) {
        this.putU1(s2 & 0xFF);
        this.putU1(s2 >> 8 & 0xFF);
    }

    public void putU2(int u2) {
        this.putU1(u2 & 0xFF);
        this.putU1(u2 >> 8 & 0xFF);
    }

    public void putS4(int s4) {
        this.putU1(s4 & 0xFF);
        this.putU1(s4 >> 8 & 0xFF);
        this.putU1(s4 >> 16 & 0xFF);
        this.putU1(s4 >> 24 & 0xFF);
    }

    public void putU4(long s4) {
        this.putU1((int)(s4 & 0xFFL));
        this.putU1((int)(s4 >> 8 & 0xFFL));
        this.putU1((int)(s4 >> 16 & 0xFFL));
        this.putU1((int)(s4 >> 24 & 0xFFL));
    }

    public void putS8(long s8) {
        this.putU1((int)(s8 & 0xFFL));
        this.putU1((int)(s8 >> 8 & 0xFFL));
        this.putU1((int)(s8 >> 16 & 0xFFL));
        this.putU1((int)(s8 >> 24 & 0xFFL));
        this.putU1((int)(s8 >> 32 & 0xFFL));
        this.putU1((int)(s8 >> 40 & 0xFFL));
        this.putU1((int)(s8 >> 48 & 0xFFL));
        this.putU1((int)(s8 >> 56 & 0xFFL));
    }

    public void putF4(float f4) {
        this.putS4(Float.floatToRawIntBits(f4));
    }

    public void putF8(double f8) {
        this.putS8(Double.doubleToRawLongBits(f8));
    }

    public void put(byte[] bytes) {
        try {
            this.theOS.write(bytes);
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public void put(String s, boolean bNullTerminated) {
        this.put(s.getBytes());
        if (bNullTerminated) {
            this.putU1(0);
        }
    }
}

