/*
 * Decompiled with CFR 0.152.
 */
package de.eobs.setuptool;

import de.eobs.setuptool.AboutPanel;
import de.eobs.setuptool.AppPanel;
import de.eobs.setuptool.AppReadyEvent;
import de.eobs.setuptool.CheckCompatibilityEvent;
import de.eobs.setuptool.ConfigPanels;
import de.eobs.setuptool.Configuration;
import de.eobs.setuptool.OpenTagEvent;
import de.eobs.setuptool.Tag;
import de.eobs.setuptool.TagConfigUtil;
import de.eobs.setuptool.TagEditContextPanel;
import de.eobs.setuptool.TagListContextPanel;
import de.eobs.setuptool.TagListPanel;
import de.eobs.setuptool.TagReloadEvent;
import de.eobs.setuptool.TagSettingsTableContextPanel;
import de.eobs.setuptool.TagSettingsTablePanel;
import de.eobs.setuptool.ValidateTagConfig;
import de.eobs.setuptool.ValidationPrint;
import de.eobs.setuptool.ValidationsApply;
import de.eobs.setuptool.WelcomePanel;
import de.eobs.setuptool.configv0.ConfigPanelsV0;
import de.eobs.setuptool.configv1.ConfigPanelsV1;
import de.eobs.setuptool.configv2.ConfigPanelsV2;
import de.eobs.setuptool.event.SendTagConfigToServerEvent;
import de.eobs.setuptool.event.SendTagConfigsToServerEvent;
import de.eobs.setuptool.eventbus.EventBus;
import de.eobs.setuptool.eventbus.EventBusImpl;
import de.eobs.setuptool.eventbus.EventHandler;
import de.eobs.setuptool.getcredentialsdialog.GetCredentialsDialog;
import de.eobs.setuptool.getcredentialsdialog.GetCredentialsEvent;
import de.eobs.setuptool.getcredentialsdialog.TagCredentials;
import de.eobs.setuptool.getcredentialsdialog.TagCredentialsEvent;
import de.eobs.setuptool.gui.table.TableRow;
import de.eobs.setuptool.gui.tagconfigaccess.TagConfigAccess;
import de.eobs.setuptool.gui.tagconfigaccess.TagConfigV0Util;
import de.eobs.setuptool.gui.tagconfigaccess.TagConfigV1Util;
import de.eobs.setuptool.gui.tagconfigaccess.TagConfigV2Util;
import de.eobs.setuptool.gui.tagconfigaccess.Vocabular;
import de.eobs.setuptool.remoteservice.RemoteService;
import de.eobs.setuptool.remoteservice.RemoteServiceCompatibilityCheck;
import de.eobs.setuptool.remoteservice.TagInfoService;
import de.eobs.setuptool.remoteservice.gettag.NewTagInfoEvent;
import de.eobs.setuptool.remoteservice.gettaglist.GetTagListFromServerEvent;
import de.eobs.setuptool.remoteservice.getversion.CheckCompatibilityProgressDialog;
import de.eobs.setuptool.remoteservice.getversion.ServiceInfoEvent;
import de.eobs.setuptool.remoteservice.getversion.ServiceInfoFailureEvent;
import de.eobs.setuptool.remoteservice.getversion.TestRemoteServiceEvent;
import de.eobs.setuptool.remoteservice.listtags.ListTagsProgressDialog;
import de.eobs.setuptool.remoteservice.listtags.NewTagInfoListEvent;
import de.eobs.setuptool.remoteservice.sendtagconfig.SendTagConfigToServerProgressDialog;
import de.eobs.setuptool.rest.api.TagId;
import de.eobs.setuptool.rest.api.TagInfo;
import de.eobs.setuptool.tagconfig.HeaderFields;
import de.eobs.setuptool.tagconfig.TagConfigDispatch;
import de.eobs.setuptool.tagconfig.TagConfigFactory;
import de.eobs.setuptool.tagconfig.TagConfigGeneric;
import de.eobs.setuptool.tagconfig.TagConfigV0;
import de.eobs.setuptool.tagconfig.TagConfigV1;
import de.eobs.setuptool.tagconfig.TagConfigV2;
import de.eobs.setuptool.taglistdialog.TagSelectEvent;
import de.eobs.setuptool.templates.SaveTemplateDialog;
import de.eobs.setuptool.templates.SelectTemplateDialog;
import de.eobs.setuptool.templates.TagConfigJson;
import de.eobs.setuptool.templates.TagConfigJsonUtils;
import de.eobs.setuptool.templates.TagConfigTemplateJson;
import de.eobs.setuptool.templates.TagConfigTemplateJsonUtils;
import de.eobs.setuptool.templates.TemplateStore;
import de.eobs.setuptool.util.JdkSerialFilter;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.UnsupportedLookAndFeelException;
import org.apache.http.auth.AuthScope;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class Setuptool {
    static final Logger logger = LoggerFactory.getLogger(Setuptool.class);
    private static ClassPathXmlApplicationContext ctx;
    private final AppPanel appPanel;
    private EventBus eventBus = new EventBusImpl();
    private RemoteService remoteService = new RemoteService();
    private boolean eobsExpertOptionsEnabled = false;
    public static final File DEFAULT_FILE;
    private JFileChooser fileChooser;
    private final JFrame appFrame;
    ExitVetoHandler currentExitVetoHandler;

    public static void main(String[] args) throws UnsupportedLookAndFeelException {
        JdkSerialFilter.configure();
        new Setuptool(args);
    }

    public static void initContext() {
        if (System.getProperty("env") == null) {
            System.setProperty("env", "prod");
        }
        logger.info("Selected profile: " + System.getProperty("env"));
        ctx = new ClassPathXmlApplicationContext("client-beans.xml");
    }

    public static TagInfoService getTagInfoService() {
        return (TagInfoService)ctx.getBean("RemoteService");
    }

    public static RemoteServiceCompatibilityCheck getRemoteServiceCompatibilityCheck() {
        return (RemoteServiceCompatibilityCheck)ctx.getBean("RemoteServiceCompatibilityCheck");
    }

    public static Configuration getConfiguration() {
        return (Configuration)ctx.getBean("configuration");
    }

    public RemoteService getRemoteService() {
        return this.remoteService;
    }

    public Setuptool(String[] args) {
        this.parseCommandLineArguments(args);
        Setuptool.initContext();
        logger.info("client.development-mode=" + Setuptool.getConfiguration().isDevelopmentMode());
        this.appPanel = new AppPanel(this, Setuptool.getConfiguration().isDevelopmentMode());
        this.appFrame = new JFrame();
        this.appFrame.setTitle("e-obs setuptool");
        this.appFrame.setDefaultCloseOperation(3);
        this.appFrame.getContentPane().add(this.appPanel);
        this.appFrame.setPreferredSize(new Dimension(1024, 600));
        this.appFrame.setMinimumSize(new Dimension(640, 480));
        this.appFrame.pack();
        this.appFrame.setLocationRelativeTo(this.appFrame.getOwner());
        this.appFrame.setVisible(true);
        this.appPanel.setCenter(new WelcomePanel(new WelcomePanel.Handler(){

            @Override
            public void onOk(TagId tagId, String password) {
                Setuptool.this.eventBus.publish(new TagCredentialsEvent(new TagCredentials(tagId, password)));
            }

            @Override
            public void onCancel() {
            }
        }));
        this.eventBus.subscribe(new CheckCompatibilityProgressDialog(this.appFrame, this.eventBus, this.remoteService));
        this.eventBus.subscribe(new ListTagsProgressDialog(this.appFrame, this.eventBus, this.remoteService));
        this.eventBus.subscribe(new SendTagConfigToServerProgressDialog(this.appFrame, this.eventBus, this.remoteService));
        this.eventBus.subscribe(new GetCredentialsDialog(this.appFrame, this.eventBus));
        this.eventBus.subscribe(new OpenTagStateMachine(this, this.eventBus));
        this.eventBus.subscribe(new CheckCompatibilityStateMachine(this, this.eventBus));
        this.eventBus.publish(new AppReadyEvent());
    }

    private void parseCommandLineArguments(String[] args) {
        this.eobsExpertOptionsEnabled = args.length == 1 && "--eobs-expert".equals(args[0]);
    }

    public void doBackToMainPage() {
        int result;
        boolean canExit;
        if (this.currentExitVetoHandler != null && !(canExit = this.currentExitVetoHandler.canExit()) && (result = JOptionPane.showConfirmDialog(this.appPanel, "Local Changes have not been uploaded and will be discarded. Do you want to proceed?", "Back to Main Page", 0)) != 0) {
            return;
        }
        this.currentExitVetoHandler = null;
        this.appPanel.setCenter(new WelcomePanel(new WelcomePanel.Handler(){

            @Override
            public void onOk(TagId tagId, String password) {
                Setuptool.this.eventBus.publish(new TagCredentialsEvent(new TagCredentials(tagId, password)));
            }

            @Override
            public void onCancel() {
            }
        }));
    }

    void setExitVetoHandler(ExitVetoHandler handler) {
        this.currentExitVetoHandler = handler;
    }

    private void doShowTagList(final List<Tag> tags) {
        for (Tag tagInfo : tags) {
            logger.info("tagInfo: " + tagInfo.getTagId() + ", updateConfig=" + (tagInfo.getUpdateConfig() != null) + ", currentConfig=" + (tagInfo.getCurrentConfig() != null));
        }
        this.setExitVetoHandler(new ExitVetoHandler(){

            @Override
            public boolean canExit() {
                for (Tag tag : tags) {
                    if (!tag.wasEdited()) continue;
                    return false;
                }
                return true;
            }
        });
        final TagListPanel tagListPanel = new TagListPanel(new TagListPanel.Handler(){

            @Override
            public void onTagSelected(Tag tag) {
                logger.info("onTagSelected: " + tag);
                Setuptool.this.doShowTagSettingTables(tag, new ShowTagSettingTablesHandler(){

                    @Override
                    public void onBack() {
                        Setuptool.this.doShowTagList(tags);
                    }
                });
            }
        }, this.areEobsExpertOptionsEnabled());
        TagListContextPanel tagListContextPanel = new TagListContextPanel(new TagListContextPanel.Handler(){

            @Override
            public void onLoadTemplate(TagListContextPanel tagListContextPanel) {
                final List<Tag> tagInfos = tagListPanel.getSelectedItems();
                logger.info("onLoadTemplate: " + tagInfos);
                if (tagInfos.isEmpty()) {
                    JOptionPane.showMessageDialog(Setuptool.this.appPanel, "Please select at least one Tag.", "Load Tag Configuration Template", 2);
                    return;
                }
                boolean compatible = true;
                Tag refTag = null;
                for (Tag tag : tagInfos) {
                    if (refTag == null) {
                        refTag = tag;
                        continue;
                    }
                    if (TagConfigUtil.areConfigsCompatible(refTag.getCurrentConfig(), tag.getCurrentConfig())) continue;
                    compatible = false;
                    break;
                }
                if (!compatible) {
                    JOptionPane.showMessageDialog(Setuptool.this.appPanel, "Selected Tags are of different configuration types. Please only select Tags of same configuration type.", "Load Tag Configuration Template", 2);
                    return;
                }
                TemplateStore templateStore = new TemplateStore(TemplateStore.getDefaultTemplateStoreFile());
                try {
                    List<TagConfigTemplateJson> allTemplates = templateStore.getAll();
                    if (allTemplates.isEmpty()) {
                        JOptionPane.showMessageDialog(Setuptool.this.appPanel, "No configuration templates yet.", "Load Tag Configuration Template", 2);
                        return;
                    }
                    ArrayList<TagConfigTemplateJson> compatibleTemplates = new ArrayList<TagConfigTemplateJson>();
                    for (TagConfigTemplateJson t : allTemplates) {
                        logger.info("check compatibility: " + refTag.getTagId() + " vs. " + t.name);
                        if (!TagConfigUtil.areConfigsCompatible(refTag.getCurrentConfig(), TagConfigFactory.fromBytes((byte[])t.getConfigBytesAsByteArray()))) continue;
                        compatibleTemplates.add(t);
                    }
                    if (compatibleTemplates.isEmpty()) {
                        JOptionPane.showMessageDialog(Setuptool.this.appPanel, "No configuration template is compatible to the current tag.", "Load Tag Configuration Template", 2);
                        return;
                    }
                    SelectTemplateDialog.show(Setuptool.this.appFrame, compatibleTemplates, new SelectTemplateDialog.Handler(){

                        @Override
                        public void onTemplateSelected(TagConfigTemplateJson template) {
                            int result;
                            logger.info("selected template: " + template);
                            TagConfigGeneric templateConfig = TagConfigFactory.fromBytes((byte[])template.getConfigBytesAsByteArray());
                            if (TagConfigUtil.isHighDataUsageConfig(templateConfig) && (result = JOptionPane.showConfirmDialog(Setuptool.this.appPanel, "These settings contain SUPERMODE settings that can generate a lot of data and transmission costs and burden the loggers. Do you want to continue?", "High Data Usage", 0, 2)) != 0) {
                                return;
                            }
                            for (Tag tag : tagInfos) {
                                tag.setEditConfigSafe(templateConfig.copy());
                            }
                            Setuptool.this.doShowTagList(tags);
                        }
                    });
                }
                catch (Exception e) {
                    logger.error("caught", (Throwable)e);
                }
            }

            @Override
            public void onLoadFile(TagListContextPanel tagListContextPanel) {
                List<Tag> tagInfos = tagListPanel.getSelectedItems();
                logger.info("onLoadFile: " + tagInfos);
                if (tagInfos.isEmpty()) {
                    JOptionPane.showMessageDialog(Setuptool.this.appPanel, "Please select at least one Tag.", "Load Tag Configuration Template", 2);
                    return;
                }
                boolean compatible = true;
                Tag refTag = null;
                for (Tag tag : tagInfos) {
                    if (refTag == null) {
                        refTag = tag;
                        continue;
                    }
                    if (TagConfigUtil.areConfigsCompatible(refTag.getCurrentConfig(), tag.getCurrentConfig())) continue;
                    compatible = false;
                    break;
                }
                if (!compatible) {
                    JOptionPane.showMessageDialog(Setuptool.this.appPanel, "Selected Tags are of different configuration types. Please only select Tags of same configuration type.", "Load Tag Configuration Template", 2);
                    return;
                }
                try {
                    File loadFile = Setuptool.this.getLoadFile();
                    if (loadFile != null) {
                        int result;
                        TagConfigJson json = TagConfigJsonUtils.readJson(loadFile);
                        TagConfigGeneric tc = TagConfigFactory.fromBytes((byte[])json.getConfigBytes());
                        if (!TagConfigUtil.areConfigsCompatible(refTag.getCurrentConfig(), tc)) {
                            JOptionPane.showMessageDialog(Setuptool.this.appPanel, "The selected configuration file is not compatible.", "Incompatible Configurations", 2);
                            return;
                        }
                        TagConfigGeneric loadedConfig = TagConfigFactory.fromBytes((byte[])json.getConfigBytes());
                        if (TagConfigUtil.isHighDataUsageConfig(loadedConfig) && (result = JOptionPane.showConfirmDialog(Setuptool.this.appPanel, "These settings contain SUPERMODE settings that can generate a lot of data and transmission costs and burden the loggers. Do you want to continue?", "High Data Usage", 0, 2)) != 0) {
                            return;
                        }
                        for (Tag tag : tagInfos) {
                            tag.setEditConfigSafe(loadedConfig.copy());
                        }
                        Setuptool.this.doShowTagList(tags);
                    }
                }
                catch (IOException e) {
                    logger.error("", (Throwable)e);
                    JOptionPane.showMessageDialog(Setuptool.this.appPanel, "Failed to load tag configuration.", "Load Tag Configuration", 0);
                }
            }

            @Override
            public void onDiscardChanges(TagListContextPanel tagListContextPanel) {
                for (Tag tag : tags) {
                    if (!tag.wasEdited()) continue;
                    tag.discardChanges();
                }
                Setuptool.this.doShowTagList(tags);
            }

            @Override
            public void onEdit(TagListContextPanel tagListContextPanel) {
                List<Tag> tagInfos = tagListPanel.getSelectedItems();
                if (tagInfos.size() != 1) {
                    JOptionPane.showMessageDialog(Setuptool.this.appPanel, "To edit the settings, please select exactly one logger.", "Edit Tag Configuration", 2);
                } else {
                    Setuptool.this.doShowTagSettingTables(tagInfos.get(0), new ShowTagSettingTablesHandler(){

                        @Override
                        public void onBack() {
                            Setuptool.this.doShowTagList(tags);
                        }
                    });
                }
            }

            @Override
            public void onSend(TagListContextPanel tagListContextPanel) {
                List<Tag> tagInfos = tagListPanel.getSelectedItems();
                if (tagInfos.size() < 1) {
                    JOptionPane.showMessageDialog(Setuptool.this.appPanel, "To send the logger configuration to the server, please select at least one logger.", "Send Logger Configuration", 2);
                } else {
                    ArrayList<SendTagConfigToServerEvent> events = new ArrayList<SendTagConfigToServerEvent>();
                    for (Tag tag : tagInfos) {
                        if (!tag.wasEdited()) continue;
                        events.add(new SendTagConfigToServerEvent(tag.getTagId(), tag.getEditConfig()));
                        tag.setPendingOnServerShortcut();
                    }
                    if (!events.isEmpty()) {
                        Setuptool.this.eventBus.publish(new SendTagConfigsToServerEvent(events));
                        Setuptool.this.doShowTagList(tags);
                    }
                }
            }

            @Override
            public void onReload(TagListContextPanel tagListContextPanel) {
                Setuptool.this.eventBus.publish(new TagReloadEvent());
            }
        });
        tagListPanel.updateGui(tags);
        this.appPanel.setCenter(tagListContextPanel, tagListPanel);
    }

    private void fixTagConfig(TagConfigGeneric config) {
        TagConfigAccess access = (TagConfigAccess)config.dispatch((TagConfigDispatch)new TagConfigDispatch<TagConfigAccess>(){

            public TagConfigAccess onV0(TagConfigV0 config) {
                return TagConfigV0Util.bind(config);
            }

            public TagConfigAccess onV1(TagConfigV1 config) {
                return TagConfigV1Util.bind(config);
            }

            public TagConfigAccess onV2(TagConfigV2 config) {
                return TagConfigV2Util.bind(config);
            }
        });
        if (access.has(Vocabular.acc_bytecnt)) {
            logger.info("config has acc_bytecnt attribute");
            long accBytecnt = access.get(Vocabular.acc_bytecnt);
            long fixedAccBytecnt = (accBytecnt + 62L) / 63L * 63L - 9L;
            if (fixedAccBytecnt > 0L && accBytecnt != fixedAccBytecnt) {
                logger.info(" fixed acc_bytecnt from " + accBytecnt + " to " + fixedAccBytecnt);
                access.set(Vocabular.acc_bytecnt, fixedAccBytecnt);
            }
        }
    }

    private boolean areEobsExpertOptionsEnabled() {
        return this.eobsExpertOptionsEnabled;
    }

    public void doShowTagEdit(final Tag tag, final ShowTagEditHandler handler) {
        TagConfigGeneric config = tag.getEditConfig();
        if (!this.checkTagConfigCapabilities(config)) {
            JOptionPane.showMessageDialog(this.appPanel, "The downloaded Tag Config is not supported by this software version.", "Open Tag Config", 0);
            return;
        }
        this.fixTagConfig(config);
        final ConfigPanels configPanels = Setuptool.createConfigPanels(config, tag.getTagId(), tag.exportOptionsEnabled(), this.areEobsExpertOptionsEnabled());
        try {
            configPanels.updateModel(config);
        }
        catch (RuntimeException e) {
            JOptionPane.showMessageDialog(this.appPanel, "The downloaded Tag Config could not be displayed by this software version.\nCause:\n" + e.getMessage(), "Open Tag Config", 0);
            return;
        }
        TagEditContextPanel contextPanel = new TagEditContextPanel(new TagEditContextPanel.Handler(){

            @Override
            public void onSaveEdit(TagEditContextPanel tagSettingsTableContextPanel) {
                if (!configPanels.isUserInputValid()) {
                    JOptionPane.showMessageDialog(Setuptool.this.appPanel, "There is some invalid input! Please correct and save again.", "Invalid Input", 2);
                    return;
                }
                TagConfigGeneric config = tag.getEditConfig();
                config = configPanels.updateTagConfig(config);
                boolean goOn = Setuptool.this.doCheckTagConfigCorrections(config);
                configPanels.updateModel(config);
                if (!goOn) {
                    return;
                }
                tag.setEditConfigUnsafe(config);
                handler.onBack();
            }

            @Override
            public void onCancel(TagEditContextPanel tagEditContextPanel) {
                handler.onBack();
            }

            @Override
            public void onLoadFromTemplate(TagEditContextPanel tagEditContextPanel, final Tag tag2) {
                TemplateStore templateStore = new TemplateStore(TemplateStore.getDefaultTemplateStoreFile());
                try {
                    List<TagConfigTemplateJson> allTemplates = templateStore.getAll();
                    if (allTemplates.isEmpty()) {
                        JOptionPane.showMessageDialog(Setuptool.this.appPanel, "No configuration templates yet.", "Load Tag Configuration Template", 2);
                        return;
                    }
                    ArrayList<TagConfigTemplateJson> compatibleTemplates = new ArrayList<TagConfigTemplateJson>();
                    for (TagConfigTemplateJson t : allTemplates) {
                        if (!TagConfigUtil.areConfigsCompatible(tag2.getCurrentConfig(), TagConfigFactory.fromBytes((byte[])t.getConfigBytesAsByteArray()))) continue;
                        compatibleTemplates.add(t);
                    }
                    if (compatibleTemplates.isEmpty()) {
                        JOptionPane.showMessageDialog(Setuptool.this.appPanel, "No configuration template is compatible to the current tag.", "Load Tag Configuration Template", 2);
                        return;
                    }
                    SelectTemplateDialog.show(Setuptool.this.appFrame, compatibleTemplates, new SelectTemplateDialog.Handler(){

                        @Override
                        public void onTemplateSelected(TagConfigTemplateJson template) {
                            int result;
                            logger.info("selected template: " + template);
                            TagConfigGeneric templateConfig = TagConfigFactory.fromBytes((byte[])template.getConfigBytesAsByteArray());
                            if (TagConfigUtil.isHighDataUsageConfig(templateConfig) && (result = JOptionPane.showConfirmDialog(Setuptool.this.appPanel, "These settings contain SUPERMODE settings that can generate a lot of data and transmission costs and burden the loggers. Do you want to continue?", "High Data Usage", 0, 2)) != 0) {
                                return;
                            }
                            configPanels.updateModel(TagConfigUtil.safeMerge(templateConfig, tag2.getCurrentConfig()));
                        }
                    });
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void onSaveToTemplate(TagEditContextPanel tagEditContextPanel, Tag tag2) {
                if (!configPanels.isUserInputValid()) {
                    JOptionPane.showMessageDialog(Setuptool.this.appPanel, "There is some invalid input! Please correct and save again.", "Invalid Input", 2);
                    return;
                }
                TagConfigGeneric config = tag2.getEditConfig();
                config = configPanels.updateTagConfig(config);
                boolean goOn = Setuptool.this.doCheckTagConfigCorrections(config);
                configPanels.updateModel(config);
                if (!goOn) {
                    return;
                }
                TagConfigTemplateJson templateJson = TagConfigTemplateJsonUtils.toJson("template from tag " + tag2.getTagId().getValue(), "my comment", new DateTime(), config);
                SaveTemplateDialog.show(Setuptool.this.appFrame, templateJson, new SaveTemplateDialog.Handler(){

                    @Override
                    public void onOk(TagConfigTemplateJson templateJson) {
                        TemplateStore templateStore = new TemplateStore(TemplateStore.getDefaultTemplateStoreFile());
                        try {
                            int result;
                            boolean store = true;
                            if (templateStore.findByName(templateJson.name) != null && (result = JOptionPane.showOptionDialog(Setuptool.this.appPanel, "There already is a template with name '" + templateJson.name + "'.\nDo you want to replace it?", "Save Tag Config Template", 0, 3, null, new String[]{"Save", "Cancel"}, "Save")) == 1) {
                                store = false;
                            }
                            if (store) {
                                templateStore.store(templateJson, true);
                            }
                        }
                        catch (IOException e) {
                            logger.error("caught excpetion", (Throwable)e);
                            JOptionPane.showMessageDialog(Setuptool.this.appPanel, "Failed to save tag configuration template.\nCause:\n" + e.getMessage(), "Save Tag Config Template", 0);
                        }
                    }
                });
            }

            @Override
            public void onLoadFromFile(TagEditContextPanel tagEditContextPanel, Tag tag2) {
                try {
                    File loadFile = Setuptool.this.getLoadFile();
                    if (loadFile != null) {
                        int result;
                        TagConfigJson json = TagConfigJsonUtils.readJson(loadFile);
                        TagConfigGeneric tc = TagConfigFactory.fromBytes((byte[])json.getConfigBytes());
                        if (!TagConfigUtil.areConfigsCompatible(tag2.getCurrentConfig(), tc)) {
                            JOptionPane.showMessageDialog(Setuptool.this.appPanel, "The configurations are not compatible.", "Incompatible Configurations", 2);
                            return;
                        }
                        if (TagConfigUtil.isHighDataUsageConfig(tc) && (result = JOptionPane.showConfirmDialog(Setuptool.this.appPanel, "These settings contain SUPERMODE settings that can generate a lot of data and transmission costs and burden the loggers. Do you want to continue?", "High Data Usage", 0, 2)) != 0) {
                            return;
                        }
                        configPanels.updateModel(TagConfigUtil.safeMerge(tc, tag2.getCurrentConfig()));
                    }
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(Setuptool.this.appPanel, "Failed to load tag configuration.", "Load Tag Configuration", 0);
                }
            }

            @Override
            public void onSaveToFile(TagEditContextPanel tagEditContextPanel, Tag tag2) {
                if (!configPanels.isUserInputValid()) {
                    JOptionPane.showMessageDialog(Setuptool.this.appPanel, "There is some invalid input! Please correct and save again.", "Invalid Input", 2);
                    return;
                }
                TagConfigGeneric config = tag2.getEditConfig();
                config = configPanels.updateTagConfig(config);
                boolean goOn = Setuptool.this.doCheckTagConfigCorrections(config);
                configPanels.updateModel(config);
                if (!goOn) {
                    return;
                }
                File saveFile = Setuptool.this.getSaveFile(new File("tag_" + tag2.getTagId().getValue() + ".json"));
                if (saveFile != null) {
                    try {
                        TagConfigJsonUtils.writeJson(TagConfigJsonUtils.toJson(tag2.getTagId(), config), saveFile);
                    }
                    catch (IOException e) {
                        JOptionPane.showMessageDialog(Setuptool.this.appPanel, "Failed to save tag configuration.\nCause:\n" + e.getMessage(), "Save Tag Config", 0);
                    }
                }
            }
        }, tag);
        this.appPanel.setCenter(contextPanel, configPanels.createSettingsPanel());
    }

    private static List<TableRow> createTableRows(TagConfigGeneric tagConfig, TagId tagId, boolean exportOptionsEnabled, boolean eobsExportOptionsEnabled) {
        return Setuptool.createConfigPanels(tagConfig, tagId, exportOptionsEnabled, eobsExportOptionsEnabled).createTabelRows(tagConfig);
    }

    private static ConfigPanels createConfigPanels(TagConfigGeneric tagConfig, final TagId tagId, final boolean exportOptionsEnabled, final boolean eobsExportOptionsEnabled) {
        return (ConfigPanels)tagConfig.dispatch((TagConfigDispatch)new TagConfigDispatch<ConfigPanels>(){

            public ConfigPanels onV0(TagConfigV0 config) {
                return new ConfigPanelsV0(exportOptionsEnabled);
            }

            public ConfigPanels onV1(TagConfigV1 config) {
                System.out.println("config v1: " + config);
                return new ConfigPanelsV1(exportOptionsEnabled, config.hasSwFeaturesEnabled(new HeaderFields.Feature[]{HeaderFields.Feature.WITH_SUPER_BURST}), config.hasSwFeaturesEnabled(new HeaderFields.Feature[]{HeaderFields.Feature.WITH_ROIHAREL_FACTORS}), config.hasSwFeaturesEnabled(new HeaderFields.Feature[]{HeaderFields.Feature.WITH_MMA8452_SMBUS}), config.hasSwFeaturesEnabled(new HeaderFields.Feature[]{HeaderFields.Feature.WITH_BAND_916MHZ}), eobsExportOptionsEnabled, tagId);
            }

            public ConfigPanels onV2(TagConfigV2 config) {
                return new ConfigPanelsV2(config, tagId, exportOptionsEnabled, eobsExportOptionsEnabled);
            }
        });
    }

    public void doShowTagSettingTables(final Tag tag, final ShowTagSettingTablesHandler handler) {
        TagConfigGeneric currentConfig = tag.getCurrentConfig();
        TagConfigGeneric updateConfig = tag.getUpdateConfig();
        TagConfigGeneric editConfig = tag.getEditConfig();
        if (!this.checkTagConfigCapabilities(currentConfig)) {
            JOptionPane.showMessageDialog(this.appPanel, "The downloaded Tag Config is not supported by this software version.", "Open Tag Config", 0);
            return;
        }
        List<TableRow> currentTableRows = Setuptool.createTableRows(currentConfig, tag.getTagId(), tag.exportOptionsEnabled(), this.areEobsExpertOptionsEnabled());
        List<TableRow> updateTableRows = tag.wasUpdated() ? Setuptool.createTableRows(updateConfig, tag.getTagId(), tag.exportOptionsEnabled(), this.areEobsExpertOptionsEnabled()) : null;
        List<TableRow> editTableRows = tag.wasEdited() ? Setuptool.createTableRows(editConfig, tag.getTagId(), tag.exportOptionsEnabled(), this.areEobsExpertOptionsEnabled()) : null;
        TagSettingsTablePanel contentPanel = new TagSettingsTablePanel();
        contentPanel.updateGui(currentTableRows, updateTableRows, editTableRows);
        TagSettingsTableContextPanel contextPanel = new TagSettingsTableContextPanel(new TagSettingsTableContextPanel.Handler(){

            @Override
            public void onBack(TagSettingsTableContextPanel tagSettingsTableContextPanel) {
                handler.onBack();
            }

            @Override
            public void onEdit(TagSettingsTableContextPanel tagSettingsTableContextPanel) {
                Setuptool.this.doShowTagEdit(tag, new ShowTagEditHandler(){

                    @Override
                    public void onBack() {
                        Setuptool.this.doShowTagSettingTables(tag, handler);
                    }
                });
            }

            @Override
            public void onDiscardChanges(TagSettingsTableContextPanel tagSettingsTableContextPanel) {
                tag.discardChanges();
                Setuptool.this.doShowTagSettingTables(tag, handler);
            }

            @Override
            public void onSend(TagSettingsTableContextPanel tagSettingsTableContextPanel) {
                if (tag.wasEdited()) {
                    Setuptool.this.eventBus.publish(new SendTagConfigToServerEvent(tag.getTagId(), tag.getEditConfig()));
                    tag.setPendingOnServerShortcut();
                    Setuptool.this.doShowTagSettingTables(tag, handler);
                }
            }
        }, tag);
        this.appPanel.clearPanels();
        this.appPanel.setCenter(contextPanel, contentPanel);
    }

    private boolean checkTagConfigCapabilities(TagConfigGeneric config) {
        return config.checkHeaderFields();
    }

    private File getLoadFile() {
        int result;
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser(new File("/home/mcb/Documents/20170516_eobs"));
        }
        if ((result = this.fileChooser.showOpenDialog(this.appPanel)) == 0) {
            return this.fileChooser.getSelectedFile();
        }
        return null;
    }

    private File getSaveFile(File suggestedFile) {
        int result;
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
        }
        if (suggestedFile != null) {
            this.fileChooser.setSelectedFile(suggestedFile);
        }
        if ((result = this.fileChooser.showSaveDialog(this.appPanel)) == 0) {
            return this.fileChooser.getSelectedFile();
        }
        return null;
    }

    public boolean doCheckTagConfigCorrections(TagConfigGeneric currentConfig) {
        TagConfigAccess access = (TagConfigAccess)currentConfig.dispatch((TagConfigDispatch)new TagConfigDispatch<TagConfigAccess>(){

            public TagConfigAccess onV0(TagConfigV0 config) {
                return TagConfigV0Util.bind(config);
            }

            public TagConfigAccess onV1(TagConfigV1 config) {
                return TagConfigV1Util.bind(config);
            }

            public TagConfigAccess onV2(TagConfigV2 config) {
                return TagConfigV2Util.bind(config);
            }
        });
        List<ValidateTagConfig.Validation> validations = new ValidateTagConfig(access).getValidations();
        if (validations.isEmpty()) {
            return true;
        }
        String text = new ValidationPrint(validations).getText();
        int result = JOptionPane.showConfirmDialog(this.appPanel, "Your config needs some changes:\n\n" + text + "\nShould these changes be applied to your config?", "Corrections", 0, 2);
        if (result == 0) {
            new ValidationsApply(validations).apply(access);
            result = JOptionPane.showOptionDialog(this.appPanel, "You can now review the changes or send the corrected config immediatley.", "Corrections", 0, 3, null, new String[]{"Review", "Send"}, "Review");
            if (result == 1) {
                return true;
            }
        }
        return false;
    }

    public void doExit() {
        int result;
        boolean canExit;
        if (this.currentExitVetoHandler != null && !(canExit = this.currentExitVetoHandler.canExit()) && (result = JOptionPane.showConfirmDialog(this.appPanel, "Local Changes have not been uploaded and will be discarded. Do you want to proceed?", "Exit", 0)) != 0) {
            return;
        }
        int result2 = JOptionPane.showConfirmDialog(this.appPanel, "Do you really want to exit the Setuptool?", "Exit", 0);
        if (result2 == 0) {
            System.exit(0);
        }
    }

    public void doCheckCompatibility() {
        this.eventBus.publish(new TestRemoteServiceEvent());
    }

    public void doGetMyTags() {
        this.eventBus.publish(new GetTagListFromServerEvent());
    }

    public void doShowAbout() {
        final JDialog dialog = new JDialog((Frame)this.appFrame, true);
        AboutPanel aboutPanel = new AboutPanel(new AboutPanel.Handler(){

            @Override
            public void onOk() {
                dialog.setVisible(false);
            }
        });
        dialog.setTitle("About e-obs Setuptool");
        dialog.getContentPane().add(aboutPanel);
        dialog.pack();
        dialog.setLocationRelativeTo(this.appFrame);
        dialog.setVisible(true);
    }

    static {
        DEFAULT_FILE = new File(System.getProperty("user.home") + "/cfg.eob");
    }

    static interface ShowTagSettingTablesHandler {
        public void onBack();
    }

    static interface ShowTagEditHandler {
        public void onBack();
    }

    static interface ExitVetoHandler {
        public boolean canExit();
    }

    public static class OpenTagStateMachine {
        private final EventBus eventBus;
        private final Setuptool setuptool;
        private TagCredentials credentials;

        public OpenTagStateMachine(Setuptool setuptool, EventBus eventBus) {
            this.setuptool = setuptool;
            this.eventBus = eventBus;
        }

        @EventHandler(swingEDT=true)
        public void handle(OpenTagEvent event) {
            logger.info("" + event);
            this.eventBus.publish(new GetCredentialsEvent());
        }

        @EventHandler(swingEDT=true)
        public void handle(TagCredentialsEvent event) {
            this.credentials = event.getCredentials();
            logger.info("" + event.getCredentials());
            ((BasicCredentialsProvider)ctx.getBean(BasicCredentialsProvider.class)).setCredentials(AuthScope.ANY, this.credentials.toUsernamePasswordCredentials());
            this.eventBus.publish(new TagSelectEvent(this.credentials.getTagId()));
        }

        @EventHandler(swingEDT=true)
        public void handle(NewTagInfoEvent event) {
            logger.info("" + event);
            throw new RuntimeException();
        }

        @EventHandler(swingEDT=true)
        public void handle(NewTagInfoListEvent event) {
            logger.info("" + event);
            ArrayList<Tag> tags = new ArrayList<Tag>();
            for (TagInfo tagInfo : event.getTagInfos()) {
                tags.add(new Tag(tagInfo));
            }
            this.setuptool.doShowTagList(tags);
        }

        @EventHandler(swingEDT=true)
        public void handle(TagReloadEvent event) {
            logger.info("" + event);
            if (this.credentials != null) {
                this.eventBus.publish(new TagSelectEvent(this.credentials.getTagId()));
            } else {
                logger.warn("got reload event but there are no valid credentials in context");
            }
        }
    }

    public static class CheckCompatibilityStateMachine {
        private final Setuptool setuptool;
        private final EventBus eventBus;

        public CheckCompatibilityStateMachine(Setuptool setuptool, EventBus eventBus) {
            this.setuptool = setuptool;
            this.eventBus = eventBus;
        }

        @EventHandler(swingEDT=true)
        public void handle(AppReadyEvent event) {
            logger.info("" + event);
            this.eventBus.publish(new CheckCompatibilityEvent());
        }

        @EventHandler(swingEDT=true)
        public void handle(ServiceInfoEvent event) {
            logger.info("" + event);
            RemoteServiceCompatibilityCheck.ServiceInfo info = event.getInfo();
            if (Setuptool.getConfiguration().isDevelopmentMode() && !info.isClientSupported()) {
                int n = JOptionPane.showOptionDialog(this.setuptool.appPanel, "This version of the Setuptool is not compatible with the version of the server. But since you are running in Dev Mode you can continue at your own risk.", "Setuptool version check", 0, 2, null, new String[]{"Ok"}, "Ok");
            } else if (!info.isClientSupported()) {
                int result = JOptionPane.showOptionDialog(this.setuptool.appPanel, "This version of the Setuptool is no longer supported.\nPlease download the latest version from:\n" + info.getHomePageUrl(), "Setuptool version check", 0, 3, null, new String[]{"Ok", "Open Link"}, "Ok");
                logger.info("result: " + result);
                if (result == 1) {
                    try {
                        Desktop.getDesktop().browse(info.getHomePageUrl().toURI());
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    catch (URISyntaxException e) {
                        throw new RuntimeException(e);
                    }
                }
                return;
            }
            this.setuptool.appPanel.enableActions();
        }

        @EventHandler(swingEDT=true)
        public void handle(ServiceInfoFailureEvent event) {
            logger.info("" + event);
            JOptionPane.showMessageDialog(this.setuptool.appPanel, "Can't connect to server for version check. Please exit the application and try again later.", "Setuptool version check", 0);
        }
    }
}

