/*
 * Decompiled with CFR 0.152.
 */
package de.eobs.setuptool;

import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;

public class SystemInfo {
    static String getMacAddress() {
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                byte[] mac;
                NetworkInterface nic = en.nextElement();
                if (nic.isLoopback() || (mac = nic.getHardwareAddress()) == null) continue;
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < mac.length; ++i) {
                    sb.append(String.format("%02X%s", mac[i], i < mac.length - 1 ? "-" : ""));
                }
                return sb.toString();
            }
        }
        catch (SocketException ex) {
            return "Unknown MAC Address";
        }
        return "Unknown MAC Address";
    }

    public static String getHashedSystemInfo() {
        return Hashing.md5().newHasher().putString((CharSequence)SystemInfo.getMacAddress(), Charsets.UTF_8).hash().toString();
    }
}

