/*
 * Decompiled with CFR 0.152.
 */
package de.eobs.setuptool;

import de.eobs.setuptool.MyRightLineBorder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.UIResource;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;

public class TableUtils {
    static final Color TABLE_COLOR_TITLE_BACKGROUND = Color.decode("#6095c9");
    static final Color TABLE_COLOR_TITLE_FOREGROUND = Color.decode("#ffffff");
    static final Color TABLE_COLOR_GRID = Color.decode("#ffffff");
    static final Color TABLE_COLOR_EVEN_ROW_BACKGROUND = Color.decode("#d9e0ed");
    static final Color TABLE_COLOR_ODD_ROW_BACKGROUND = Color.decode("#edf1f6");
    static final Color TABLE_COLOR_SELECTED_ROW_BACKGROUND = Color.decode("#96adc8");
    static final int TABLE_TITLE_HEIGHT = 20;
    static final int TABLE_ROW_HEIGHT = 30;

    public static void configureTable(JTable table1) {
        TableUtils.configureTable(table1, null);
    }

    public static void configureTable(JTable table1, final RowManipulator rowManipulator) {
        Font headerFont = table1.getTableHeader().getFont();
        table1.getTableHeader().setFont(new Font(headerFont.getName(), 1, headerFont.getSize() * 120 / 100));
        table1.getTableHeader().setBackground(TABLE_COLOR_TITLE_BACKGROUND);
        table1.getTableHeader().setForeground(TABLE_COLOR_TITLE_FOREGROUND);
        table1.setGridColor(TABLE_COLOR_GRID);
        table1.getTableHeader().setPreferredSize(new Dimension(1, 20));
        table1.setRowHeight(30);
        table1.getTableHeader().setDefaultRenderer(new DefaultTableCellHeaderRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
                JLabel l = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
                l.setBorder(new MyRightLineBorder(TABLE_COLOR_GRID));
                return l;
            }
        });
        table1.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
                JLabel l = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
                l.setHorizontalAlignment(0);
                if (rowManipulator != null) {
                    rowManipulator.apply(table, value, isSelected, hasFocus, row, col, l);
                }
                if (isSelected) {
                    l.setBackground(TABLE_COLOR_SELECTED_ROW_BACKGROUND);
                } else if (row % 2 == 0) {
                    l.setBackground(TABLE_COLOR_EVEN_ROW_BACKGROUND);
                } else {
                    l.setBackground(TABLE_COLOR_ODD_ROW_BACKGROUND);
                }
                return l;
            }
        });
        JComponent xx = (JComponent)((Object)table1.getDefaultRenderer(Boolean.class));
        table1.setDefaultRenderer(Boolean.class, new MyBooleanRenderer());
    }

    static class DefaultTableCellHeaderRenderer
    extends DefaultTableCellRenderer
    implements UIResource {
        private boolean horizontalTextPositionSet;
        private Icon sortArrow;
        private EmptyIcon emptyIcon = new EmptyIcon();

        public DefaultTableCellHeaderRenderer() {
            this.setHorizontalAlignment(0);
        }

        @Override
        public void setHorizontalTextPosition(int textPosition) {
            this.horizontalTextPositionSet = true;
            super.setHorizontalTextPosition(textPosition);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Icon sortIcon = null;
            boolean isPaintingForPrint = false;
            if (table != null) {
                JTableHeader header = table.getTableHeader();
                if (header != null) {
                    Color fgColor = null;
                    Color bgColor = null;
                    if (hasFocus) {
                        fgColor = UIManager.getColor("TableHeader.focusCellForeground");
                        bgColor = UIManager.getColor("TableHeader.focusCellBackground");
                    }
                    if (fgColor == null) {
                        fgColor = header.getForeground();
                    }
                    if (bgColor == null) {
                        bgColor = header.getBackground();
                    }
                    this.setForeground(fgColor);
                    this.setBackground(bgColor);
                    this.setFont(header.getFont());
                    isPaintingForPrint = header.isPaintingForPrint();
                }
                if (!isPaintingForPrint && table.getRowSorter() != null) {
                    SortOrder sortOrder;
                    if (!this.horizontalTextPositionSet) {
                        this.setHorizontalTextPosition(10);
                    }
                    if ((sortOrder = DefaultTableCellHeaderRenderer.getColumnSortOrder(table, column)) != null) {
                        switch (sortOrder) {
                            case ASCENDING: {
                                sortIcon = UIManager.getIcon("Table.ascendingSortIcon");
                                break;
                            }
                            case DESCENDING: {
                                sortIcon = UIManager.getIcon("Table.descendingSortIcon");
                                break;
                            }
                            case UNSORTED: {
                                sortIcon = UIManager.getIcon("Table.naturalSortIcon");
                            }
                        }
                    }
                }
            }
            this.setText(value == null ? "" : value.toString());
            this.setIcon(sortIcon);
            this.sortArrow = sortIcon;
            Border border = null;
            if (hasFocus) {
                border = UIManager.getBorder("TableHeader.focusCellBorder");
            }
            if (border == null) {
                border = UIManager.getBorder("TableHeader.cellBorder");
            }
            this.setBorder(border);
            return this;
        }

        public static SortOrder getColumnSortOrder(JTable table, int column) {
            SortOrder rv = null;
            if (table == null || table.getRowSorter() == null) {
                return rv;
            }
            List<RowSorter.SortKey> sortKeys = table.getRowSorter().getSortKeys();
            if (sortKeys.size() > 0 && sortKeys.get(0).getColumn() == table.convertColumnIndexToModel(column)) {
                rv = sortKeys.get(0).getSortOrder();
            }
            return rv;
        }

        @Override
        public void paintComponent(Graphics g) {
            boolean b = UIManager.getBoolean("TableHeader.rightAlignSortArrow");
            if (b && this.sortArrow != null) {
                this.emptyIcon.width = this.sortArrow.getIconWidth();
                this.emptyIcon.height = this.sortArrow.getIconHeight();
                this.setIcon(this.emptyIcon);
                super.paintComponent(g);
                Point position = this.computeIconPosition(g);
                this.sortArrow.paintIcon(this, g, position.x, position.y);
            } else {
                super.paintComponent(g);
            }
        }

        private Point computeIconPosition(Graphics g) {
            FontMetrics fontMetrics = g.getFontMetrics();
            Rectangle viewR = new Rectangle();
            Rectangle textR = new Rectangle();
            Rectangle iconR = new Rectangle();
            Insets i = this.getInsets();
            viewR.x = i.left;
            viewR.y = i.top;
            viewR.width = this.getWidth() - (i.left + i.right);
            viewR.height = this.getHeight() - (i.top + i.bottom);
            SwingUtilities.layoutCompoundLabel(this, fontMetrics, this.getText(), this.sortArrow, this.getVerticalAlignment(), this.getHorizontalAlignment(), this.getVerticalTextPosition(), this.getHorizontalTextPosition(), viewR, iconR, textR, this.getIconTextGap());
            int x = this.getWidth() - i.right - this.sortArrow.getIconWidth();
            int y = iconR.y;
            return new Point(x, y);
        }

        private class EmptyIcon
        implements Icon,
        Serializable {
            int width = 0;
            int height = 0;

            private EmptyIcon() {
            }

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
            }

            @Override
            public int getIconWidth() {
                return this.width;
            }

            @Override
            public int getIconHeight() {
                return this.height;
            }
        }
    }

    static class MyBooleanRenderer
    extends JCheckBox
    implements TableCellRenderer,
    UIResource {
        private static final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

        public MyBooleanRenderer() {
            this.setHorizontalAlignment(0);
            this.setBorderPainted(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setBackground(TABLE_COLOR_SELECTED_ROW_BACKGROUND);
            } else if (row % 2 == 0) {
                this.setBackground(TABLE_COLOR_EVEN_ROW_BACKGROUND);
            } else {
                this.setBackground(TABLE_COLOR_ODD_ROW_BACKGROUND);
            }
            this.setSelected(value != null && (Boolean)value != false);
            if (hasFocus) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                this.setBorder(noFocusBorder);
            }
            return this;
        }
    }

    public static interface RowManipulator {
        public void apply(JTable var1, Object var2, boolean var3, boolean var4, int var5, int var6, JLabel var7);
    }
}

