/*
 * Decompiled with CFR 0.152.
 */
package de.eobs.setuptool;

import de.eobs.setuptool.TagConfigUtil;
import de.eobs.setuptool.rest.api.TagId;
import de.eobs.setuptool.rest.api.TagInfo;
import de.eobs.setuptool.tagconfig.CfgHeader;
import de.eobs.setuptool.tagconfig.TagConfigGeneric;
import java.util.Arrays;

public class Tag {
    private TagId tagId;
    private TagInfo tagInfo;
    private TagConfigGeneric currentConfig;
    private TagConfigGeneric updateConfig;
    private TagConfigGeneric initialConfig;
    private TagConfigGeneric editConfig;

    public Tag(TagInfo tagInfo) {
        if (tagInfo == null) {
            throw new IllegalArgumentException("tagInfo is null");
        }
        this.tagId = tagInfo.getTagId();
        this.tagInfo = tagInfo;
        this.currentConfig = tagInfo.getCurrentConfig().copy();
        TagConfigGeneric tagConfigGeneric = this.updateConfig = tagInfo.getUpdateConfig().isPresent() ? ((TagConfigGeneric)tagInfo.getUpdateConfig().get()).copy() : null;
        if (tagInfo.getUpdateConfig().isPresent()) {
            this.initialConfig = ((TagConfigGeneric)tagInfo.getUpdateConfig().get()).copy();
            this.editConfig = ((TagConfigGeneric)tagInfo.getUpdateConfig().get()).copy();
        } else if (tagInfo.getCurrentConfig() != null) {
            this.initialConfig = tagInfo.getCurrentConfig().copy();
            this.editConfig = tagInfo.getCurrentConfig().copy();
        } else if (tagInfo.getConfig() != null) {
            this.initialConfig = tagInfo.getConfig();
            this.editConfig = tagInfo.getConfig();
        }
    }

    public TagId getTagId() {
        return this.tagId;
    }

    public TagConfigGeneric getCurrentConfig() {
        return this.currentConfig.copy();
    }

    public boolean hasUpdateConfig() {
        return this.updateConfig != null;
    }

    public TagConfigGeneric getUpdateConfig() {
        return this.updateConfig != null ? this.updateConfig.copy() : null;
    }

    public boolean wasUpdated() {
        return this.updateConfig != null && !Arrays.equals(this.currentConfig.toBytes(), this.updateConfig.toBytes());
    }

    public TagConfigGeneric getEditConfig() {
        return this.editConfig != null ? this.editConfig.copy() : null;
    }

    public boolean wasEdited() {
        return this.initialConfig != null && this.editConfig != null && !Arrays.equals(this.initialConfig.toBytes(), this.editConfig.toBytes());
    }

    public void discardChanges() {
        this.editConfig = this.initialConfig.copy();
    }

    public void setPendingOnServerShortcut() {
        this.updateConfig = this.editConfig.copy();
        this.editConfig = this.initialConfig.copy();
    }

    public void setEditConfigSafe(TagConfigGeneric newConfig) {
        this.editConfig = TagConfigUtil.safeMerge(newConfig, this.currentConfig);
    }

    public void setEditConfigUnsafe(TagConfigGeneric newConfig) {
        this.editConfig = newConfig.copy();
    }

    public boolean exportOptionsEnabled() {
        return this.tagInfo.exportOptionsEnabled();
    }

    public CfgHeader getCurrentHeader() {
        return this.tagInfo.getCurrentHeader();
    }

    public Status getStatus() {
        if (this.wasEdited()) {
            return Status.LocalChanges;
        }
        if (this.wasUpdated()) {
            return Status.PendingOnServer;
        }
        return Status.Ok;
    }

    public static enum Status {
        Ok,
        LocalChanges,
        PendingOnServer;

    }
}

