/*
 * Decompiled with CFR 0.152.
 */
package de.eobs.setuptool;

import de.eobs.setuptool.tagconfig.HeaderFields;
import de.eobs.setuptool.tagconfig.TagConfigDispatch;
import de.eobs.setuptool.tagconfig.TagConfigGeneric;
import de.eobs.setuptool.tagconfig.TagConfigV0;
import de.eobs.setuptool.tagconfig.TagConfigV1;
import de.eobs.setuptool.tagconfig.TagConfigV2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagConfigUtil {
    static Logger logger = LoggerFactory.getLogger(TagConfigUtil.class);

    public static boolean isConfigLegal(TagConfigGeneric config) {
        if (config.magic().getValue() != 39738) {
            return false;
        }
        if (config.eobs_tag_type().getValue() != 5) {
            return false;
        }
        return config.software_major_version().getValue() == 10;
    }

    public static boolean areConfigsCompatibleON2TIMES(TagConfigV2 config1, TagConfigV2 config2) {
        long ON2TIMES = HeaderFields.Feature.WITH_ON2TIMES.getAsLongFlag();
        long swf1 = config1.swfeatures().getValue() & ON2TIMES;
        long swf2 = config2.swfeatures().getValue() & ON2TIMES;
        if (swf1 == ON2TIMES && swf2 != ON2TIMES || swf1 != ON2TIMES && swf2 == ON2TIMES) {
            logger.info("ConfigV2: handle sw features for WITH_ON2TIMES");
            return config1.gps_on2time().getBegin() == 0 && config1.gps_on2time().getEnd() == 0 && config1.acc_on2time().getBegin() == 0 && config1.acc_on2time().getEnd() == 0 && config1.imu_on2time().getBegin() == 0 && config1.imu_on2time().getEnd() == 0 && config2.gps_on2time().getBegin() == 0 && config2.gps_on2time().getEnd() == 0 && config2.acc_on2time().getBegin() == 0 && config2.acc_on2time().getEnd() == 0 && config2.imu_on2time().getBegin() == 0 && config2.imu_on2time().getEnd() == 0;
        }
        return true;
    }

    public static boolean areConfigsCompatible(final TagConfigGeneric config1, final TagConfigGeneric config2) {
        if (config1.magic().getValue() != config2.magic().getValue()) {
            return false;
        }
        if (config1.eobs_tag_type().getValue() != config2.eobs_tag_type().getValue()) {
            return false;
        }
        if (config1.software_major_version().getValue() != config2.software_major_version().getValue()) {
            return false;
        }
        if (config1.other_version().getValue() != config2.other_version().getValue()) {
            return false;
        }
        boolean success_swFeatures = (Boolean)config1.dispatch((TagConfigDispatch)new TagConfigDispatch<Boolean>(){

            public Boolean onV0(TagConfigV0 config) {
                return config1.swfeatures().getValue() == config2.swfeatures().getValue();
            }

            public Boolean onV1(TagConfigV1 config) {
                return config1.swfeatures().getValue() == config2.swfeatures().getValue();
            }

            public Boolean onV2(TagConfigV2 config) {
                long swf2;
                long BOTHSENSORSBOTTOMSIDE = HeaderFields.Feature.WITH_BOTHSENSORSBOTTOMSIDE.getAsLongFlag();
                long swf1 = config1.swfeatures().getValue() & (BOTHSENSORSBOTTOMSIDE ^ 0xFFFFFFFFFFFFFFFFL);
                if (swf1 == (swf2 = config2.swfeatures().getValue() & (BOTHSENSORSBOTTOMSIDE ^ 0xFFFFFFFFFFFFFFFFL)) && config1.swfeatures().getValue() != config2.swfeatures().getValue()) {
                    logger.info("ConfigV2: handle sw features as compatible after ignoring WITH_BOTHSENSORSBOTTOMSIDE");
                }
                if (!TagConfigUtil.areConfigsCompatibleON2TIMES((TagConfigV2)config1, (TagConfigV2)config2)) {
                    return false;
                }
                long ON2TIMES = HeaderFields.Feature.WITH_ON2TIMES.getAsLongFlag();
                return (swf1 &= ON2TIMES ^ 0xFFFFFFFFFFFFFFFFL) == (swf2 &= ON2TIMES ^ 0xFFFFFFFFFFFFFFFFL);
            }
        });
        if (!success_swFeatures) {
            return false;
        }
        boolean success_Use_869_85_TX = (Boolean)config1.dispatch((TagConfigDispatch)new TagConfigDispatch<Boolean>(){

            public Boolean onV0(TagConfigV0 config) {
                return true;
            }

            public Boolean onV1(TagConfigV1 config) {
                return config.getUse_869_85_TX() == ((TagConfigV1)config2).getUse_869_85_TX();
            }

            public Boolean onV2(TagConfigV2 config) {
                if (config.supportsUse_869_85_TX() && ((TagConfigV2)config2).supportsUse_869_85_TX()) {
                    return config.getUse_869_85_TX() == ((TagConfigV2)config2).getUse_869_85_TX();
                }
                if (!config.supportsUse_869_85_TX() && ((TagConfigV2)config2).supportsUse_869_85_TX()) {
                    return false;
                }
                if (config.supportsUse_869_85_TX() && !((TagConfigV2)config2).supportsUse_869_85_TX()) {
                    return false;
                }
                return true;
            }
        });
        return success_Use_869_85_TX;
    }

    public static TagConfigGeneric safeMerge(TagConfigGeneric newConfig, final TagConfigGeneric currentConfig) {
        if (!TagConfigUtil.isConfigLegal(newConfig)) {
            throw new IllegalArgumentException("config not legal");
        }
        if (!TagConfigUtil.areConfigsCompatible(newConfig, currentConfig)) {
            throw new IllegalArgumentException("configs not compatible");
        }
        TagConfigGeneric mergedConfig = newConfig.copy();
        mergedConfig = (TagConfigGeneric)mergedConfig.dispatch((TagConfigDispatch)new TagConfigDispatch<TagConfigGeneric>(){

            public TagConfigGeneric onV0(TagConfigV0 config) {
                TagConfigV0 current = (TagConfigV0)currentConfig;
                config.freq_pinger().setValue(current.freq_pinger().getValue());
                config.freq_dead_pinger().setValue(current.freq_dead_pinger().getValue());
                config.secret_key().setValue(current.secret_key().getValue());
                config.access_key().setValue(current.access_key().getValue());
                config.security_switch().setValue(current.security_switch().getValue());
                return config;
            }

            public TagConfigGeneric onV1(TagConfigV1 config) {
                TagConfigV1 current = (TagConfigV1)currentConfig;
                config.freq_pinger().setValue(current.freq_pinger().getValue());
                config.freq_dead_pinger().setValue(current.freq_dead_pinger().getValue());
                config.secret_key().setValue(current.secret_key().getValue());
                config.access_key().setValue(current.access_key().getValue());
                config.security_switch().setValue(current.security_switch().getValue());
                return config;
            }

            public TagConfigGeneric onV2(TagConfigV2 config) {
                TagConfigV2 current = (TagConfigV2)currentConfig;
                config.ping_frequency().setValue(current.ping_frequency().getValue());
                config.freq_dead_pinger().setValue(current.freq_dead_pinger().getValue());
                config.secret_key().setValue(current.secret_key().getValue());
                config.access_key().setValue(current.access_key().getValue());
                config.security_switch().setValue(current.security_switch().getValue());
                if (config.swfeatures().getValue() != current.swfeatures().getValue()) {
                    logger.info("ConfigV2: reset sw features to original config");
                }
                config.swfeatures().setValue(current.swfeatures().getValue());
                return config;
            }
        });
        return mergedConfig;
    }

    public static boolean isHighDataUsageConfig(TagConfigGeneric config) {
        return (Boolean)config.dispatch((TagConfigDispatch)new TagConfigDispatch<Boolean>(){

            public Boolean onV0(TagConfigV0 config) {
                return false;
            }

            public Boolean onV1(TagConfigV1 config) {
                return config.hasSwFeaturesEnabled(new HeaderFields.Feature[]{HeaderFields.Feature.WITH_SUPER_BURST}) && config.bat_threshold3().getValue() < 3440 && config.super_memory_limit().getValue() > 4;
            }

            public Boolean onV2(TagConfigV2 config) {
                return config.bat_threshold3().getValue() < 3440 && config.sm_gps_mem_limit().getValue() > 4;
            }
        });
    }
}

