/*
 * Decompiled with CFR 0.152.
 */
package de.eobs.setuptool;

import de.eobs.setuptool.TableUtils;
import de.eobs.setuptool.Tag;
import de.eobs.setuptool.tagconfig.HeaderFields;
import de.eobs.setuptool.tagconfig.TagConfigDispatch;
import de.eobs.setuptool.tagconfig.TagConfigV0;
import de.eobs.setuptool.tagconfig.TagConfigV1;
import de.eobs.setuptool.tagconfig.TagConfigV2;
import de.eobs.setuptool.tagconfig.U32;
import java.awt.Color;
import java.awt.Desktop;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Days;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagListPanel
extends JPanel {
    private static final Logger logger = LoggerFactory.getLogger(TagListPanel.class);
    static final int COL_INDEX_VERSION = 1;
    static final int COL_INDEX_CONNECTION = 3;
    static final int COL_INDEX_BATTERY_VOLTAGE = 5;
    public static final Color COLOR_WARNING = new Color(191, 0, 0);
    static final int CONNECTION_WARNING_THRESHOLD_DAYS = 365;
    private final Handler handler;
    static final DateTimeFormatter FORMATTER = DateTimeFormat.forPattern((String)"YYYY-MM-dd HH:mm");
    static final DateTimeFormatter FORMATTER_DATE = DateTimeFormat.forPattern((String)"YYYY-MM-dd");
    final List<TagItem> tagItems = new ArrayList<TagItem>();
    private JScrollPane scrollPane1;
    private JTable table1;

    public TagListPanel(final Handler handler, final boolean areEobsExpertOptionsEnabled) {
        this.handler = handler;
        this.initComponents();
        TableUtils.RowManipulator rowManipulator = new TableUtils.RowManipulator(){

            @Override
            public void apply(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col, JLabel label) {
                DateTime now;
                DateTime connectTs;
                int days;
                MyTableModel tableModel = (MyTableModel)table.getModel();
                int index = table.convertRowIndexToModel(row);
                label.setForeground(Color.BLACK);
                if (TagListPanel.this.tagItems.get(index).getTag().getStatus() != Tag.Status.Ok) {
                    label.setForeground(Color.RED);
                }
                if (col == 3 && (days = Days.daysBetween((ReadableInstant)(connectTs = new DateTime(TagListPanel.this.tagItems.get(index).tag.getCurrentHeader().getTagConnectTimes().getValue() * 1000L, DateTimeZone.UTC)), (ReadableInstant)(now = new DateTime(DateTimeZone.UTC))).getDays()) > 365) {
                    label.setForeground(COLOR_WARNING);
                }
                if (col == 5 && TagListPanel.this.tagItems.get(index).tag.getCurrentHeader().getBatvoltage().getValue() < 3750) {
                    label.setForeground(COLOR_WARNING);
                }
                if (areEobsExpertOptionsEnabled) {
                    if (col == 1) {
                        StringBuilder sb = new StringBuilder();
                        sb.append("<html>");
                        sb.append("Logger ID: " + TagListPanel.this.tagItems.get(index).tag.getTagId().getValue());
                        sb.append("<br>");
                        sb.append("Version: " + TagListPanel.this.tagItems.get(index).configName);
                        sb.append("<br>");
                        sb.append("Feature Flags: " + String.format("%x", TagListPanel.this.tagItems.get(index).swfeatures.getValue()));
                        sb.append("<br>");
                        sb.append("Features:");
                        sb.append("<br>");
                        for (HeaderFields.Feature f : HeaderFields.Feature.enabledFlags((U32)TagListPanel.this.tagItems.get(index).swfeatures)) {
                            sb.append("&emsp;&#x2022;" + f.toString());
                            sb.append("<br>");
                        }
                        sb.append("</html>");
                        label.setToolTipText(sb.toString());
                    } else {
                        label.setToolTipText(null);
                    }
                }
            }
        };
        TableUtils.configureTable(this.table1, rowManipulator);
        this.table1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int index;
                if (e.getClickCount() == 2 && e.getButton() == 1 && (index = TagListPanel.this.table1.convertRowIndexToModel(TagListPanel.this.table1.getSelectedRow())) >= 0 && index < TagListPanel.this.tagItems.size() && handler != null) {
                    handler.onTagSelected(TagListPanel.this.tagItems.get(index).getTag());
                }
            }
        });
        this.table1.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                super.keyReleased(e);
                logger.info("keyReleased: " + e);
                if (e.isControlDown() && e.getKeyCode() == 70) {
                    int index;
                    logger.info("copy gps location to clip board");
                    String cbText = "";
                    if (TagListPanel.this.table1.getSelectedRow() >= 0 && (index = TagListPanel.this.table1.convertRowIndexToModel(TagListPanel.this.table1.getSelectedRow())) >= 0 && index < TagListPanel.this.tagItems.size()) {
                        String gpsText = TagListPanel.formatLocation((double)TagListPanel.this.tagItems.get(index).tag.getCurrentHeader().getLatitude().getValue() * 1.0E-7) + ", " + TagListPanel.formatLocation((double)TagListPanel.this.tagItems.get(index).tag.getCurrentHeader().getLongitude().getValue() * 1.0E-7);
                        logger.info("set clipboard to: " + gpsText);
                        cbText = gpsText;
                    }
                    StringSelection stringSelection = new StringSelection(cbText);
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    clipboard.setContents(stringSelection, null);
                } else if (e.isControlDown() && e.getKeyCode() == 71) {
                    int index;
                    logger.info("copy gps location to clip board");
                    String cbText = "";
                    if (TagListPanel.this.table1.getSelectedRow() >= 0 && (index = TagListPanel.this.table1.convertRowIndexToModel(TagListPanel.this.table1.getSelectedRow())) >= 0 && index < TagListPanel.this.tagItems.size()) {
                        String gpsText = TagListPanel.formatLocation((double)TagListPanel.this.tagItems.get(index).tag.getCurrentHeader().getLatitude().getValue() * 1.0E-7) + "," + TagListPanel.formatLocation((double)TagListPanel.this.tagItems.get(index).tag.getCurrentHeader().getLongitude().getValue() * 1.0E-7);
                        logger.info("set clipboard to: " + gpsText);
                        cbText = gpsText;
                    }
                    if (cbText.length() > 0 && Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                        try {
                            Desktop.getDesktop().browse(new URI("https://maps.google.com?q=" + cbText));
                        }
                        catch (IOException ex) {
                            throw new RuntimeException(ex);
                        }
                        catch (URISyntaxException ex) {
                            throw new RuntimeException(ex);
                        }
                    }
                }
            }
        });
    }

    public List<Tag> getSelectedItems() {
        ArrayList<Tag> tagInfos = new ArrayList<Tag>();
        for (TagItem tagItem : this.tagItems) {
            if (!tagItem.isSelected()) continue;
            tagInfos.add(tagItem.getTag());
        }
        return tagInfos;
    }

    public static String formatLocation(double v) {
        DecimalFormat format = new DecimalFormat("#.#######");
        return format.format(v);
    }

    public static String formatDownloaded(int bytesDownloaded, int bytesTotal) {
        long promille = (long)bytesDownloaded * 1000L / (long)bytesTotal;
        long fraction = promille % 10L;
        long percent = promille / 10L;
        String str = String.format("%d.%d%%", percent, fraction);
        return str;
    }

    public void updateGui(List<Tag> tagInfos) {
        this.tagItems.clear();
        for (Tag tagInfo : tagInfos) {
            this.tagItems.add(new TagItem(tagInfo));
        }
        Collections.sort(this.tagItems, new Comparator<TagItem>(){

            @Override
            public int compare(TagItem o1, TagItem o2) {
                return Integer.compare(o1.tag.getTagId().getValue(), o2.tag.getTagId().getValue());
            }
        });
        this.table1.setModel(new MyTableModel());
    }

    private void initComponents() {
        this.scrollPane1 = new JScrollPane();
        this.table1 = new JTable();
        this.table1.setSelectionMode(0);
        this.table1.setAutoCreateRowSorter(true);
        this.scrollPane1.setViewportView(this.table1);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent(this.scrollPane1, -1, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup().addComponent(this.scrollPane1, -1, 300, Short.MAX_VALUE));
    }

    public static class TagItem {
        private final Tag tag;
        private final String configName;
        private final U32 swfeatures;
        public Boolean selected;

        public TagItem(Tag tag) {
            this.tag = tag;
            this.configName = (String)this.tag.getCurrentConfig().dispatch((TagConfigDispatch)new TagConfigDispatch<String>(){

                public String onV0(TagConfigV0 config) {
                    return "v0";
                }

                public String onV1(TagConfigV1 config) {
                    return "v1";
                }

                public String onV2(TagConfigV2 config) {
                    return "v2";
                }
            });
            this.swfeatures = (U32)this.tag.getCurrentConfig().dispatch((TagConfigDispatch)new TagConfigDispatch<U32>(){

                public U32 onV0(TagConfigV0 config) {
                    return config.swfeatures();
                }

                public U32 onV1(TagConfigV1 config) {
                    return config.swfeatures();
                }

                public U32 onV2(TagConfigV2 config) {
                    return config.swfeatures();
                }
            });
        }

        String getVersionAndFeatures() {
            if (this.configName.equals("v2")) {
                long swfeaturesFlags = this.swfeatures.getValue() & 0x23000L;
                String version = "";
                version = swfeaturesFlags == 0L ? "v2" : (swfeaturesFlags == 4096L ? "v2.1" : (swfeaturesFlags == 8192L ? "v2.2" : (swfeaturesFlags == 131072L ? "v2.3" : (swfeaturesFlags == 135168L ? "v2.4" : (swfeaturesFlags == 139264L ? "v2.5" : "v2.X")))));
                return version;
            }
            return this.configName;
        }

        public boolean isSelected() {
            return this.selected != null ? this.selected : false;
        }

        public Tag getTag() {
            return this.tag;
        }
    }

    private class MyTableModel
    extends AbstractTableModel {
        private final String[] columnNames = new String[]{"Logger ID", "Version", "Status", "Connection", "Duration", "Battery Voltage", "GPS lat, lon", "GPS fix time", "kBytes available", "Downloaded", "Select"};
        private final Class[] columnClasses = new Class[]{String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, Boolean.class};

        private MyTableModel() {
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return this.columnClasses[columnIndex];
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 10;
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        @Override
        public int getRowCount() {
            return TagListPanel.this.tagItems.size();
        }

        @Override
        public int getColumnCount() {
            return 11;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return Integer.toString(TagListPanel.this.tagItems.get(rowIndex).tag.getTagId().getValue());
            }
            if (columnIndex == 1) {
                return TagListPanel.this.tagItems.get(rowIndex).getVersionAndFeatures();
            }
            if (columnIndex == 2) {
                return TagListPanel.this.tagItems.get(rowIndex).getTag().getStatus().toString();
            }
            if (columnIndex == 3) {
                DateTime now;
                DateTime connectTs = new DateTime(TagListPanel.this.tagItems.get(rowIndex).tag.getCurrentHeader().getTagConnectTimes().getValue() * 1000L, DateTimeZone.UTC);
                int days = Days.daysBetween((ReadableInstant)connectTs, (ReadableInstant)(now = new DateTime(DateTimeZone.UTC))).getDays();
                if (days > 365) {
                    return FORMATTER_DATE.print((ReadableInstant)new DateTime(TagListPanel.this.tagItems.get(rowIndex).tag.getCurrentHeader().getTagConnectTimes().getValue() * 1000L, DateTimeZone.UTC)) + " >1 year";
                }
                return FORMATTER.print((ReadableInstant)new DateTime(TagListPanel.this.tagItems.get(rowIndex).tag.getCurrentHeader().getTagConnectTimes().getValue() * 1000L, DateTimeZone.UTC));
            }
            if (columnIndex == 4) {
                return TagListPanel.this.tagItems.get(rowIndex).tag.getCurrentHeader().getGprsDuration().getValue() + "s";
            }
            if (columnIndex == 5) {
                return TagListPanel.this.tagItems.get(rowIndex).tag.getCurrentHeader().getBatvoltage().getValue() + "mV";
            }
            if (columnIndex == 6) {
                return TagListPanel.formatLocation((double)TagListPanel.this.tagItems.get(rowIndex).tag.getCurrentHeader().getLatitude().getValue() * 1.0E-7) + ", " + TagListPanel.formatLocation((double)TagListPanel.this.tagItems.get(rowIndex).tag.getCurrentHeader().getLongitude().getValue() * 1.0E-7);
            }
            if (columnIndex == 7) {
                return FORMATTER.print((ReadableInstant)new DateTime(TagListPanel.this.tagItems.get(rowIndex).tag.getCurrentHeader().getGpsfixtime().getValue() * 1000L, DateTimeZone.UTC));
            }
            if (columnIndex == 8) {
                return Integer.toString(TagListPanel.this.tagItems.get(rowIndex).tag.getCurrentHeader().getBytesAvailable().getValue() / 1000);
            }
            if (columnIndex == 9) {
                if (TagListPanel.this.tagItems.get(rowIndex).tag.getCurrentHeader().getBytesAvailable().getValue() == 0) {
                    return "N/A";
                }
                return TagListPanel.formatDownloaded(TagListPanel.this.tagItems.get(rowIndex).tag.getCurrentHeader().getBytesDownloaded().getValue(), TagListPanel.this.tagItems.get(rowIndex).tag.getCurrentHeader().getBytesAvailable().getValue());
            }
            if (columnIndex == 10) {
                return TagListPanel.this.tagItems.get((int)rowIndex).selected;
            }
            return "TODO(" + rowIndex + ", " + columnIndex + ")";
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 10) {
                TagListPanel.this.tagItems.get((int)rowIndex).selected = (Boolean)aValue;
            }
        }
    }

    static interface Handler {
        public void onTagSelected(Tag var1);
    }
}

