/*
 * Decompiled with CFR 0.152.
 */
package de.eobs.setuptool;

import com.google.common.primitives.UnsignedInteger;
import de.eobs.setuptool.gui.tagconfigaccess.TagConfigAccess;
import de.eobs.setuptool.gui.tagconfigaccess.Vocabular;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ValidateTagConfig {
    final List<Validation> validations = new ArrayList<Validation>();

    public ValidateTagConfig(TagConfigAccess access) {
        UnsignedInteger burst_qperiod = UnsignedInteger.valueOf((long)access.get(Vocabular.burst_qperiod));
        UnsignedInteger burst_length = UnsignedInteger.valueOf((long)access.get(Vocabular.burst_length));
        burst_length = burst_length.minus(burst_length.minus(UnsignedInteger.ONE).mod(burst_qperiod));
        if (access.get(Vocabular.burst_length) != (long)burst_length.intValue()) {
            this.validations.add(new ValidationBurstLength(access.get(Vocabular.burst_length), burst_length.intValue()));
        }
    }

    public List<Validation> getValidations() {
        return Collections.unmodifiableList(this.validations);
    }

    static class ValidationBurstLength
    implements Validation {
        private final long oldValue;
        private final long newValue;

        public ValidationBurstLength(long oldValue, long newValue) {
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        @Override
        public String getText() {
            return "\u2022 Change burst length from " + this.oldValue + " to " + this.newValue + " to save energy.";
        }

        @Override
        public void apply(TagConfigAccess access) {
            access.set(Vocabular.burst_length, this.newValue);
        }
    }

    public static interface Validation {
        public String getText();

        public void apply(TagConfigAccess var1);
    }
}

