/*
 * Decompiled with CFR 0.152.
 */
package de.eobs.setuptool.configv0;

import de.eobs.setuptool.ConfigPanels;
import de.eobs.setuptool.SettingsPanel;
import de.eobs.setuptool.configv0.ConfigV0PanelFactory;
import de.eobs.setuptool.gui.configurablepanel.ConfigurablePanel;
import de.eobs.setuptool.gui.configurablepanel.PanelConfig;
import de.eobs.setuptool.gui.rowpanel.Row;
import de.eobs.setuptool.gui.table.TableRow;
import de.eobs.setuptool.gui.tagconfigaccess.BaseAttribute;
import de.eobs.setuptool.gui.tagconfigaccess.TagConfigAccess;
import de.eobs.setuptool.gui.tagconfigaccess.TagConfigV0Util;
import de.eobs.setuptool.tagconfig.TagConfigGeneric;
import de.eobs.setuptool.tagconfig.TagConfigV0;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigPanelsV0
implements ConfigPanels {
    private static final Logger logger = LoggerFactory.getLogger(ConfigPanelsV0.class);
    final ConfigurablePanel basicPanel;
    final ConfigurablePanel advancedPanel;
    final ConfigurablePanel expertPanel;
    private final boolean expertOptionsEnabled;

    public ConfigPanelsV0(boolean expertOptionsEnabled) {
        this.expertOptionsEnabled = expertOptionsEnabled;
        this.basicPanel = new ConfigurablePanel(ConfigV0PanelFactory.create());
        this.advancedPanel = new ConfigurablePanel(ConfigV0PanelFactory.createAdvanced());
        this.expertPanel = new ConfigurablePanel(ConfigV0PanelFactory.createExpert());
    }

    @Override
    public TagConfigGeneric updateTagConfig(TagConfigGeneric config) {
        config = config.copy();
        TagConfigAccess access = TagConfigV0Util.bind((TagConfigV0)config);
        this.basicPanel.updateConfig(access);
        this.advancedPanel.updateConfig(access);
        this.expertPanel.updateConfig(access);
        return config;
    }

    @Override
    public boolean isUserInputValid() {
        return this.basicPanel.isUserInputValid() && this.advancedPanel.isUserInputValid();
    }

    @Override
    public void updateModel(TagConfigGeneric config) {
        TagConfigAccess access = TagConfigV0Util.bind((TagConfigV0)config);
        this.basicPanel.fromConfig(access);
        this.advancedPanel.fromConfig(access);
        this.expertPanel.fromConfig(access);
    }

    @Override
    public List<TableRow> createTabelRows(TagConfigGeneric tagConfig) {
        ArrayList<TableRow> tableRows = new ArrayList<TableRow>();
        TagConfigAccess access = TagConfigV0Util.bind((TagConfigV0)tagConfig);
        if (this.expertOptionsEnabled) {
            tableRows.add(new TableRow("Basic Settings", ""));
            this.createTableRows(tableRows, access, this.basicPanel);
            tableRows.add(new TableRow("", ""));
            tableRows.add(new TableRow("Advanced Settings", ""));
            this.createTableRows(tableRows, access, this.advancedPanel);
            tableRows.add(new TableRow("", ""));
            tableRows.add(new TableRow("Expert Settings", ""));
            this.createTableRows(tableRows, access, this.expertPanel);
        } else {
            tableRows.add(new TableRow("Basic Settings", ""));
            this.createTableRows(tableRows, access, this.basicPanel);
            tableRows.add(new TableRow("", ""));
            tableRows.add(new TableRow("Advanced Settings", ""));
            this.createTableRows(tableRows, access, this.advancedPanel);
            tableRows.add(new TableRow("", ""));
        }
        return tableRows;
    }

    private void createTableRows(List<TableRow> tableRows, TagConfigAccess access, ConfigurablePanel configurablePanel) {
        HashMap<BaseAttribute, PanelConfig.UpdateGui> updateGuiList = configurablePanel.updateGuiList;
        Object[] rows = configurablePanel.rows;
        for (int i = 0; i < rows.length; ++i) {
            Row r;
            logger.info("row[" + i + "]: " + rows[i]);
            if (rows[i] instanceof BaseAttribute) {
                r = configurablePanel.rowMap.get(rows[i]);
                PanelConfig.UpdateGui u = updateGuiList.get(rows[i]);
                logger.info(" => str: " + u.convertToString(access));
                tableRows.add(new TableRow(r.convertToString(), u.convertToString(access)));
                continue;
            }
            if (!(rows[i] instanceof Row)) continue;
            r = (Row)rows[i];
            logger.info(" => str: " + r.convertToString());
            tableRows.add(new TableRow(r.convertToString(), ""));
        }
    }

    @Override
    public JPanel createSettingsPanel() {
        if (this.expertOptionsEnabled) {
            return new SettingsPanel((JPanel)this.basicPanel, (JPanel)this.advancedPanel, (JPanel)this.expertPanel);
        }
        return new SettingsPanel((JPanel)this.basicPanel, (JPanel)this.advancedPanel);
    }
}

