/*
 * Decompiled with CFR 0.152.
 */
package de.eobs.setuptool.configv0;

import de.eobs.setuptool.gui.configurablepanel.PanelConfig;
import de.eobs.setuptool.gui.rowpanel.CheckBoxRow;
import de.eobs.setuptool.gui.rowpanel.ComboBoxRow;
import de.eobs.setuptool.gui.rowpanel.RowPanelFactory;
import de.eobs.setuptool.gui.rowpanel.Section;
import de.eobs.setuptool.gui.rowpanel.TextRow;
import de.eobs.setuptool.gui.tagconfigaccess.Vocabular;
import java.math.BigDecimal;

public class ConfigV0PanelFactory {
    static final Object[] rows = new Object[]{new Section("GPS"), Vocabular.gps_medium_res_interval, Vocabular.gps_interval, Vocabular.gps_ontime_begin, Vocabular.gps_ontime_end, new Section("Ping"), Vocabular.ping_ontime_begin, Vocabular.ping_ontime_end, new Section("ACC"), Vocabular.acc_interval, Vocabular.acc_bytecnt, Vocabular.acc_samplerate, Vocabular.acc_ontime_begin, Vocabular.acc_ontime_end, Vocabular.acc_use_xaxis, Vocabular.acc_use_yaxis, Vocabular.acc_use_zaxis};
    static final Object[] advanced_rows = new Object[]{new Section("GPS"), Vocabular.gps_daydivisor, Vocabular.gps_hourshift, Vocabular.gps_interval_retry_factor, Vocabular.lowspeed_gps_interval_factor, Vocabular.gps_speed_thr, Vocabular.gps_timeout, Vocabular.burst_length, Vocabular.burst_qperiod, new Section("ACC"), Vocabular.lowspeed_acc_interval_factor, Vocabular.use_inverse_low_speed_interval_factor, new Section("GSM"), Vocabular.sms_time, Vocabular.gprs_time, Vocabular.sms_gps_collect_interval1, Vocabular.sms_gps_collect_offset1, Vocabular.gsm_bigger_interval, new Section("Ping"), Vocabular.pinger_interval, Vocabular.freq_pinger, new Section("Misc"), Vocabular.device_start_time, Vocabular.secret_key, Vocabular.access_key};
    static final Object[] expert_rows = new Object[]{Vocabular.bat_threshold2, Vocabular.bat_threshold1, Vocabular.bat_gsm_threshold, Vocabular.bat_acc_threshold, Vocabular.bat_threshold0, Vocabular.bat_gprs_download_threshold, Vocabular.sms_timeout, Vocabular.gprs_timeout, Vocabular.maccess_voltlimit, Vocabular.radio_interval, Vocabular.radio_longdelay};

    public static PanelConfig create() {
        PanelConfig config = new PanelConfig();
        config.rows = rows;
        config.create(Vocabular.gps_medium_res_interval, new TextRow("Interval (Seconds)"), PanelConfig.defaultConvertSeconds, new PanelConfig.IntegerRange(1L, 65535L));
        config.create(Vocabular.gps_interval, new TextRow("High Res Interval @ Full Bat."), PanelConfig.defaultConvertSeconds, new PanelConfig.IntegerRange(1L, 65535L));
        config.create(Vocabular.gps_ontime_begin, new TextRow("On From (HH:MM)"));
        config.create(Vocabular.gps_ontime_end, new TextRow("On Until (HH:MM)"));
        config.create(Vocabular.ping_ontime_begin, new TextRow("On From (HH:MM)"));
        config.create(Vocabular.ping_ontime_end, new TextRow("On Until (HH:MM)"));
        config.create(Vocabular.acc_interval, new TextRow("Interval (Seconds)"), PanelConfig.defaultConvertSeconds, new PanelConfig.IntegerRange(1L, 65535L));
        config.create(Vocabular.acc_samplerate, new ComboBoxRow("Samplerate (Hz) for all axes together", RowPanelFactory.defaultSamplerates()), PanelConfig.defaultConvertSamplerate);
        config.create(Vocabular.acc_bytecnt, new ComboBoxRow("Byte Count", RowPanelFactory.defaultByteCounts()), PanelConfig.defaultConvertInteger);
        config.create(Vocabular.acc_ontime_begin, new TextRow("On From (HH:MM)"));
        config.create(Vocabular.acc_ontime_end, new TextRow("On Until (HH:MM)"));
        config.create(Vocabular.acc_use_xaxis, new CheckBoxRow("Axes", "X"));
        config.create(Vocabular.acc_use_yaxis, new CheckBoxRow("", "Y"));
        config.create(Vocabular.acc_use_zaxis, new CheckBoxRow("", "Z"));
        return config;
    }

    public static PanelConfig createAdvanced() {
        PanelConfig config = new PanelConfig();
        config.rows = advanced_rows;
        config.create(Vocabular.gps_daydivisor, new TextRow("Day Divisor"), PanelConfig.defaultConvertInteger, new PanelConfig.IntegerRange(1L, 255L));
        config.create(Vocabular.gps_hourshift, new TextRow("Hourshift"), PanelConfig.defaultConvertInteger, new PanelConfig.IntegerRange(0L, 255L));
        config.create(Vocabular.gps_interval_retry_factor, new TextRow("Retry Interval Factor"), PanelConfig.defaultConvertInteger, new PanelConfig.IntegerRange(1L, 255L));
        config.create(Vocabular.lowspeed_gps_interval_factor, new TextRow("Low Speed Interval Factor"), PanelConfig.defaultConvertInteger, new PanelConfig.IntegerRange(1L, 255L));
        config.create(Vocabular.gps_speed_thr, new TextRow("Low Speed Threshold (cm/s)"), PanelConfig.defaultConvertInteger, new PanelConfig.IntegerRange(0L, 65535L));
        config.create(Vocabular.gps_timeout, new TextRow("Timeout (Seconds)"), PanelConfig.defaultConvertSeconds, new PanelConfig.IntegerRange(30L, 65535L));
        int MAX_GPS_BURST_LENGTH = 900;
        config.create(Vocabular.burst_length, new TextRow("Burst Length (Seconds)"), PanelConfig.defaultConvertSeconds, new PanelConfig.IntegerRange(1L, 900L));
        config.create(Vocabular.burst_qperiod, new TextRow("Burst Qperiod (Seconds)"), PanelConfig.defaultConvertSeconds, new PanelConfig.IntegerRange(1L, 255L));
        config.create(Vocabular.lowspeed_acc_interval_factor, new TextRow("Low Speed Interval Factor"), PanelConfig.defaultConvertSeconds, new PanelConfig.IntegerRange(1L, 255L));
        config.create(Vocabular.use_inverse_low_speed_interval_factor, new CheckBoxRow("Inverse Low Speed Interval Factor", "enabled"));
        config.create(Vocabular.sms_time, new TextRow("SMS Time (HH:MM)"), PanelConfig.defaultConvertMinutes);
        config.create(Vocabular.gprs_time, new TextRow("GPRS Time (HH:MM)"), PanelConfig.defaultConvertMinutes);
        config.create(Vocabular.sms_gps_collect_interval1, new TextRow("GPS Collect Interval (Seconds)"), PanelConfig.defaultConvertSeconds, new PanelConfig.IntegerRange(0L, 65535L));
        config.create(Vocabular.sms_gps_collect_offset1, new TextRow("GPS Collect Offset (Seconds)"), PanelConfig.defaultConvertSeconds, new PanelConfig.IntegerRange(0L, 65535L));
        config.create(Vocabular.gsm_bigger_interval, new TextRow("Big Interval (Seconds)"), PanelConfig.defaultConvertSeconds, new PanelConfig.IntegerRange(0L, 0xFFFFFFFFL));
        config.create(Vocabular.pinger_interval, new TextRow("Interval (Seconds)"), PanelConfig.defaultConvertSeconds, new PanelConfig.IntegerRange(1L, 65535L));
        config.create(Vocabular.freq_pinger, new TextRow("Freq. (MHz)"), PanelConfig.defaultConvertMHz, new PanelConfig.NumericRange(new BigDecimal("860.000"), new BigDecimal("870.000")));
        config.create(Vocabular.device_start_time, new TextRow("Delayed Tag Start Day"), PanelConfig.defaultConvertDateTime);
        config.create(Vocabular.secret_key, new TextRow("Secret Key"), PanelConfig.defaultConvertInteger, new PanelConfig.IntegerRange(0L, 65535L));
        config.create(Vocabular.access_key, new TextRow("Access Key"), PanelConfig.defaultConvertInteger, new PanelConfig.IntegerRange(0L, 255L));
        return config;
    }

    public static PanelConfig createExpert() {
        PanelConfig config = new PanelConfig();
        config.rows = expert_rows;
        config.create(Vocabular.bat_threshold0, new TextRow("Battery Threshold 0 (mV)"), PanelConfig.defaultConvertMillivolt, new PanelConfig.IntegerRange(1000L, 6000L));
        config.create(Vocabular.bat_threshold1, new TextRow("Battery Threshold 1 (mV)"), PanelConfig.defaultConvertMillivolt, new PanelConfig.IntegerRange(1000L, 6000L));
        config.create(Vocabular.bat_threshold2, new TextRow("Battery Threshold 2 (mV)"), PanelConfig.defaultConvertMillivolt, new PanelConfig.IntegerRange(1000L, 6000L));
        config.create(Vocabular.bat_acc_threshold, new TextRow("Battery ACC Threshold (mV)"), PanelConfig.defaultConvertMillivolt, new PanelConfig.IntegerRange(1000L, 6000L));
        config.create(Vocabular.bat_gsm_threshold, new TextRow("Battery GSM Threshold (mV)"), PanelConfig.defaultConvertMillivolt, new PanelConfig.IntegerRange(1000L, 6000L));
        config.create(Vocabular.bat_gprs_download_threshold, new TextRow("Battery GPRS Download Threshold (mV)"), PanelConfig.defaultConvertMillivolt, new PanelConfig.IntegerRange(1000L, 6000L));
        config.create(Vocabular.sms_timeout, new TextRow("SMS Timeout (Seconds)"), PanelConfig.defaultConvertSeconds, new PanelConfig.IntegerRange(0L, 65535L));
        config.create(Vocabular.gprs_timeout, new TextRow("GPRS Timeout (Seconds)"), PanelConfig.defaultConvertSeconds, new PanelConfig.IntegerRange(0L, 65535L));
        config.create(Vocabular.maccess_voltlimit, new TextRow("Maccess Voltlimit (mV)"), PanelConfig.defaultConvertMillivolt, new PanelConfig.IntegerRange(1000L, 6000L));
        config.create(Vocabular.radio_interval, new TextRow("Radio Interval (Seconds)"), PanelConfig.defaultConvertSeconds, new PanelConfig.IntegerRange(0L, 65535L));
        config.create(Vocabular.radio_longdelay, new TextRow("Radio Longdelay (Seconds)"), PanelConfig.defaultConvertSeconds, new PanelConfig.IntegerRange(0L, 65535L));
        return config;
    }
}

