/*
 * Decompiled with CFR 0.152.
 */
package de.eobs.setuptool.configv1;

import de.eobs.setuptool.ConfigPanels;
import de.eobs.setuptool.SettingsPanel;
import de.eobs.setuptool.configv1.ConfigV1PanelFactory;
import de.eobs.setuptool.gui.configurablepanel.ConfigurablePanel;
import de.eobs.setuptool.gui.configurablepanel.PanelConfig;
import de.eobs.setuptool.gui.rowpanel.Row;
import de.eobs.setuptool.gui.table.TableRow;
import de.eobs.setuptool.gui.tagconfigaccess.BaseAttribute;
import de.eobs.setuptool.gui.tagconfigaccess.TagConfigAccess;
import de.eobs.setuptool.gui.tagconfigaccess.TagConfigV1Util;
import de.eobs.setuptool.rest.api.TagId;
import de.eobs.setuptool.tagconfig.TagConfigGeneric;
import de.eobs.setuptool.tagconfig.TagConfigV1;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigPanelsV1
implements ConfigPanels {
    private static final Logger logger = LoggerFactory.getLogger(ConfigPanelsV1.class);
    final ConfigurablePanel basicPanel;
    final ConfigurablePanel advancedPanel;
    final ConfigurablePanel expertPanel;
    final ConfigurablePanel eobsExpertPanel;
    private final boolean expertOptionsEnabled;
    private final boolean eobsExpertMode;

    public ConfigPanelsV1(boolean expertOptionsEnabled, boolean withFeatureNewBurstCondition, boolean withFeatureRoiHarelFactors, boolean withFeature_MMA8452_SMBUS, boolean withFeature_BAND_916MHZ, boolean eobsExpertOptionsEnabled, TagId tagId) {
        this.expertOptionsEnabled = expertOptionsEnabled;
        this.eobsExpertMode = eobsExpertOptionsEnabled;
        this.basicPanel = new ConfigurablePanel(ConfigV1PanelFactory.create(withFeature_MMA8452_SMBUS));
        this.advancedPanel = new ConfigurablePanel(ConfigV1PanelFactory.createAdvanced(withFeatureNewBurstCondition, withFeatureRoiHarelFactors, withFeature_BAND_916MHZ, tagId));
        this.expertPanel = expertOptionsEnabled ? new ConfigurablePanel(ConfigV1PanelFactory.createExpert(withFeatureNewBurstCondition)) : null;
        this.eobsExpertPanel = eobsExpertOptionsEnabled ? new ConfigurablePanel(ConfigV1PanelFactory.createEobsExpertMode()) : null;
    }

    @Override
    public TagConfigGeneric updateTagConfig(TagConfigGeneric config) {
        TagConfigAccess access = TagConfigV1Util.bind((TagConfigV1)config);
        this.basicPanel.updateConfig(access);
        this.advancedPanel.updateConfig(access);
        if (this.expertPanel != null) {
            this.expertPanel.updateConfig(access);
        }
        if (this.eobsExpertPanel != null) {
            this.eobsExpertPanel.updateConfig(access);
        }
        return config;
    }

    @Override
    public boolean isUserInputValid() {
        return this.basicPanel.isUserInputValid() && this.advancedPanel.isUserInputValid();
    }

    @Override
    public void updateModel(TagConfigGeneric config) {
        TagConfigAccess access = TagConfigV1Util.bind((TagConfigV1)config);
        this.basicPanel.fromConfig(access);
        this.advancedPanel.fromConfig(access);
        if (this.expertPanel != null) {
            this.expertPanel.fromConfig(access);
        }
        if (this.eobsExpertPanel != null) {
            this.eobsExpertPanel.fromConfig(access);
        }
    }

    @Override
    public List<TableRow> createTabelRows(TagConfigGeneric tagConfig) {
        ArrayList<TableRow> tableRows = new ArrayList<TableRow>();
        TagConfigAccess access = TagConfigV1Util.bind((TagConfigV1)tagConfig);
        tableRows.add(new TableRow("Basic Settings", ""));
        this.createTableRows(tableRows, access, this.basicPanel);
        tableRows.add(new TableRow("", ""));
        tableRows.add(new TableRow("Advanced Settings", ""));
        this.createTableRows(tableRows, access, this.advancedPanel);
        tableRows.add(new TableRow("", ""));
        if (this.expertPanel != null) {
            tableRows.add(new TableRow("Expert Settings", ""));
            this.createTableRows(tableRows, access, this.expertPanel);
        }
        if (this.eobsExpertPanel != null) {
            tableRows.add(new TableRow("E-obs Expert Settings", ""));
            this.createTableRows(tableRows, access, this.eobsExpertPanel);
        }
        return tableRows;
    }

    private void createTableRows(List<TableRow> tableRows, TagConfigAccess access, ConfigurablePanel configurablePanel) {
        HashMap<BaseAttribute, PanelConfig.UpdateGui> updateGuiList = configurablePanel.updateGuiList;
        Object[] rows = configurablePanel.rows;
        for (int i = 0; i < rows.length; ++i) {
            Row r;
            logger.info("row[" + i + "]: " + rows[i]);
            if (rows[i] instanceof BaseAttribute) {
                r = configurablePanel.rowMap.get(rows[i]);
                PanelConfig.UpdateGui u = updateGuiList.get(rows[i]);
                logger.info(" => str: " + u.convertToString(access));
                tableRows.add(new TableRow(r.convertToString(), u.convertToString(access)));
                continue;
            }
            if (!(rows[i] instanceof Row)) continue;
            r = (Row)rows[i];
            logger.info(" => str: " + r.convertToString());
            tableRows.add(new TableRow(r.convertToString(), ""));
        }
    }

    @Override
    public JPanel createSettingsPanel() {
        return new SettingsPanel((JPanel)this.basicPanel, (JPanel)this.advancedPanel, (JPanel)this.expertPanel, (JPanel)this.eobsExpertPanel);
    }
}

