/*
 * Decompiled with CFR 0.152.
 */
package de.eobs.setuptool.configv1;

import de.eobs.setuptool.gui.configurablepanel.PanelConfig;
import de.eobs.setuptool.gui.inputvalidation.pinger916MHz.TextFieldIntegerValidatorPinger916MHz;
import de.eobs.setuptool.gui.rowpanel.CheckBoxRow;
import de.eobs.setuptool.gui.rowpanel.ComboBoxRow;
import de.eobs.setuptool.gui.rowpanel.RowPanelFactory;
import de.eobs.setuptool.gui.rowpanel.Section;
import de.eobs.setuptool.gui.rowpanel.TextRow;
import de.eobs.setuptool.gui.tagconfigaccess.AttributeFlag;
import de.eobs.setuptool.gui.tagconfigaccess.AttributeU16;
import de.eobs.setuptool.gui.tagconfigaccess.Vocabular;
import de.eobs.setuptool.rest.api.TagId;
import java.math.BigDecimal;
import java.util.ArrayList;

public class ConfigV1PanelFactory {
    static final Object[] rows = new Object[]{new Section("GPS"), Vocabular.gps_medium_res_interval, Vocabular.gps_interval, Vocabular.gps_ontime_begin, Vocabular.gps_ontime_end, new Section("Ping"), Vocabular.ping_ontime_begin, Vocabular.ping_ontime_end, new Section("ACC"), Vocabular.acc_interval, Vocabular.acc_bytecnt, Vocabular.acc_samplerate, Vocabular.acc_ontime_begin, Vocabular.acc_ontime_end, Vocabular.acc_use_xaxis, Vocabular.acc_use_yaxis, Vocabular.acc_use_zaxis};

    public static PanelConfig create(boolean withFeature_MMA8452_SMBUS) {
        PanelConfig config = new PanelConfig();
        config.rows = rows;
        config.create(Vocabular.gps_medium_res_interval, new TextRow("Interval (Seconds)"), PanelConfig.defaultConvertSeconds, new PanelConfig.IntegerRange(1L, 65535L));
        config.create(Vocabular.gps_interval, new TextRow("High Res Interval @ Full Bat."), PanelConfig.defaultConvertSeconds, new PanelConfig.IntegerRange(1L, 65535L));
        config.create(Vocabular.gps_ontime_begin, new TextRow("On From (HH:MM)"));
        config.create(Vocabular.gps_ontime_end, new TextRow("On Until (HH:MM)"));
        config.create(Vocabular.ping_ontime_begin, new TextRow("On From (HH:MM)"));
        config.create(Vocabular.ping_ontime_end, new TextRow("On Until (HH:MM)"));
        config.create(Vocabular.acc_interval, new TextRow("Interval (Seconds)"), PanelConfig.defaultConvertSeconds, new PanelConfig.IntegerRange(1L, 65535L));
        if (withFeature_MMA8452_SMBUS) {
            config.create(Vocabular.acc_samplerate, new ComboBoxRow("Samplerate (Hz) for each enabled axis", RowPanelFactory.defaultSamplerates_MMA8452_SMBUS()), PanelConfig.defaultConvertSamplerate_MMA8452_SMBUS);
        } else {
            config.create(Vocabular.acc_samplerate, new ComboBoxRow("Samplerate (Hz) for all axes together", RowPanelFactory.defaultSamplerates()), PanelConfig.defaultConvertSamplerate);
        }
        config.create(Vocabular.acc_bytecnt, new ComboBoxRow("Byte Count", RowPanelFactory.defaultByteCounts()), PanelConfig.defaultConvertInteger);
        config.create(Vocabular.acc_ontime_begin, new TextRow("On From (HH:MM)"));
        config.create(Vocabular.acc_ontime_end, new TextRow("On Until (HH:MM)"));
        config.create(Vocabular.acc_use_xaxis, new CheckBoxRow("Axes", "X"));
        config.create(Vocabular.acc_use_yaxis, new CheckBoxRow("", "Y"));
        config.create(Vocabular.acc_use_zaxis, new CheckBoxRow("", "Z"));
        return config;
    }

    public static PanelConfig createAdvanced(boolean withFeatureNewBurstCondition, boolean withFeatureRoiHarelFactors, boolean withFeature_BAND_916MHZ, TagId tagId) {
        PanelConfig config = new PanelConfig();
        ArrayList<Object> rows = new ArrayList<Object>();
        rows.add(new Section("GPS"));
        rows.add(Vocabular.gps_daydivisor);
        rows.add(Vocabular.gps_hourshift);
        rows.add(Vocabular.gps_interval_retry_factor);
        rows.add(Vocabular.lowspeed_gps_interval_factor);
        rows.add(Vocabular.gps_speed_thr);
        rows.add(Vocabular.gps_timeout);
        rows.add(Vocabular.burst_length);
        rows.add(Vocabular.burst_qperiod);
        if (withFeatureRoiHarelFactors) {
            rows.add(Vocabular.use_roi_harel_factors);
        }
        rows.add(new Section("ACC"));
        rows.add(Vocabular.lowspeed_acc_interval_factor);
        rows.add(Vocabular.use_inverse_low_speed_interval_factor);
        rows.add(new Section("GSM"));
        rows.add(Vocabular.sms_time);
        rows.add(Vocabular.gprs_time);
        rows.add(Vocabular.sms_gps_collect_interval1);
        rows.add(Vocabular.sms_gps_collect_offset1);
        rows.add(Vocabular.gsm_bigger_interval);
        rows.add(new Section("Ping"));
        rows.add(Vocabular.pinger_interval);
        rows.add(Vocabular.freq_pinger);
        rows.add(new Section("Misc"));
        rows.add(Vocabular.device_start_time);
        rows.add(Vocabular.secret_key);
        rows.add(Vocabular.access_key);
        if (withFeatureNewBurstCondition) {
            rows.add(new Section("Super Burst"));
            rows.add(Vocabular.super_burst_length);
            rows.add(Vocabular.super_low_speed_gps_interval);
            rows.add(Vocabular.super_memory_limit);
        }
        config.rows = rows.toArray();
        config.create(Vocabular.gps_daydivisor, new TextRow("Day Divisor"), PanelConfig.defaultConvertInteger, new PanelConfig.IntegerRange(1L, 255L));
        config.create(Vocabular.gps_hourshift, new TextRow("Hourshift"), PanelConfig.defaultConvertInteger, new PanelConfig.IntegerRange(0L, 255L));
        config.create(Vocabular.gps_interval_retry_factor, new TextRow("Retry Interval Factor"), PanelConfig.defaultConvertInteger, new PanelConfig.IntegerRange(1L, 255L));
        config.create(Vocabular.lowspeed_gps_interval_factor, new TextRow("Low Speed Interval Factor"), PanelConfig.defaultConvertInteger, new PanelConfig.IntegerRange(1L, 255L));
        config.create(Vocabular.gps_speed_thr, new TextRow("Low Speed Threshold (cm/s)"), PanelConfig.defaultConvertInteger, new PanelConfig.IntegerRange(0L, 65535L));
        config.create(Vocabular.gps_timeout, new TextRow("Timeout (Seconds)"), PanelConfig.defaultConvertSeconds, new PanelConfig.IntegerRange(30L, 65535L));
        int MAX_GPS_BURST_LENGTH = 900;
        config.create(Vocabular.burst_length, new TextRow("Burst Length (Seconds)"), PanelConfig.defaultConvertSeconds, new PanelConfig.IntegerRange(1L, 900L));
        config.create(Vocabular.burst_qperiod, new TextRow("Burst Qperiod (Seconds)"), PanelConfig.defaultConvertSeconds, new PanelConfig.IntegerRange(1L, 255L));
        config.create(Vocabular.lowspeed_acc_interval_factor, new TextRow("Low Speed Interval Factor"), PanelConfig.defaultConvertSeconds, new PanelConfig.IntegerRange(1L, 255L));
        config.create(Vocabular.use_inverse_low_speed_interval_factor, new CheckBoxRow("Inverse Low Speed Interval Factor", "enabled"));
        config.create(Vocabular.sms_time, new TextRow("SMS Time (HH:MM)"), PanelConfig.defaultConvertMinutes);
        config.create(Vocabular.gprs_time, new TextRow("GPRS Time (HH:MM)"), PanelConfig.defaultConvertMinutes);
        config.create(Vocabular.sms_gps_collect_interval1, new TextRow("GPS Collect Interval (Seconds)"), PanelConfig.defaultConvertSeconds, new PanelConfig.IntegerRange(0L, 65535L));
        config.create(Vocabular.sms_gps_collect_offset1, new TextRow("GPS Collect Offset (Seconds)"), PanelConfig.defaultConvertSeconds, new PanelConfig.IntegerRange(0L, 65535L));
        config.create(Vocabular.gsm_bigger_interval, new TextRow("Big Interval (Seconds)"), PanelConfig.defaultConvertSeconds, new PanelConfig.IntegerRange(0L, 0xFFFFFFFFL));
        if (withFeature_BAND_916MHZ) {
            config.create(Vocabular.pinger_interval, new TextRow("Interval (Seconds)"), PanelConfig.defaultConvertSeconds, new PanelConfig.IntegerRange(1L, 65535L));
            config.createWithSanitizer(Vocabular.freq_pinger, new TextRow("Freq. (MHz)"), PanelConfig.defaultConvertMHz, new PanelConfig.NumericRange(new BigDecimal("912.0002"), new BigDecimal("920.9997")));
        } else if (tagId.getValue() > 5800) {
            final TextFieldIntegerValidatorPinger916MHz.ChangableRange range = new TextFieldIntegerValidatorPinger916MHz.ChangableRange(1, 65535);
            final TextFieldIntegerValidatorPinger916MHz validator = config.create(Vocabular.pinger_interval, new TextRow("Interval (Seconds)"), PanelConfig.defaultConvertSeconds, range);
            PanelConfig.TextFieldChangeListener listener = new PanelConfig.TextFieldChangeListener(){

                @Override
                public void changed(long value) {
                    System.out.println("changed: " + value);
                    if (0x202606L <= value && value <= 2108293L) {
                        System.out.println("range 1");
                        range.minValue = 2L;
                        validator.revalidate();
                    } else if (2110284L <= value && value <= 2110841L) {
                        System.out.println("range 2");
                        range.minValue = 1L;
                        validator.revalidate();
                    } else {
                        System.out.println("range 3");
                        range.minValue = 1L;
                        validator.revalidate();
                    }
                }
            };
            config.createPinger916MHz(Vocabular.freq_pinger, new TextRow("Freq. (MHz)"), PanelConfig.defaultConvertMHz, new PanelConfig.NumericRange(new BigDecimal("868.0103"), new BigDecimal("868.5900")), new PanelConfig.NumericRange(new BigDecimal("869.4102"), new BigDecimal("869.6397")), listener);
        } else {
            config.create(Vocabular.pinger_interval, new TextRow("Interval (Seconds)"), PanelConfig.defaultConvertSeconds, new PanelConfig.IntegerRange(1L, 65535L));
            config.createWithSanitizer(Vocabular.freq_pinger, new TextRow("Freq. (MHz)"), PanelConfig.defaultConvertMHz, new PanelConfig.NumericRange(new BigDecimal("860.0000"), new BigDecimal("870.0002")));
        }
        config.create(Vocabular.device_start_time, new TextRow("Delayed Tag Start Day"), PanelConfig.defaultConvertDateTime);
        config.create(Vocabular.secret_key, new TextRow("Secret Key"), PanelConfig.defaultConvertInteger, new PanelConfig.IntegerRange(0L, 65535L));
        config.create(Vocabular.access_key, new TextRow("Access Key"), PanelConfig.defaultConvertInteger, new PanelConfig.IntegerRange(0L, 255L));
        config.create(Vocabular.super_burst_length, new TextRow("Super Burst Length (Seconds)"), PanelConfig.defaultConvertSeconds, new PanelConfig.IntegerRange(10L, 65535L));
        config.create(Vocabular.super_low_speed_gps_interval, new TextRow("Super Low Speed GPS Interval (Seconds)"), PanelConfig.defaultConvertSeconds, new PanelConfig.IntegerRange(60L, 65535L));
        config.create(Vocabular.super_memory_limit, new TextRow("Super Memory Limit (in 64 KiloByte)"), PanelConfig.defaultConvertInteger, new PanelConfig.IntegerRange(0L, 65535L));
        config.create(Vocabular.use_roi_harel_factors, new CheckBoxRow("Gps Interval Factors at High Resolution Instead of Normal", "enabled"));
        return config;
    }

    public static PanelConfig createExpert(boolean withFeatureNewBurstCondition) {
        PanelConfig config = new PanelConfig();
        ArrayList<AttributeU16> rows = new ArrayList<AttributeU16>();
        if (withFeatureNewBurstCondition) {
            rows.add(Vocabular.bat_threshold3);
        }
        rows.add(Vocabular.bat_threshold2);
        rows.add(Vocabular.bat_threshold1);
        rows.add(Vocabular.bat_gsm_threshold);
        rows.add(Vocabular.bat_acc_threshold);
        rows.add(Vocabular.bat_threshold0);
        rows.add(Vocabular.bat_gprs_download_threshold);
        rows.add(Vocabular.sms_timeout);
        rows.add(Vocabular.gprs_timeout);
        rows.add(Vocabular.maccess_voltlimit);
        rows.add(Vocabular.radio_interval);
        rows.add(Vocabular.radio_longdelay);
        config.rows = rows.toArray();
        config.create(Vocabular.bat_threshold0, new TextRow("Battery Threshold 0 (mV)"), PanelConfig.defaultConvertMillivolt, new PanelConfig.IntegerRange(1000L, 6000L));
        config.create(Vocabular.bat_threshold1, new TextRow("Battery Threshold 1 (mV)"), PanelConfig.defaultConvertMillivolt, new PanelConfig.IntegerRange(1000L, 6000L));
        config.create(Vocabular.bat_threshold2, new TextRow("Battery Threshold 2 (mV)"), PanelConfig.defaultConvertMillivolt, new PanelConfig.IntegerRange(1000L, 6000L));
        config.create(Vocabular.bat_threshold3, new TextRow("Battery Threshold 3 (mV)"), PanelConfig.defaultConvertMillivolt, new PanelConfig.IntegerRange(3000L, 6000L));
        config.create(Vocabular.bat_acc_threshold, new TextRow("Battery ACC Threshold (mV)"), PanelConfig.defaultConvertMillivolt, new PanelConfig.IntegerRange(1000L, 6000L));
        config.create(Vocabular.bat_gsm_threshold, new TextRow("Battery GSM Threshold (mV)"), PanelConfig.defaultConvertMillivolt, new PanelConfig.IntegerRange(1000L, 6000L));
        config.create(Vocabular.bat_gprs_download_threshold, new TextRow("Battery GPRS Download Threshold (mV)"), PanelConfig.defaultConvertMillivolt, new PanelConfig.IntegerRange(1000L, 6000L));
        config.create(Vocabular.sms_timeout, new TextRow("SMS Timeout (Seconds)"), PanelConfig.defaultConvertSeconds, new PanelConfig.IntegerRange(0L, 65535L));
        config.create(Vocabular.gprs_timeout, new TextRow("GPRS Timeout (Seconds)"), PanelConfig.defaultConvertSeconds, new PanelConfig.IntegerRange(0L, 65535L));
        config.create(Vocabular.maccess_voltlimit, new TextRow("Maccess Voltlimit (mV)"), PanelConfig.defaultConvertMillivolt, new PanelConfig.IntegerRange(1000L, 6000L));
        config.create(Vocabular.radio_interval, new TextRow("Radio Interval (Seconds)"), PanelConfig.defaultConvertSeconds, new PanelConfig.IntegerRange(0L, 65535L));
        config.create(Vocabular.radio_longdelay, new TextRow("Radio Longdelay (Seconds)"), PanelConfig.defaultConvertSeconds, new PanelConfig.IntegerRange(0L, 65535L));
        return config;
    }

    public static PanelConfig createEobsExpertMode() {
        PanelConfig config = new PanelConfig();
        ArrayList<AttributeFlag> rows = new ArrayList<AttributeFlag>();
        rows.add(Vocabular.datalink_2017);
        config.rows = rows.toArray();
        config.create(Vocabular.datalink_2017, new CheckBoxRow("Datalink 2017", "enabled"));
        return config;
    }
}

