/*
 * Decompiled with CFR 0.152.
 */
package de.eobs.setuptool.configv2;

import de.eobs.setuptool.ConfigPanels;
import de.eobs.setuptool.SettingsPanel;
import de.eobs.setuptool.configv2.ConfigV2PanelFactory;
import de.eobs.setuptool.gui.configurablepanel.ConfigurablePanel;
import de.eobs.setuptool.gui.configurablepanel.PanelConfig;
import de.eobs.setuptool.gui.rowpanel.Row;
import de.eobs.setuptool.gui.table.TableRow;
import de.eobs.setuptool.gui.tagconfigaccess.BaseAttribute;
import de.eobs.setuptool.gui.tagconfigaccess.TagConfigAccess;
import de.eobs.setuptool.gui.tagconfigaccess.TagConfigV2Util;
import de.eobs.setuptool.rest.api.TagId;
import de.eobs.setuptool.tagconfig.HeaderFields;
import de.eobs.setuptool.tagconfig.TagConfigGeneric;
import de.eobs.setuptool.tagconfig.TagConfigV2;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigPanelsV2
implements ConfigPanels {
    private static final Logger logger = LoggerFactory.getLogger(ConfigPanelsV2.class);
    private final boolean expertOptionsEnabled;
    private final boolean eobsExpertMode;
    List<ConfigurablePanel> panels = new ArrayList<ConfigurablePanel>();

    public ConfigPanelsV2(TagConfigV2 config, TagId tagId, boolean expertOptionsEnabled, boolean eobsExpertOptionsEnabled) {
        this.expertOptionsEnabled = expertOptionsEnabled;
        this.eobsExpertMode = eobsExpertOptionsEnabled;
        boolean withFeature_BAND_916MHZ = config.hasSwFeaturesEnabled(new HeaderFields.Feature[]{HeaderFields.Feature.WITH_BAND_916MHZ});
        boolean withFeature_BAND_920MHZ = config.hasSwFeaturesEnabled(new HeaderFields.Feature[]{HeaderFields.Feature.WITH_BAND_920MHZ});
        boolean supportGprsTime3 = config.supportsGprsTime3(tagId);
        boolean withFeature_ON2TIMES = config.hasSwFeaturesEnabled(new HeaderFields.Feature[]{HeaderFields.Feature.WITH_ON2TIMES});
        this.panels.add(new ConfigurablePanel(ConfigV2PanelFactory.createAccAndIMUSettings(withFeature_ON2TIMES), "ACC & IMU Settings"));
        this.panels.add(new ConfigurablePanel(ConfigV2PanelFactory.createGPSSettings(withFeature_ON2TIMES), "GPS Settings"));
        this.panels.add(new ConfigurablePanel(ConfigV2PanelFactory.createTriggerSettingsForSelectiveRecording(), "Trigger Settings for Selective Recording"));
        this.panels.add(new ConfigurablePanel(ConfigV2PanelFactory.createCommunicationSettings(withFeature_BAND_916MHZ, withFeature_BAND_920MHZ, supportGprsTime3), "Communication Settings"));
        if (expertOptionsEnabled) {
            this.panels.add(new ConfigurablePanel(ConfigV2PanelFactory.createExpertSettings(), "Expert Settings"));
        }
        if (eobsExpertOptionsEnabled) {
            this.panels.add(new ConfigurablePanel(ConfigV2PanelFactory.createEobsExpertMode(withFeature_BAND_916MHZ, withFeature_BAND_920MHZ), "e-obs Expert Settings"));
        }
    }

    @Override
    public TagConfigGeneric updateTagConfig(TagConfigGeneric config) {
        TagConfigAccess access = TagConfigV2Util.bind((TagConfigV2)config);
        for (ConfigurablePanel panel : this.panels) {
            panel.updateConfig(access);
        }
        return config;
    }

    @Override
    public boolean isUserInputValid() {
        boolean valid = true;
        for (ConfigurablePanel panel : this.panels) {
            valid = valid && panel.isUserInputValid();
        }
        return valid;
    }

    @Override
    public void updateModel(TagConfigGeneric config) {
        TagConfigAccess access = TagConfigV2Util.bind((TagConfigV2)config);
        for (ConfigurablePanel panel : this.panels) {
            panel.fromConfig(access);
        }
    }

    @Override
    public List<TableRow> createTabelRows(TagConfigGeneric tagConfig) {
        ArrayList<TableRow> tableRows = new ArrayList<TableRow>();
        TagConfigAccess access = TagConfigV2Util.bind((TagConfigV2)tagConfig);
        for (ConfigurablePanel panel : this.panels) {
            tableRows.add(new TableRow(panel.getTitle(), ""));
            this.createTableRows(tableRows, access, panel);
            tableRows.add(new TableRow("", ""));
        }
        return tableRows;
    }

    private void createTableRows(List<TableRow> tableRows, TagConfigAccess access, ConfigurablePanel configurablePanel) {
        HashMap<BaseAttribute, PanelConfig.UpdateGui> updateGuiList = configurablePanel.updateGuiList;
        Object[] rows = configurablePanel.rows;
        for (int i = 0; i < rows.length; ++i) {
            Row r;
            logger.info("row[" + i + "]: " + rows[i]);
            if (rows[i] instanceof BaseAttribute) {
                r = configurablePanel.rowMap.get(rows[i]);
                PanelConfig.UpdateGui u = updateGuiList.get(rows[i]);
                logger.info(" => str: " + u.convertToString(access));
                tableRows.add(new TableRow(r.convertToString(), u.convertToString(access)));
                continue;
            }
            if (!(rows[i] instanceof Row)) continue;
            r = (Row)rows[i];
            logger.info(" => str: " + r.convertToString());
            tableRows.add(new TableRow(r.convertToString(), ""));
        }
    }

    @Override
    public JPanel createSettingsPanel() {
        return new SettingsPanel(this.panels.toArray(new ConfigurablePanel[0]));
    }
}

