/*
 * Decompiled with CFR 0.152.
 */
package de.eobs.setuptool.configv2;

import de.eobs.setuptool.gui.configurablepanel.PanelConfig;
import de.eobs.setuptool.gui.inputvalidation.pinger916MHz.TextFieldIntegerValidatorPinger916MHz;
import de.eobs.setuptool.gui.rowpanel.CheckBoxRow;
import de.eobs.setuptool.gui.rowpanel.ComboBoxRow;
import de.eobs.setuptool.gui.rowpanel.InfoRow;
import de.eobs.setuptool.gui.rowpanel.RowPanelFactory;
import de.eobs.setuptool.gui.rowpanel.Section;
import de.eobs.setuptool.gui.rowpanel.TextRow;
import de.eobs.setuptool.gui.tagconfigaccess.BaseAttribute;
import de.eobs.setuptool.gui.tagconfigaccess.VocabularV2;
import java.math.BigDecimal;
import java.util.ArrayList;

public class ConfigV2PanelFactory {
    private static void setupFrequency(PanelConfig config, boolean withFeature_BAND_916MHZ, boolean withFeature_BAND_920MHZ) {
        if (!withFeature_BAND_916MHZ && !withFeature_BAND_920MHZ) {
            final TextFieldIntegerValidatorPinger916MHz.ChangableRange range = new TextFieldIntegerValidatorPinger916MHz.ChangableRange(1, 65535);
            final TextFieldIntegerValidatorPinger916MHz validator = config.create(VocabularV2.pinger_interval, new TextRow("Interval (s)"), PanelConfig.defaultConvertSeconds, range);
            PanelConfig.TextFieldChangeListener listener = new PanelConfig.TextFieldChangeListener(){

                @Override
                public void changed(long value) {
                    System.out.println("changed: " + value);
                    if (0x202606L <= value && value <= 2108293L) {
                        System.out.println("range 1");
                        range.minValue = 2L;
                        range.maxValue = 2L;
                        validator.revalidate();
                    } else if (2110284L <= value && value <= 2110841L) {
                        System.out.println("range 2");
                        range.minValue = 1L;
                        range.maxValue = 2L;
                        validator.revalidate();
                    } else {
                        System.out.println("range 3");
                        range.minValue = 1L;
                        range.maxValue = 65535L;
                        validator.revalidate();
                    }
                }
            };
            config.createPinger916MHz(VocabularV2.ping_frequency, new TextRow("Freq. (MHz)"), PanelConfig.defaultConvertMHz, new PanelConfig.NumericRange(new BigDecimal("868.0103"), new BigDecimal("868.5900")), new PanelConfig.NumericRange(new BigDecimal("869.4102"), new BigDecimal("869.6397")), listener);
        } else if (withFeature_BAND_916MHZ) {
            config.create(VocabularV2.pinger_interval, new TextRow("Interval (s)"), PanelConfig.defaultConvertSeconds, new PanelConfig.IntegerRange(1L, 65535L));
            config.createWithSanitizer(VocabularV2.ping_frequency, new TextRow("Freq. (MHz)"), PanelConfig.defaultConvertMHz, new PanelConfig.NumericRange(new BigDecimal("912.0002"), new BigDecimal("920.9997")));
        } else if (withFeature_BAND_920MHZ) {
            config.create(VocabularV2.pinger_interval, new TextRow("Interval (s)"), PanelConfig.defaultConvertSeconds, new PanelConfig.IntegerRange(1L, 65535L));
            config.createWithSanitizer(VocabularV2.ping_frequency, new TextRow("Freq. (MHz)"), PanelConfig.defaultConvertMHz, new PanelConfig.NumericRange(new BigDecimal("920.6005"), new BigDecimal("920.9997")));
        }
    }

    public static PanelConfig createAccAndIMUSettings(boolean withFeature_ON2TIMES) {
        ArrayList<Object> rows = new ArrayList<Object>();
        rows.add(new Section("ACC & IMU"));
        rows.add(VocabularV2.acc_ontime_begin);
        rows.add(VocabularV2.acc_ontime_end);
        if (withFeature_ON2TIMES) {
            rows.add(VocabularV2.acc_on2time_begin);
            rows.add(VocabularV2.acc_on2time_end);
        }
        rows.add(VocabularV2.imu_ontime_begin);
        rows.add(VocabularV2.imu_ontime_end);
        if (withFeature_ON2TIMES) {
            rows.add(VocabularV2.imu_on2time_begin);
            rows.add(VocabularV2.imu_on2time_end);
        }
        rows.add(new Section("ACC & IMU Recording with different battery levels"));
        rows.add(VocabularV2.acc_low_bat_interval);
        rows.add(VocabularV2.imu_lowbat_interval);
        rows.add(VocabularV2.acc_interval);
        rows.add(VocabularV2.imu_interval);
        rows.add(VocabularV2.sm_acc_interval);
        rows.add(VocabularV2.sm_imu_interval);
        rows.add(VocabularV2.acc_samplerate);
        rows.add(new Section("General ACC & IMU Settings"));
        rows.add(VocabularV2.acc_byte_count);
        rows.add(VocabularV2.acc_use_xaxis);
        rows.add(VocabularV2.acc_use_yaxis);
        rows.add(VocabularV2.acc_use_zaxis);
        rows.add(VocabularV2.lowspeed_acc_interval_factor);
        rows.add(VocabularV2.use_inverse_low_speed_interval_factor);
        rows.add(VocabularV2.imu_start_delay);
        rows.add(VocabularV2.imu_acc_datasetcount);
        rows.add(VocabularV2.imu_quatcomp_datasetcount);
        PanelConfig config = new PanelConfig();
        config.rows = rows.toArray();
        config.create(VocabularV2.acc_ontime_begin, new TextRow("ACC On From (HH:MM)"));
        config.create(VocabularV2.acc_ontime_end, new TextRow("ACC On Until (HH:MM)"));
        if (withFeature_ON2TIMES) {
            config.create(VocabularV2.acc_on2time_begin, new TextRow("ACC On 2 From (HH:MM)"));
            config.create(VocabularV2.acc_on2time_end, new TextRow("ACC On 2 Until (HH:MM)"));
        }
        config.create(VocabularV2.imu_ontime_begin, new TextRow("IMU On From (HH:MM)"));
        config.create(VocabularV2.imu_ontime_end, new TextRow("IMU On Until (HH:MM)"));
        if (withFeature_ON2TIMES) {
            config.create(VocabularV2.imu_on2time_begin, new TextRow("IMU On 2 From (HH:MM)"));
            config.create(VocabularV2.imu_on2time_end, new TextRow("IMU On 2 Until (HH:MM)"));
        }
        config.create(VocabularV2.acc_low_bat_interval, new TextRow("ACC LOW BAT INTERVAL (s)"), PanelConfig.defaultConvertSeconds, new PanelConfig.IntegerRange(0L, 65535L));
        config.create(VocabularV2.imu_lowbat_interval, new TextRow("IMU LOW BAT INTERVAL (s)"), PanelConfig.defaultConvertSeconds, new PanelConfig.IntegerRange(0L, 65535L));
        config.create(VocabularV2.acc_interval, new TextRow("ACC Interval (s)"), PanelConfig.defaultConvertSeconds, new PanelConfig.IntegerRange(0L, 65535L));
        config.create(VocabularV2.imu_interval, new TextRow("IMU Interval (s)"), PanelConfig.defaultConvertSeconds, new PanelConfig.IntegerRange(0L, 65535L));
        config.create(VocabularV2.sm_acc_interval, new TextRow("SUPERMODE ACC Interval (s)"), PanelConfig.defaultConvertSeconds, new PanelConfig.IntegerRange(0L, 65535L));
        config.create(VocabularV2.sm_imu_interval, new TextRow("SUPERMODE IMU Interval (s)"), PanelConfig.defaultConvertSeconds, new PanelConfig.IntegerRange(0L, 65535L));
        config.create(VocabularV2.acc_samplerate, new ComboBoxRow("ACC Samplerate (Hz) for each enabled axis", RowPanelFactory.defaultSamplerates_MMA8452_SMBUS()), PanelConfig.defaultConvertSamplerate_MMA8452_SMBUS);
        config.create(VocabularV2.acc_byte_count, new ComboBoxRow("ACC Byte Count", RowPanelFactory.defaultByteCounts()), PanelConfig.defaultConvertInteger);
        config.create(VocabularV2.acc_use_xaxis, new CheckBoxRow("ACC Axes", "X"));
        config.create(VocabularV2.acc_use_yaxis, new CheckBoxRow("", "Y"));
        config.create(VocabularV2.acc_use_zaxis, new CheckBoxRow("", "Z"));
        config.create(VocabularV2.lowspeed_acc_interval_factor, new TextRow("ACC Low Speed Interval Factor"), PanelConfig.defaultConvertSeconds, new PanelConfig.IntegerRange(1L, 255L));
        config.create(VocabularV2.use_inverse_low_speed_interval_factor, new CheckBoxRow("ACC Inverse Low Speed Interval Factor", "enabled"));
        config.create(VocabularV2.imu_start_delay, new TextRow("IMU START DELAY"), PanelConfig.defaultConvertInteger, new PanelConfig.IntegerRange(0L, 255L));
        config.create(VocabularV2.imu_acc_datasetcount, new TextRow("IMU ACC DATASET COUNT"), PanelConfig.defaultConvertInteger, new PanelConfig.IntegerRange(0L, 255L));
        config.create(VocabularV2.imu_quatcomp_datasetcount, new TextRow("IMU QUATERNION & COMPASS DATASET COUNT"), PanelConfig.defaultConvertInteger, new PanelConfig.IntegerRange(0L, 255L));
        return config;
    }

    public static PanelConfig createGPSSettings(boolean withFeature_ON2TIMES) {
        ArrayList<Object> rows = new ArrayList<Object>();
        rows.add(new Section("GPS"));
        rows.add(VocabularV2.gps_ontime_begin);
        rows.add(VocabularV2.gps_ontime_end);
        if (withFeature_ON2TIMES) {
            rows.add(VocabularV2.gps_on2time_begin);
            rows.add(VocabularV2.gps_on2time_end);
        }
        rows.add(new Section("Low Battery GPS"));
        rows.add(VocabularV2.gps_low_bat_interval);
        rows.add(VocabularV2.lowbat_burst_length);
        rows.add(VocabularV2.lowbat_burst_qperiod);
        rows.add(VocabularV2.imu_flags_2_64);
        rows.add(VocabularV2.imu_flags_2_128);
        rows.add(VocabularV2.imu_flags_3_1);
        rows.add(new Section("Nearly full Battery GPS"));
        rows.add(VocabularV2.gps_low_res_interval);
        rows.add(VocabularV2.gps_high_res_interval);
        rows.add(VocabularV2.burst_length);
        rows.add(VocabularV2.burst_qperiod);
        rows.add(VocabularV2.imu_flags_2_1);
        rows.add(VocabularV2.imu_flags_2_2);
        rows.add(VocabularV2.imu_flags_2_4);
        rows.add(new Section("Full Battery GPS / SUPERMODE"));
        rows.add(VocabularV2.sm_low_res_gps_interval);
        rows.add(VocabularV2.sm_burst_length);
        rows.add(VocabularV2.sm_burst_qperiod);
        rows.add(VocabularV2.imu_flags_2_8);
        rows.add(VocabularV2.imu_flags_2_16);
        rows.add(VocabularV2.imu_flags_2_32);
        rows.add(VocabularV2.sm_gps_mem_limit);
        rows.add(new Section("General GPS Settings"));
        rows.add(VocabularV2.gps_timeout);
        rows.add(VocabularV2.gps_interval_retry_factor);
        rows.add(VocabularV2.speed_threshold1);
        rows.add(VocabularV2.speed_threshold2);
        rows.add(VocabularV2.speed_threshold3);
        PanelConfig config = new PanelConfig();
        config.rows = rows.toArray();
        config.create(VocabularV2.gps_ontime_begin, new TextRow("GPS On From (HH:MM)"));
        config.create(VocabularV2.gps_ontime_end, new TextRow("GPS On Until (HH:MM)"));
        if (withFeature_ON2TIMES) {
            config.create(VocabularV2.gps_on2time_begin, new TextRow("GPS On 2 From (HH:MM)"));
            config.create(VocabularV2.gps_on2time_end, new TextRow("GPS On 2 Until (HH:MM)"));
        }
        config.create(VocabularV2.gps_low_bat_interval, new TextRow("GPS LOW BAT INTERVAL (s)"), PanelConfig.defaultConvertInteger, new PanelConfig.IntegerRange(0L, 65535L));
        int MAX_GPS_BURST_LENGTH = 900;
        config.create(VocabularV2.lowbat_burst_length, new TextRow("GPS Low Bat Burst Length (s)"), PanelConfig.defaultConvertSeconds, new PanelConfig.IntegerRange(1L, 900L));
        config.create(VocabularV2.lowbat_burst_qperiod, new TextRow("GPS Low Bat Burst Qperiod (s)"), PanelConfig.defaultConvertSeconds, new PanelConfig.IntegerRange(1L, 255L));
        config.create(VocabularV2.imu_flags_2_64, new CheckBoxRow("IMU Settings", "1Hz Quat & Compass"));
        config.create(VocabularV2.imu_flags_2_128, new CheckBoxRow("", "20Hz & 1Hz Quat & Compass"));
        config.create(VocabularV2.imu_flags_3_1, new CheckBoxRow("", "20Hz ACC & 1Hz Quat & Compass"));
        config.create(VocabularV2.gps_low_res_interval, new TextRow("GPS LOW RES INTERVAL (s)"), PanelConfig.defaultConvertSeconds, new PanelConfig.IntegerRange(0L, 65535L));
        config.create(VocabularV2.gps_high_res_interval, new TextRow("GPS HIGH RES INTERVAL (s)"), PanelConfig.defaultConvertSeconds, new PanelConfig.IntegerRange(0L, 65535L));
        config.create(VocabularV2.burst_length, new TextRow("GPS Burst Length (s)"), PanelConfig.defaultConvertSeconds, new PanelConfig.IntegerRange(1L, 900L));
        config.create(VocabularV2.burst_qperiod, new TextRow("GPS Burst Qperiod (s)"), PanelConfig.defaultConvertSeconds, new PanelConfig.IntegerRange(1L, 255L));
        config.create(VocabularV2.imu_flags_2_1, new CheckBoxRow("IMU Settings", "1Hz Quat & Compass"));
        config.create(VocabularV2.imu_flags_2_2, new CheckBoxRow("", "20Hz & 1Hz Quat & Compass"));
        config.create(VocabularV2.imu_flags_2_4, new CheckBoxRow("", "20Hz ACC & 1Hz Quat & Compass"));
        config.create(VocabularV2.sm_low_res_gps_interval, new TextRow("SUPERMODE GPS Low Res Interval (s)"), PanelConfig.defaultConvertSeconds, new PanelConfig.IntegerRange(0L, 65535L));
        config.create(VocabularV2.sm_burst_length, new TextRow("SUPERMODE GPS Burst Length (s)"), PanelConfig.defaultConvertSeconds, new PanelConfig.IntegerRange(1L, 65535L));
        config.create(VocabularV2.sm_burst_qperiod, new TextRow("SUPERMODE GPS Burst Qperiod (s)"), PanelConfig.defaultConvertSeconds, new PanelConfig.IntegerRange(1L, 255L));
        config.create(VocabularV2.imu_flags_2_8, new CheckBoxRow("IMU Settings", "1Hz Quat & Compass"));
        config.create(VocabularV2.imu_flags_2_16, new CheckBoxRow("", "20Hz & 1Hz Quat & Compass"));
        config.create(VocabularV2.imu_flags_2_32, new CheckBoxRow("", "20Hz ACC & 1Hz Quat & Compass"));
        config.create(VocabularV2.sm_gps_mem_limit, new TextRow("SUPERMODE GPS Memory Limit (64kb)"), PanelConfig.defaultConvertInteger, new PanelConfig.IntegerRange(1L, 65535L));
        config.create(VocabularV2.gps_timeout, new TextRow("GPS Timeout (s)"), PanelConfig.defaultConvertSeconds, new PanelConfig.IntegerRange(30L, 65535L));
        config.create(VocabularV2.gps_interval_retry_factor, new TextRow("GPS Retry Interval Factor"), PanelConfig.defaultConvertInteger, new PanelConfig.IntegerRange(1L, 255L));
        config.create(VocabularV2.speed_threshold1, new TextRow("SPEED THRESHOLD1 (cm/s)"), PanelConfig.defaultConvertInteger, new PanelConfig.IntegerRange(0L, 65535L));
        config.create(VocabularV2.speed_threshold2, new TextRow("SPEED THRESHOLD2 (cm/s)"), PanelConfig.defaultConvertInteger, new PanelConfig.IntegerRange(0L, 65535L));
        config.create(VocabularV2.speed_threshold3, new TextRow("SPEED THRESHOLD3 (cm/s)"), PanelConfig.defaultConvertInteger, new PanelConfig.IntegerRange(0L, 65535L));
        return config;
    }

    public static PanelConfig createTriggerSettingsForSelectiveRecording() {
        Object[] rows2 = new Object[]{new Section("Trigger Settings for Selective Recording"), VocabularV2.variance_interval, VocabularV2.sm_variance_interval, VocabularV2.acc_var_samplerate, VocabularV2.acc_var_bytecnt, VocabularV2.acc_var_threshold, VocabularV2.acc_param_n2, VocabularV2.acc_param_n1, VocabularV2.sm_acc_param_n2, VocabularV2.sm_acc_param_n1, VocabularV2.speed_param_n1, VocabularV2.variance_axis, VocabularV2.tilt_second_axis, VocabularV2.burst_low_speed_fix_count, VocabularV2.sm_burst_low_speed_fix_count, VocabularV2.acc_yf, VocabularV2.acc_zf, VocabularV2.ignore_angle_in_supermode_with_high_gps_res, VocabularV2.ignore_variance_in_supermode_with_high_gps_res};
        PanelConfig config = new PanelConfig();
        config.rows = rows2;
        config.create(VocabularV2.variance_interval, new TextRow("VARIANCE INTERVAL (s)"), PanelConfig.defaultConvertSeconds, new PanelConfig.IntegerRange(0L, 65535L));
        config.create(VocabularV2.sm_variance_interval, new TextRow("SUPERMODE VARIANCE Interval (s)"), PanelConfig.defaultConvertSeconds, new PanelConfig.IntegerRange(0L, 65535L));
        config.create(VocabularV2.acc_var_samplerate, new ComboBoxRow("ACC VARIANCE Samplerate (Hz) for each enabled axis", RowPanelFactory.defaultSamplerates_MMA8452_SMBUS()), PanelConfig.defaultConvertSamplerate_MMA8452_SMBUS);
        config.create(VocabularV2.acc_var_bytecnt, new TextRow("ACC VARIANCE BYTE COUNT"), PanelConfig.defaultConvertInteger, new PanelConfig.IntegerRange(0L, 65535L));
        config.create(VocabularV2.acc_var_threshold, new TextRow("ACC VARIANCE THRESHOLD"), PanelConfig.defaultConvertInteger, new PanelConfig.IntegerRange(0L, 0xFFFFFFFFL));
        config.create(VocabularV2.acc_param_n2, new TextRow("ACC N2 ENTRY THRESHOLD"), PanelConfig.defaultConvertInteger, new PanelConfig.IntegerRange(0L, 255L));
        config.create(VocabularV2.acc_param_n1, new TextRow("ACC N1 EXIT THRESHOLD"), PanelConfig.defaultConvertInteger, new PanelConfig.IntegerRange(0L, 255L));
        config.create(VocabularV2.sm_acc_param_n2, new TextRow("SUPERMODE ACC N2 ENTRY THRESHOLD"), PanelConfig.defaultConvertInteger, new PanelConfig.IntegerRange(0L, 255L));
        config.create(VocabularV2.sm_acc_param_n1, new TextRow("SUPERMODE ACC N1 EXIT THRESHOLD"), PanelConfig.defaultConvertInteger, new PanelConfig.IntegerRange(0L, 255L));
        config.create(VocabularV2.speed_param_n1, new TextRow("SPEED N1 EXIT THRESHOLD"), PanelConfig.defaultConvertInteger, new PanelConfig.IntegerRange(0L, 255L));
        config.create(VocabularV2.variance_axis, new ComboBoxRow("VARIANCE AXIS", RowPanelFactory.defaultAxes()));
        config.create(VocabularV2.tilt_second_axis, new ComboBoxRow("TILT AXIS2", RowPanelFactory.defaultAxes()));
        config.create(VocabularV2.burst_low_speed_fix_count, new TextRow("GPS Burst Low Speed Fix Count"), PanelConfig.defaultConvertInteger, new PanelConfig.IntegerRange(0L, 255L));
        config.create(VocabularV2.sm_burst_low_speed_fix_count, new TextRow("SUPERMODE GPS Burst Low Speed Fix Count (s)"), PanelConfig.defaultConvertSeconds, new PanelConfig.IntegerRange(0L, 255L));
        config.create(VocabularV2.acc_yf, new TextRow("ACCYF"), PanelConfig.defaultConvertInteger, new PanelConfig.IntegerRange(-10L, 10L));
        config.create(VocabularV2.acc_zf, new TextRow("ACCZF"), PanelConfig.defaultConvertInteger, new PanelConfig.IntegerRange(-10L, 10L));
        config.create(VocabularV2.ignore_angle_in_supermode_with_high_gps_res, new CheckBoxRow("IGNORE ANGLE IN SUPERMODE WITH HIGH GPS RESOLUTION", "enabled"));
        config.create(VocabularV2.ignore_variance_in_supermode_with_high_gps_res, new CheckBoxRow("IGNORE VARIANCE IN SUPERMODE WITH HIGH GPS RESOLUTION", "enabled"));
        return config;
    }

    public static PanelConfig createCommunicationSettings(boolean withFeature_BAND_916MHZ, boolean withFeature_BAND_920MHZ, boolean supportGprsTime3) {
        PanelConfig config = new PanelConfig();
        ArrayList<Object> rows = new ArrayList<Object>();
        rows.add(new Section("Pinger Settings"));
        rows.add(VocabularV2.ping_ontime_begin);
        rows.add(VocabularV2.ping_ontime_end);
        rows.add(VocabularV2.ping_frequency);
        rows.add(VocabularV2.pinger_interval);
        rows.add(new Section("UMTS Settings"));
        rows.add(VocabularV2.gprs_time);
        rows.add(VocabularV2.gprs_time2);
        if (supportGprsTime3) {
            rows.add(VocabularV2.gprs_time3);
        }
        rows.add(VocabularV2.sms_time);
        rows.add(VocabularV2.sms_gps_collect_interval1);
        rows.add(VocabularV2.sms_gps_collect_offset1);
        rows.add(new Section("General Communication Settings"));
        rows.add(VocabularV2.secret_key);
        rows.add(VocabularV2.access_key);
        config.rows = rows.toArray();
        config.create(VocabularV2.ping_ontime_begin, new TextRow("Pinger On From (HH:MM)"));
        config.create(VocabularV2.ping_ontime_end, new TextRow("Pinger On Until (HH:MM)"));
        ConfigV2PanelFactory.setupFrequency(config, withFeature_BAND_916MHZ, withFeature_BAND_920MHZ);
        config.create(VocabularV2.gprs_time, new TextRow("GPRS Time (HH:MM)"), PanelConfig.defaultConvertMinutes);
        config.create(VocabularV2.gprs_time2, new TextRow("GPRS Time 2 (HH:MM)"), PanelConfig.defaultConvertMinutes);
        if (supportGprsTime3) {
            config.create(VocabularV2.gprs_time3, new TextRow("GPRS Time 3 (HH:MM)"), PanelConfig.defaultConvertMinutes);
        }
        config.create(VocabularV2.sms_time, new TextRow("SMS Time (HH:MM)"), PanelConfig.defaultConvertMinutes);
        config.create(VocabularV2.sms_gps_collect_interval1, new TextRow("SMS GPS Collect Interval (s)"), PanelConfig.defaultConvertSeconds, new PanelConfig.IntegerRange(0L, 65535L));
        config.create(VocabularV2.sms_gps_collect_offset1, new TextRow("SMS GPS Collect Offset (s)"), PanelConfig.defaultConvertSeconds, new PanelConfig.IntegerRange(0L, 65535L));
        config.create(VocabularV2.secret_key, new TextRow("Secret Key"), PanelConfig.defaultConvertInteger, new PanelConfig.IntegerRange(0L, 65535L));
        config.create(VocabularV2.access_key, new TextRow("Access Key"), PanelConfig.defaultConvertInteger, new PanelConfig.IntegerRange(0L, 255L));
        return config;
    }

    public static PanelConfig createExpertSettings() {
        PanelConfig config = new PanelConfig();
        ArrayList<BaseAttribute> rows = new ArrayList<BaseAttribute>();
        rows.add(VocabularV2.gps_day_divisor);
        rows.add(VocabularV2.gps_hour_shift);
        rows.add(VocabularV2.device_start_time);
        rows.add(VocabularV2.bat_threshold3);
        rows.add(VocabularV2.bat_threshold2);
        rows.add(VocabularV2.bat_gsm_threshold);
        rows.add(VocabularV2.bat_threshold1);
        rows.add(VocabularV2.bat_acc_threshold);
        rows.add(VocabularV2.bat_threshold0);
        rows.add(VocabularV2.maccess_voltlimit);
        rows.add(VocabularV2.bat_gprs_download_threshold);
        rows.add(VocabularV2.radio_longdelay);
        rows.add(VocabularV2.ignore_low_res_continue_gps_burst);
        config.rows = rows.toArray();
        config.create(VocabularV2.gps_day_divisor, new TextRow("GPS Day Divisor"), PanelConfig.defaultConvertInteger, new PanelConfig.IntegerRange(1L, 255L));
        config.create(VocabularV2.gps_hour_shift, new TextRow("GPS Hourshift"), PanelConfig.defaultConvertInteger, new PanelConfig.IntegerRange(0L, 255L));
        config.create(VocabularV2.device_start_time, new TextRow("Delayed Tag Start Day"), PanelConfig.defaultConvertDateTime);
        config.create(VocabularV2.bat_threshold3, new TextRow("Battery Threshold 3 (mV)"), PanelConfig.defaultConvertMillivolt, new PanelConfig.IntegerRange(3000L, 6000L));
        config.create(VocabularV2.bat_threshold2, new TextRow("Battery Threshold 2 (mV)"), PanelConfig.defaultConvertMillivolt, new PanelConfig.IntegerRange(1000L, 6000L));
        config.create(VocabularV2.bat_gsm_threshold, new TextRow("Battery GSM Threshold (mV)"), PanelConfig.defaultConvertMillivolt, new PanelConfig.IntegerRange(1000L, 6000L));
        config.create(VocabularV2.bat_threshold1, new TextRow("Battery Threshold 1 (mV)"), PanelConfig.defaultConvertMillivolt, new PanelConfig.IntegerRange(1000L, 6000L));
        config.create(VocabularV2.bat_acc_threshold, new TextRow("Battery ACC Threshold (mV)"), PanelConfig.defaultConvertMillivolt, new PanelConfig.IntegerRange(1000L, 6000L));
        config.create(VocabularV2.bat_threshold0, new TextRow("Battery Threshold 0 (mV)"), PanelConfig.defaultConvertMillivolt, new PanelConfig.IntegerRange(1000L, 6000L));
        config.create(VocabularV2.maccess_voltlimit, new TextRow("Maccess Voltlimit (mV)"), PanelConfig.defaultConvertMillivolt, new PanelConfig.IntegerRange(1000L, 6000L));
        config.create(VocabularV2.bat_gprs_download_threshold, new TextRow("Battery GPRS Download Threshold (mV)"), PanelConfig.defaultConvertMillivolt, new PanelConfig.IntegerRange(1000L, 6000L));
        config.create(VocabularV2.radio_longdelay, new TextRow("Radio Longdelay (s)"), PanelConfig.defaultConvertSeconds, new PanelConfig.IntegerRange(0L, 65535L));
        config.create(VocabularV2.ignore_low_res_continue_gps_burst, new CheckBoxRow("IGNORE LOW RESOLUTION, CONTINUE GPS BURST", "enabled"));
        return config;
    }

    public static PanelConfig createEobsExpertMode(boolean withFeature_BAND_916MHZ, boolean withFeature_BAND_920MHZ) {
        System.out.println("createEobsExpertMode: withFeature_BAND_916MHZ=" + withFeature_BAND_916MHZ + ", withFeature_BAND_920MHZ=" + withFeature_BAND_920MHZ);
        PanelConfig config = new PanelConfig();
        ArrayList<Object> rows = new ArrayList<Object>();
        rows.add(new Section("Feature Flags"));
        rows.add(new InfoRow("BAND_916MHZ", Boolean.toString(withFeature_BAND_916MHZ)));
        rows.add(new InfoRow("BAND_920MHZ", Boolean.toString(withFeature_BAND_920MHZ)));
        rows.add(new Section("Settings"));
        if (!withFeature_BAND_916MHZ && !withFeature_BAND_920MHZ) {
            rows.add(VocabularV2.datalink_2017);
        }
        rows.add(VocabularV2.sms_timeout);
        rows.add(VocabularV2.gprs_timeout);
        rows.add(VocabularV2.gprs_min_pk_freq);
        config.rows = rows.toArray();
        if (!withFeature_BAND_916MHZ && !withFeature_BAND_920MHZ) {
            config.create(VocabularV2.datalink_2017, new CheckBoxRow("Datalink 2017", "enabled"));
        }
        config.create(VocabularV2.sms_timeout, new TextRow("SMS Timeout (s)"), PanelConfig.defaultConvertSeconds, new PanelConfig.IntegerRange(0L, 65535L));
        config.create(VocabularV2.gprs_timeout, new TextRow("GPRS Timeout (s)"), PanelConfig.defaultConvertSeconds, new PanelConfig.IntegerRange(0L, 65535L));
        config.create(VocabularV2.gprs_min_pk_freq, new TextRow("GPRS MIN PK FREQ (0.1Hz)"), PanelConfig.defaultConvertInteger, new PanelConfig.IntegerRange(0L, 255L));
        return config;
    }
}

