/*
 * Decompiled with CFR 0.152.
 */
package de.eobs.setuptool.eventbus;

import de.eobs.setuptool.eventbus.EventBus;
import de.eobs.setuptool.eventbus.EventHandler;
import de.eobs.setuptool.eventbus.HandlerInfo;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventBusImpl
implements EventBus {
    static final Logger logger = LoggerFactory.getLogger(EventBusImpl.class);
    List<HandlerInfo> subscribers = new ArrayList<HandlerInfo>();
    private final ThreadPoolExecutor executor = new ThreadPoolExecutor(2, 2, 50000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
    private final int tpSize = 2;

    @Override
    public void subscribe(Object subscriber) {
        Method[] declaredMethods;
        System.out.println("subscribe: " + subscriber);
        for (Method m : declaredMethods = subscriber.getClass().getDeclaredMethods()) {
            EventHandler annotation = m.getAnnotation(EventHandler.class);
            if (annotation == null) continue;
            Class<?>[] parameters = m.getParameterTypes();
            if (parameters.length != 1) {
                throw new IllegalArgumentException("EventHandler methods must specify a single Object paramter.");
            }
            HandlerInfo info = new HandlerInfo(parameters[0], m, subscriber, annotation);
            System.out.println("createBasic handler: " + info);
            this.subscribers.add(info);
        }
    }

    @Override
    public void publish(final Object event) {
        logger.info("publish event: " + event);
        for (final HandlerInfo subscriber : this.subscribers) {
            if (!subscriber.matches(event)) continue;
            if (subscriber.getAnnotation().swingEDT()) {
                System.out.println("run in swing event dispatcher thread");
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            subscriber.getMethod().invoke(subscriber.getSubscriber(), event);
                        }
                        catch (IllegalArgumentException e) {
                            e.printStackTrace();
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                        }
                        catch (InvocationTargetException e) {
                            e.printStackTrace();
                        }
                    }
                });
                continue;
            }
            System.out.println("run in thread pool executor");
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        subscriber.getMethod().invoke(subscriber.getSubscriber(), event);
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }
}

