/*
 * Decompiled with CFR 0.152.
 */
package de.eobs.setuptool.getcredentialsdialog;

import de.eobs.setuptool.eventbus.EventBus;
import de.eobs.setuptool.eventbus.EventHandler;
import de.eobs.setuptool.getcredentialsdialog.GetCredentialsEvent;
import de.eobs.setuptool.getcredentialsdialog.GetCredentialsPanel;
import de.eobs.setuptool.getcredentialsdialog.TagCredentials;
import de.eobs.setuptool.getcredentialsdialog.TagCredentialsEvent;
import de.eobs.setuptool.rest.api.TagId;
import java.awt.Frame;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class GetCredentialsDialog {
    private final JFrame frame;
    private final EventBus eventBus;
    private JDialog dialog;

    public GetCredentialsDialog(JFrame appFrame, EventBus eventBus) {
        this.frame = appFrame;
        this.eventBus = eventBus;
    }

    @EventHandler(swingEDT=true)
    public void handle(GetCredentialsEvent event) {
        GetCredentialsPanel panel = new GetCredentialsPanel(new GetCredentialsPanel.Handler(){

            @Override
            public void onOk(TagId tagId, String password) {
                GetCredentialsDialog.this.dialog.setVisible(false);
                GetCredentialsDialog.this.eventBus.publish(new TagCredentialsEvent(new TagCredentials(tagId, password)));
            }

            @Override
            public void onCancel() {
                GetCredentialsDialog.this.dialog.setVisible(false);
            }
        });
        this.dialog = new JDialog((Frame)this.frame, true);
        this.dialog.setTitle("Enter Credentials");
        this.dialog.getContentPane().add(panel);
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(this.frame);
        this.dialog.getRootPane().setDefaultButton(panel.getOkButton());
        this.dialog.setVisible(true);
    }
}

