/*
 * Decompiled with CFR 0.152.
 */
package de.eobs.setuptool.gui.configurablepanel;

import de.eobs.setuptool.gui.configurablepanel.PanelConfig;
import de.eobs.setuptool.gui.inputvalidation.Validator;
import de.eobs.setuptool.gui.rowpanel.Row;
import de.eobs.setuptool.gui.rowpanel.RowPanelFactory;
import de.eobs.setuptool.gui.tagconfigaccess.BaseAttribute;
import de.eobs.setuptool.gui.tagconfigaccess.TagConfigAccess;
import java.awt.BorderLayout;
import java.util.HashMap;
import java.util.List;
import javax.swing.JPanel;

public class ConfigurablePanel
extends JPanel {
    private final List<Validator> validators;
    final List<BaseAttribute> attributeList;
    public final HashMap<BaseAttribute, Row> rowMap;
    public final HashMap<BaseAttribute, PanelConfig.UpdateGui> updateGuiList;
    private final String title;
    public Object[] rows;

    public ConfigurablePanel(PanelConfig panelConfig, String title) {
        this.validators = panelConfig.validators;
        this.attributeList = panelConfig.attributeList;
        this.rowMap = panelConfig.rowMap;
        this.updateGuiList = panelConfig.updateGuiList;
        this.rows = panelConfig.rows;
        this.title = title;
        this.initElements();
    }

    public ConfigurablePanel(PanelConfig panelConfig) {
        this(panelConfig, "TODO: Set title!");
    }

    void initElements() {
        Row[] rows2 = new Row[this.rows.length];
        for (int i = 0; i < this.rows.length; ++i) {
            if (this.rows[i] instanceof BaseAttribute) {
                rows2[i] = this.rowMap.get(this.rows[i]);
            } else if (this.rows[i] instanceof Row) {
                rows2[i] = (Row)this.rows[i];
            }
            if (rows2[i] != null) continue;
            throw new RuntimeException("unhandled row: " + this.rows[i]);
        }
        JPanel testPanel = RowPanelFactory.create(rows2);
        this.setLayout(new BorderLayout());
        this.add("Center", testPanel);
    }

    public void fromConfig(TagConfigAccess access) {
        for (PanelConfig.UpdateGui u : this.updateGuiList.values()) {
            u.copyToGui(access);
        }
    }

    public void updateConfig(TagConfigAccess access) {
        for (PanelConfig.UpdateGui u : this.updateGuiList.values()) {
            u.copyToConfig(access);
        }
    }

    public boolean isUserInputValid() {
        for (Validator v : this.validators) {
            if (v.isValid()) continue;
            return false;
        }
        return true;
    }

    public String getTitle() {
        return this.title;
    }
}

