/*
 * Decompiled with CFR 0.152.
 */
package de.eobs.setuptool.gui.configurablepanel;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EobsStructs {
    static final Logger logger = LoggerFactory.getLogger(EobsStructs.class);
    static final DateTimeFormatter format = DateTimeFormat.forPattern((String)"YYYY-MM-dd HH:mm").withZoneUTC();

    public static int parseSeconds(String seconds) {
        return Integer.parseInt(seconds);
    }

    public static int parseMinutes(String hoursMinutes) {
        String[] parts = hoursMinutes.split(":");
        if (parts.length != 2) {
            throw new RuntimeException("expected HH:MM");
        }
        int hour = Integer.parseInt(parts[0]);
        int minute = Integer.parseInt(parts[1]);
        if (hour < 0 || hour > 23) {
            throw new RuntimeException("hour out of range: " + hour);
        }
        if (minute < 0 || minute > 59) {
            throw new RuntimeException("minute out of range: " + minute);
        }
        return hour * 60 + minute;
    }

    public static String printFreqMHz(long value) {
        double d = 27.0 * (double)value / 65536.0;
        String text = String.format(Locale.US, "%.4f", d);
        return text;
    }

    public static long parseFreqMHz(String freq) {
        NumberFormat nf = NumberFormat.getInstance(Locale.US);
        try {
            double doubleValue = nf.parse(freq).doubleValue();
            double d = doubleValue * 65536.0 / 27.0;
            return (long)(d + 0.5);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    private static String printInteger(int value) {
        return Integer.toString(value);
    }

    private static int parseInteger(String value) {
        return Integer.valueOf(value);
    }

    private static String printLong(long value) {
        return Long.toString(value);
    }

    public static long parseLong(String value) {
        return Long.valueOf(value);
    }

    public static String printMinutes(int minutes) {
        int m = minutes % 60;
        int h = minutes / 60;
        return String.format("%02d:%02d", h, m);
    }

    public static String printSeconds(long seconds) {
        return Long.toString(seconds);
    }

    public static long fromDateTime(DateTime date) {
        DateTime base = new DateTime(2007, 3, 4, 0, 0, DateTimeZone.UTC);
        long seconds = (date.getMillis() - base.getMillis()) / 1000L;
        return seconds;
    }

    public static DateTime toDateTime(long seconds) {
        DateTime base = new DateTime(2007, 3, 4, 0, 0, DateTimeZone.UTC);
        DateTime date = new DateTime(base.getMillis() + seconds * 1000L, DateTimeZone.UTC);
        return date;
    }

    public static String printDateTime(DateTime date) {
        return format.print((ReadableInstant)date);
    }

    public static DateTime parseDateTime(String value) {
        return format.parseDateTime(value);
    }
}

