/*
 * Decompiled with CFR 0.152.
 */
package de.eobs.setuptool.gui.configurablepanel;

import de.eobs.setuptool.gui.configurablepanel.Convert;
import de.eobs.setuptool.gui.configurablepanel.EobsStructs;
import de.eobs.setuptool.gui.inputvalidation.TextFieldDateValidator;
import de.eobs.setuptool.gui.inputvalidation.TextFieldHourMinuteValidator;
import de.eobs.setuptool.gui.inputvalidation.TextFieldIntegerValidator;
import de.eobs.setuptool.gui.inputvalidation.TextFieldNumericValidator;
import de.eobs.setuptool.gui.inputvalidation.Validator;
import de.eobs.setuptool.gui.inputvalidation.pinger916MHz.TextFieldIntegerValidatorPinger916MHz;
import de.eobs.setuptool.gui.inputvalidation.pinger916MHz.TextFieldNumericValidatorPinger916MHz;
import de.eobs.setuptool.gui.rowpanel.CheckBoxRow;
import de.eobs.setuptool.gui.rowpanel.ComboBoxRow;
import de.eobs.setuptool.gui.rowpanel.Row;
import de.eobs.setuptool.gui.rowpanel.RowPanelFactory;
import de.eobs.setuptool.gui.rowpanel.TextRow;
import de.eobs.setuptool.gui.tagconfigaccess.AttributeFlag;
import de.eobs.setuptool.gui.tagconfigaccess.AttributeS8;
import de.eobs.setuptool.gui.tagconfigaccess.AttributeTimeLimitsBegin;
import de.eobs.setuptool.gui.tagconfigaccess.AttributeTimeLimitsEnd;
import de.eobs.setuptool.gui.tagconfigaccess.AttributeU16;
import de.eobs.setuptool.gui.tagconfigaccess.AttributeU32;
import de.eobs.setuptool.gui.tagconfigaccess.AttributeU8;
import de.eobs.setuptool.gui.tagconfigaccess.BaseAttribute;
import de.eobs.setuptool.gui.tagconfigaccess.TagConfigAccess;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class PanelConfig {
    public Object[] rows;
    final List<Validator> validators = new ArrayList<Validator>();
    List<BaseAttribute> attributeList = new ArrayList<BaseAttribute>();
    HashMap<BaseAttribute, Row> rowMap = new HashMap();
    HashMap<BaseAttribute, UpdateGui> updateGuiList = new HashMap();
    public static final ConvertSeconds defaultConvertSeconds = new ConvertSeconds();
    public static final ConvertMinutes defaultConvertMinutes = new ConvertMinutes();
    public static final ConvertSamplerate_OldStyle defaultConvertSamplerate = new ConvertSamplerate_OldStyle();
    public static final ConvertSamplerate_MMA8452_SMBUS defaultConvertSamplerate_MMA8452_SMBUS = new ConvertSamplerate_MMA8452_SMBUS();
    public static final ConvertInteger defaultConvertInteger = new ConvertInteger();
    public static final ConvertMHz defaultConvertMHz = new ConvertMHz();
    public static final ConvertDateTime defaultConvertDateTime = new ConvertDateTime();
    public static final ConvertMillivolt defaultConvertMillivolt = new ConvertMillivolt();

    public void create(final AttributeFlag attribute, final CheckBoxRow checkBoxRow) {
        this.attributeList.add(attribute);
        this.rowMap.put(attribute, checkBoxRow);
        this.updateGuiList.put(attribute, new UpdateGui(){

            @Override
            public void copyToGui(TagConfigAccess access) {
                checkBoxRow.getCheckBox().setSelected(access.get(attribute));
            }

            @Override
            public void copyToConfig(TagConfigAccess access) {
                access.set(attribute, checkBoxRow.getCheckBox().isSelected());
            }

            @Override
            public String convertToString(TagConfigAccess access) {
                return Boolean.toString(access.get(attribute));
            }
        });
    }

    public void create(final AttributeU8 attribute, final ComboBoxRow comboBoxRow) {
        this.attributeList.add(attribute);
        this.rowMap.put(attribute, comboBoxRow);
        this.updateGuiList.put(attribute, new UpdateGui(){

            @Override
            public void copyToGui(TagConfigAccess access) {
                DefaultComboBoxModel model = (DefaultComboBoxModel)comboBoxRow.getComboBox().getModel();
                int index = (int)access.get(attribute);
                if (index < 0 || index >= comboBoxRow.getComboBox().getItemCount()) {
                    throw new IllegalArgumentException("index not available in combobox: " + index);
                }
                comboBoxRow.getComboBox().setSelectedIndex(index);
            }

            @Override
            public void copyToConfig(TagConfigAccess access) {
                access.set(attribute, (long)comboBoxRow.getComboBox().getSelectedIndex());
            }

            @Override
            public String convertToString(TagConfigAccess access) {
                DefaultComboBoxModel model = (DefaultComboBoxModel)comboBoxRow.getComboBox().getModel();
                int index = (int)access.get(attribute);
                return (String)model.getElementAt(index);
            }
        });
    }

    public void create(final AttributeU16 attribute, final ComboBoxRow comboBoxRow, final ConvertInteger convert) {
        this.attributeList.add(attribute);
        this.rowMap.put(attribute, comboBoxRow);
        this.updateGuiList.put(attribute, new UpdateGui(){

            @Override
            public void copyToGui(TagConfigAccess access) {
                String text;
                DefaultComboBoxModel model = (DefaultComboBoxModel)comboBoxRow.getComboBox().getModel();
                int index = model.getIndexOf(text = convert.toText(access.get(attribute)));
                if (index < 0) {
                    throw new IllegalArgumentException("item not available in combobox: '" + text + "'");
                }
                comboBoxRow.getComboBox().setSelectedIndex(index);
            }

            @Override
            public void copyToConfig(TagConfigAccess access) {
                access.set(attribute, convert.fromText((String)comboBoxRow.getComboBox().getSelectedItem()));
            }

            @Override
            public String convertToString(TagConfigAccess access) {
                return convert.toText(access.get(attribute));
            }
        });
    }

    public void create(final AttributeU8 attribute, final ComboBoxRow comboBoxRow, final ConvertSamplerate convert) {
        this.attributeList.add(attribute);
        this.rowMap.put(attribute, comboBoxRow);
        this.updateGuiList.put(attribute, new UpdateGui(){

            @Override
            public void copyToGui(TagConfigAccess access) {
                comboBoxRow.getComboBox().setSelectedItem(convert.toText(access.get(attribute)));
            }

            @Override
            public void copyToConfig(TagConfigAccess access) {
                access.set(attribute, convert.fromText((String)comboBoxRow.getComboBox().getSelectedItem()));
            }

            @Override
            public String convertToString(TagConfigAccess access) {
                return convert.toText(access.get(attribute));
            }
        });
    }

    public void create(final AttributeU8 attribute, final TextRow textRow, final ConvertInteger convert, IntegerRange validatorRange) {
        this.attributeList.add(attribute);
        this.rowMap.put(attribute, textRow);
        this.updateGuiList.put(attribute, new UpdateGui(){

            @Override
            public void copyToGui(TagConfigAccess access) {
                textRow.getTextField().setText(convert.toText(access.get(attribute)));
            }

            @Override
            public void copyToConfig(TagConfigAccess access) {
                access.set(attribute, convert.fromText(textRow.getTextField().getText()));
            }

            @Override
            public String convertToString(TagConfigAccess access) {
                return convert.toText(access.get(attribute));
            }
        });
        this.validators.add(new TextFieldIntegerValidator(textRow.getTextField(), validatorRange.getMin(), validatorRange.getMax()));
    }

    public void create(final AttributeS8 attribute, final TextRow textRow, final ConvertInteger convert, IntegerRange validatorRange) {
        this.attributeList.add(attribute);
        this.rowMap.put(attribute, textRow);
        this.updateGuiList.put(attribute, new UpdateGui(){

            @Override
            public void copyToGui(TagConfigAccess access) {
                textRow.getTextField().setText(convert.toText(access.get(attribute)));
            }

            @Override
            public void copyToConfig(TagConfigAccess access) {
                access.set(attribute, convert.fromText(textRow.getTextField().getText()));
            }

            @Override
            public String convertToString(TagConfigAccess access) {
                return convert.toText(access.get(attribute));
            }
        });
        this.validators.add(new TextFieldIntegerValidator(textRow.getTextField(), validatorRange.getMin(), validatorRange.getMax()));
    }

    public void create(final AttributeU8 attribute, final TextRow textRow, final ConvertSeconds convert, IntegerRange validatorRange) {
        this.attributeList.add(attribute);
        this.rowMap.put(attribute, textRow);
        this.updateGuiList.put(attribute, new UpdateGui(){

            @Override
            public void copyToGui(TagConfigAccess access) {
                textRow.getTextField().setText(convert.toText(access.get(attribute)));
            }

            @Override
            public void copyToConfig(TagConfigAccess access) {
                access.set(attribute, convert.fromText(textRow.getTextField().getText()));
            }

            @Override
            public String convertToString(TagConfigAccess access) {
                return convert.toText(access.get(attribute));
            }
        });
        this.validators.add(new TextFieldIntegerValidator(textRow.getTextField(), validatorRange.getMin(), validatorRange.getMax()));
    }

    public TextFieldIntegerValidatorPinger916MHz create(final AttributeU8 attribute, final TextRow textRow, final ConvertSeconds convert, TextFieldIntegerValidatorPinger916MHz.ChangableRange range) {
        this.attributeList.add(attribute);
        this.rowMap.put(attribute, textRow);
        this.updateGuiList.put(attribute, new UpdateGui(){

            @Override
            public void copyToGui(TagConfigAccess access) {
                textRow.getTextField().setText(convert.toText(access.get(attribute)));
            }

            @Override
            public void copyToConfig(TagConfigAccess access) {
                access.set(attribute, convert.fromText(textRow.getTextField().getText()));
            }

            @Override
            public String convertToString(TagConfigAccess access) {
                return convert.toText(access.get(attribute));
            }
        });
        TextFieldIntegerValidatorPinger916MHz validator = new TextFieldIntegerValidatorPinger916MHz(textRow.getTextField(), range);
        this.validators.add(validator);
        return validator;
    }

    public void create(final AttributeU16 attribute, final TextRow textRow, final ConvertInteger convert, IntegerRange validatorRange) {
        this.attributeList.add(attribute);
        this.rowMap.put(attribute, textRow);
        this.updateGuiList.put(attribute, new UpdateGui(){

            @Override
            public void copyToGui(TagConfigAccess access) {
                textRow.getTextField().setText(convert.toText(access.get(attribute)));
            }

            @Override
            public void copyToConfig(TagConfigAccess access) {
                access.set(attribute, convert.fromText(textRow.getTextField().getText()));
            }

            @Override
            public String convertToString(TagConfigAccess access) {
                return convert.toText(access.get(attribute));
            }
        });
        this.validators.add(new TextFieldIntegerValidator(textRow.getTextField(), validatorRange.getMin(), validatorRange.getMax()));
    }

    public void create(final AttributeU32 attribute, final TextRow textRow, final ConvertInteger convert, IntegerRange validatorRange) {
        this.attributeList.add(attribute);
        this.rowMap.put(attribute, textRow);
        this.updateGuiList.put(attribute, new UpdateGui(){

            @Override
            public void copyToGui(TagConfigAccess access) {
                textRow.getTextField().setText(convert.toText(access.get(attribute)));
            }

            @Override
            public void copyToConfig(TagConfigAccess access) {
                access.set(attribute, convert.fromText(textRow.getTextField().getText()));
            }

            @Override
            public String convertToString(TagConfigAccess access) {
                return convert.toText(access.get(attribute));
            }
        });
        this.validators.add(new TextFieldIntegerValidator(textRow.getTextField(), validatorRange.getMin(), validatorRange.getMax()));
    }

    public void create(final AttributeU16 attribute, final TextRow textRow, final ConvertSeconds convert, IntegerRange validatorRange) {
        this.attributeList.add(attribute);
        this.rowMap.put(attribute, textRow);
        this.updateGuiList.put(attribute, new UpdateGui(){

            @Override
            public void copyToGui(TagConfigAccess access) {
                textRow.getTextField().setText(convert.toText(access.get(attribute)));
            }

            @Override
            public void copyToConfig(TagConfigAccess access) {
                System.out.println("copyToConfig: " + attribute);
                access.set(attribute, convert.fromText(textRow.getTextField().getText()));
            }

            @Override
            public String convertToString(TagConfigAccess access) {
                return convert.toText(access.get(attribute));
            }
        });
        this.validators.add(new TextFieldIntegerValidator(textRow.getTextField(), validatorRange.getMin(), validatorRange.getMax()));
    }

    public void create(final AttributeU16 attribute, final TextRow textRow, final ConvertMinutes convert) {
        this.attributeList.add(attribute);
        this.rowMap.put(attribute, textRow);
        this.updateGuiList.put(attribute, new UpdateGui(){

            @Override
            public void copyToGui(TagConfigAccess access) {
                textRow.getTextField().setText(convert.toText(access.get(attribute)));
            }

            @Override
            public void copyToConfig(TagConfigAccess access) {
                access.set(attribute, convert.fromText(textRow.getTextField().getText()));
            }

            @Override
            public String convertToString(TagConfigAccess access) {
                return convert.toText(access.get(attribute));
            }
        });
        this.validators.add(new TextFieldHourMinuteValidator(textRow.getTextField()));
    }

    public void create(final AttributeU16 attribute, final TextRow textRow, final ConvertMillivolt convert, IntegerRange validatorRange) {
        this.attributeList.add(attribute);
        this.rowMap.put(attribute, textRow);
        this.updateGuiList.put(attribute, new UpdateGui(){

            @Override
            public void copyToGui(TagConfigAccess access) {
                textRow.getTextField().setText(convert.toText(access.get(attribute)));
            }

            @Override
            public void copyToConfig(TagConfigAccess access) {
                access.set(attribute, convert.fromText(textRow.getTextField().getText()));
            }

            @Override
            public String convertToString(TagConfigAccess access) {
                return convert.toText(access.get(attribute));
            }
        });
        this.validators.add(new TextFieldIntegerValidator(textRow.getTextField(), validatorRange.getMin(), validatorRange.getMax()));
    }

    public void create(final AttributeTimeLimitsBegin attribute, final TextRow textRow) {
        this.attributeList.add(attribute);
        this.rowMap.put(attribute, textRow);
        this.updateGuiList.put(attribute, new UpdateGui(){

            @Override
            public void copyToGui(TagConfigAccess access) {
                textRow.getTextField().setText(defaultConvertMinutes.toText(access.get(attribute)));
            }

            @Override
            public void copyToConfig(TagConfigAccess access) {
                access.set(attribute, defaultConvertMinutes.fromText(textRow.getTextField().getText()));
            }

            @Override
            public String convertToString(TagConfigAccess access) {
                return defaultConvertMinutes.toText(access.get(attribute));
            }
        });
        this.validators.add(new TextFieldHourMinuteValidator(textRow.getTextField()));
    }

    public void create(final AttributeTimeLimitsEnd attribute, final TextRow textRow) {
        this.attributeList.add(attribute);
        this.rowMap.put(attribute, textRow);
        this.updateGuiList.put(attribute, new UpdateGui(){

            @Override
            public void copyToGui(TagConfigAccess access) {
                textRow.getTextField().setText(defaultConvertMinutes.toText(access.get(attribute)));
            }

            @Override
            public void copyToConfig(TagConfigAccess access) {
                access.set(attribute, defaultConvertMinutes.fromText(textRow.getTextField().getText()));
            }

            @Override
            public String convertToString(TagConfigAccess access) {
                return defaultConvertMinutes.toText(access.get(attribute));
            }
        });
        this.validators.add(new TextFieldHourMinuteValidator(textRow.getTextField()));
    }

    public void create(final AttributeU32 attribute, final TextRow textRow, final ConvertSeconds convert, IntegerRange validatorRange) {
        this.attributeList.add(attribute);
        this.rowMap.put(attribute, textRow);
        this.updateGuiList.put(attribute, new UpdateGui(){

            @Override
            public void copyToGui(TagConfigAccess access) {
                textRow.getTextField().setText(convert.toText(access.get(attribute)));
            }

            @Override
            public void copyToConfig(TagConfigAccess access) {
                access.set(attribute, convert.fromText(textRow.getTextField().getText()));
            }

            @Override
            public String convertToString(TagConfigAccess access) {
                return convert.toText(access.get(attribute));
            }
        });
        this.validators.add(new TextFieldIntegerValidator(textRow.getTextField(), validatorRange.getMin(), validatorRange.getMax()));
    }

    public void create(final AttributeU32 attribute, final TextRow textRow, final ConvertMHz convert, NumericRange validatorRange) {
        this.attributeList.add(attribute);
        this.rowMap.put(attribute, textRow);
        this.updateGuiList.put(attribute, new UpdateGui(){

            @Override
            public void copyToGui(TagConfigAccess access) {
                textRow.getTextField().setText(convert.toText(access.get(attribute)));
            }

            @Override
            public void copyToConfig(TagConfigAccess access) {
                access.set(attribute, convert.fromText(textRow.getTextField().getText()));
            }

            @Override
            public String convertToString(TagConfigAccess access) {
                return convert.toText(access.get(attribute));
            }
        });
        this.validators.add(new TextFieldNumericValidator(textRow.getTextField(), validatorRange.getMin(), validatorRange.getMax()));
    }

    public void createWithSanitizer(final AttributeU32 attribute, final TextRow textRow, final ConvertMHz convert, NumericRange validatorRange) {
        this.attributeList.add(attribute);
        this.rowMap.put(attribute, textRow);
        this.updateGuiList.put(attribute, new UpdateGui(){

            @Override
            public void copyToGui(TagConfigAccess access) {
                textRow.getTextField().setText(convert.toText(access.get(attribute)));
            }

            @Override
            public void copyToConfig(TagConfigAccess access) {
                access.set(attribute, convert.fromText(textRow.getTextField().getText()));
            }

            @Override
            public String convertToString(TagConfigAccess access) {
                return convert.toText(access.get(attribute));
            }
        });
        TextFieldNumericValidator validator = new TextFieldNumericValidator(textRow.getTextField(), validatorRange.getMin(), validatorRange.getMax());
        this.validators.add(validator);
        new TextFieldSanitizer(textRow.getTextField(), validator, convert);
    }

    public void createPinger916MHz(final AttributeU32 attribute, final TextRow textRow, final ConvertMHz convert, NumericRange validatorRange1, NumericRange validatorRange2, TextFieldChangeListener listener) {
        this.attributeList.add(attribute);
        this.rowMap.put(attribute, textRow);
        this.updateGuiList.put(attribute, new UpdateGui(){

            @Override
            public void copyToGui(TagConfigAccess access) {
                textRow.getTextField().setText(convert.toText(access.get(attribute)));
            }

            @Override
            public void copyToConfig(TagConfigAccess access) {
                access.set(attribute, convert.fromText(textRow.getTextField().getText()));
            }

            @Override
            public String convertToString(TagConfigAccess access) {
                return convert.toText(access.get(attribute));
            }
        });
        TextFieldNumericValidatorPinger916MHz validator = new TextFieldNumericValidatorPinger916MHz(textRow.getTextField(), validatorRange1.getMin(), validatorRange1.getMax(), validatorRange2.getMin(), validatorRange2.getMax());
        this.validators.add(validator);
        new TextFieldChangeObserver(textRow.getTextField(), listener, validator, convert);
        new TextFieldSanitizer(textRow.getTextField(), validator, convert);
    }

    public void create(final AttributeU32 attribute, final TextRow textRow, final ConvertDateTime convert) {
        this.attributeList.add(attribute);
        this.rowMap.put(attribute, textRow);
        this.updateGuiList.put(attribute, new UpdateGui(){

            @Override
            public void copyToGui(TagConfigAccess access) {
                textRow.getTextField().setText(convert.toText(access.get(attribute)));
            }

            @Override
            public void copyToConfig(TagConfigAccess access) {
                access.set(attribute, convert.fromText(textRow.getTextField().getText()));
            }

            @Override
            public String convertToString(TagConfigAccess access) {
                return convert.toText(access.get(attribute));
            }
        });
        this.validators.add(new TextFieldDateValidator(textRow.getTextField()));
    }

    public static class NumericRange {
        private final BigDecimal min;
        private final BigDecimal max;

        public NumericRange(BigDecimal min, BigDecimal max) {
            this.min = min;
            this.max = max;
        }

        public BigDecimal getMax() {
            return this.max;
        }

        public BigDecimal getMin() {
            return this.min;
        }
    }

    public static class IntegerRange {
        private final long min;
        private final long max;

        public IntegerRange(long min, long max) {
            this.min = min;
            this.max = max;
        }

        public long getMax() {
            return this.max;
        }

        public long getMin() {
            return this.min;
        }
    }

    public static class ConvertMillivoltOld
    implements Convert {
        @Override
        public String toText(long millivolt) {
            return String.format(Locale.US, "%3.0f", 5000.0 * (double)millivolt / 4096.0);
        }

        @Override
        public long fromText(String text) {
            NumberFormat nf = NumberFormat.getInstance(Locale.US);
            try {
                double doubleValue = nf.parse(text).doubleValue();
                return (long)(doubleValue * 4096.0 / 5000.0);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class ConvertMillivolt
    implements Convert {
        double factor = 0.8192;

        @Override
        public String toText(long millivolt) {
            return Long.toString((long)((double)millivolt / this.factor + 0.5));
        }

        @Override
        public long fromText(String text) {
            return (long)((double)Long.parseLong(text) * this.factor + 0.5);
        }
    }

    static class ConvertDateTime
    implements Convert {
        ConvertDateTime() {
        }

        @Override
        public String toText(long dateTime) {
            return EobsStructs.printDateTime(EobsStructs.toDateTime(dateTime));
        }

        @Override
        public long fromText(String text) {
            return EobsStructs.fromDateTime(EobsStructs.parseDateTime(text));
        }
    }

    static class ConvertMHz
    implements Convert {
        ConvertMHz() {
        }

        @Override
        public String toText(long mhz) {
            return EobsStructs.printFreqMHz(mhz);
        }

        @Override
        public long fromText(String text) {
            return EobsStructs.parseFreqMHz(text);
        }
    }

    static class ConvertInteger
    implements Convert {
        ConvertInteger() {
        }

        @Override
        public String toText(long i) {
            return Integer.toString((int)i);
        }

        @Override
        public long fromText(String text) {
            return Integer.parseInt(text);
        }
    }

    static class ConvertSamplerate_MMA8452_SMBUS
    implements ConvertSamplerate {
        ConvertSamplerate_MMA8452_SMBUS() {
        }

        @Override
        public String toText(long samplerate) {
            return RowPanelFactory.SAMPLERATE_ITEMS_MMA8452_SMBUS[RowPanelFactory.SAMPLERATE_ITEMS_MMA8452_SMBUS.length - (int)samplerate];
        }

        @Override
        public long fromText(String accSamplerate) {
            for (int i = 0; i < RowPanelFactory.SAMPLERATE_ITEMS_MMA8452_SMBUS.length; ++i) {
                if (!accSamplerate.equals(RowPanelFactory.SAMPLERATE_ITEMS_MMA8452_SMBUS[i])) continue;
                return RowPanelFactory.SAMPLERATE_ITEMS_MMA8452_SMBUS.length - i;
            }
            throw new RuntimeException("sample rate config not found: " + accSamplerate);
        }
    }

    static class ConvertSamplerate_OldStyle
    implements ConvertSamplerate {
        ConvertSamplerate_OldStyle() {
        }

        @Override
        public String toText(long samplerate) {
            return RowPanelFactory.SAMPLERATE_ITEMS[(int)samplerate];
        }

        @Override
        public long fromText(String text) {
            for (int i = 0; i < RowPanelFactory.SAMPLERATE_ITEMS.length; ++i) {
                if (!text.equals(RowPanelFactory.SAMPLERATE_ITEMS[i])) continue;
                return i;
            }
            throw new RuntimeException("sample rate config not found: " + text);
        }
    }

    static interface ConvertSamplerate
    extends Convert {
        @Override
        public String toText(long var1);

        @Override
        public long fromText(String var1);
    }

    static class ConvertMinutes
    implements Convert {
        ConvertMinutes() {
        }

        @Override
        public String toText(long minutes) {
            return EobsStructs.printMinutes((int)minutes);
        }

        @Override
        public long fromText(String text) {
            return EobsStructs.parseMinutes(text);
        }
    }

    static class ConvertSeconds
    implements Convert {
        ConvertSeconds() {
        }

        @Override
        public String toText(long seconds) {
            return EobsStructs.printSeconds(seconds);
        }

        @Override
        public long fromText(String text) {
            return EobsStructs.parseSeconds(text);
        }
    }

    static class TextFieldChangeObserver {
        public TextFieldChangeObserver(final JTextField textField, final TextFieldChangeListener listener, final Validator validator, final Convert convert) {
            textField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.changed(textField, listener, validator, convert);
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.changed(textField, listener, validator, convert);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.changed(textField, listener, validator, convert);
                }
            });
        }

        private void changed(JTextField textField, TextFieldChangeListener listener, Validator validator, Convert convert) {
            if (validator.isValid()) {
                listener.changed(convert.fromText(textField.getText()));
            }
        }
    }

    public static interface TextFieldChangeListener {
        public void changed(long var1);
    }

    static class TextFieldSanitizer {
        public TextFieldSanitizer(final JTextField textField, final Validator validator, final Convert convert) {
            textField.addFocusListener(new FocusListener(){

                @Override
                public void focusLost(FocusEvent e) {
                    System.out.println("focus lost");
                    if (validator.isValid()) {
                        long value = convert.fromText(textField.getText());
                        String value2 = convert.toText(value);
                        System.out.println("sanitize: " + textField.getText() + " => " + value + " => " + value2);
                        textField.setText(value2);
                    }
                }

                @Override
                public void focusGained(FocusEvent e) {
                }
            });
        }
    }

    public static interface UpdateGui {
        public void copyToGui(TagConfigAccess var1);

        public void copyToConfig(TagConfigAccess var1);

        public String convertToString(TagConfigAccess var1);
    }
}

