/*
 * Decompiled with CFR 0.152.
 */
package de.eobs.setuptool.gui.inputvalidation;

import de.eobs.setuptool.gui.configurablepanel.EobsStructs;
import de.eobs.setuptool.gui.inputvalidation.Validator;
import java.awt.Color;
import javax.swing.BorderFactory;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class TextFieldDateValidator
implements Validator {
    private final JTextField textField;
    private final Border defaultBorder;

    public TextFieldDateValidator(JTextField textField) {
        this.textField = textField;
        this.defaultBorder = textField.getBorder();
        textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                TextFieldDateValidator.this.validate();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                TextFieldDateValidator.this.validate();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                TextFieldDateValidator.this.validate();
            }
        });
        this.validate();
    }

    private void validate() {
        if (this.isValid()) {
            this.textField.setBorder(this.defaultBorder);
        } else {
            this.textField.setBorder(BorderFactory.createLineBorder(Color.RED));
        }
    }

    @Override
    public boolean isValid() {
        String text = this.textField.getText();
        if (this.isParsable(text)) {
            DateTime min = new DateTime(2007, 3, 4, 0, 0, DateTimeZone.UTC);
            DateTime max = new DateTime(min.getMillis() + 4294967295000L, DateTimeZone.UTC);
            DateTime date = EobsStructs.parseDateTime(text);
            if (date.getMillis() >= min.getMillis() && date.getMillis() <= max.getMillis()) {
                return true;
            }
        }
        return false;
    }

    private boolean isParsable(String text) {
        try {
            EobsStructs.parseDateTime(text);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    @Override
    public void revalidate() {
        this.validate();
    }
}

