/*
 * Decompiled with CFR 0.152.
 */
package de.eobs.setuptool.gui.inputvalidation;

import de.eobs.setuptool.gui.inputvalidation.Validator;
import java.awt.Color;
import javax.swing.BorderFactory;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class TextFieldHourMinuteValidator
implements Validator {
    private final JTextField textField;
    private final Border defaultBorder;

    public TextFieldHourMinuteValidator(JTextField textField) {
        this.textField = textField;
        this.defaultBorder = textField.getBorder();
        textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                TextFieldHourMinuteValidator.this.validate();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                TextFieldHourMinuteValidator.this.validate();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                TextFieldHourMinuteValidator.this.validate();
            }
        });
        this.validate();
    }

    private void validate() {
        if (this.isValid()) {
            this.textField.setBorder(this.defaultBorder);
        } else {
            this.textField.setBorder(BorderFactory.createLineBorder(Color.RED));
        }
    }

    @Override
    public boolean isValid() {
        String text = this.textField.getText();
        return this.isParsable(text);
    }

    private boolean isParsable(String text) {
        String[] parts = text.split(":");
        if (parts.length != 2) {
            return false;
        }
        try {
            int h = Integer.parseInt(parts[0]);
            int m = Integer.parseInt(parts[1]);
            if (h < 0 || h > 23) {
                return false;
            }
            if (m < 0 || m > 59) {
                return false;
            }
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    @Override
    public void revalidate() {
        this.validate();
    }
}

