/*
 * Decompiled with CFR 0.152.
 */
package de.eobs.setuptool.gui.inputvalidation;

import de.eobs.setuptool.gui.inputvalidation.Validator;
import java.awt.Color;
import javax.swing.BorderFactory;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class TextFieldIntegerValidator
implements Validator {
    private final JTextField textField;
    private final Border defaultBorder;
    private final long minValue;
    private final long maxValue;

    public TextFieldIntegerValidator(JTextField textField, long minValue, long maxValue) {
        this.textField = textField;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.defaultBorder = textField.getBorder();
        textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                TextFieldIntegerValidator.this.validate();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                TextFieldIntegerValidator.this.validate();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                TextFieldIntegerValidator.this.validate();
            }
        });
        this.validate();
    }

    private void validate() {
        if (this.isValid()) {
            this.textField.setBorder(this.defaultBorder);
        } else {
            this.textField.setBorder(BorderFactory.createLineBorder(Color.RED));
        }
    }

    @Override
    public boolean isValid() {
        long value;
        String text = this.textField.getText();
        return this.isParsableAsInteger(text) && (value = Long.parseLong(text)) >= this.minValue && value <= this.maxValue;
    }

    private boolean isParsableAsInteger(String text) {
        try {
            Long.parseLong(text);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    public void revalidate() {
        this.validate();
    }
}

