/*
 * Decompiled with CFR 0.152.
 */
package de.eobs.setuptool.gui.inputvalidation;

import de.eobs.setuptool.gui.inputvalidation.Validator;
import java.awt.Color;
import java.math.BigDecimal;
import javax.swing.BorderFactory;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class TextFieldNumericValidator
implements Validator {
    private final JTextField textField;
    private final Border defaultBorder;
    private final BigDecimal minValue;
    private final BigDecimal maxValue;

    public TextFieldNumericValidator(JTextField textField, BigDecimal min, BigDecimal max) {
        this.textField = textField;
        this.minValue = min;
        this.maxValue = max;
        this.defaultBorder = textField.getBorder();
        textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                TextFieldNumericValidator.this.validate();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                TextFieldNumericValidator.this.validate();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                TextFieldNumericValidator.this.validate();
            }
        });
        this.validate();
    }

    private void validate() {
        if (this.isValid()) {
            this.textField.setBorder(this.defaultBorder);
        } else {
            this.textField.setBorder(BorderFactory.createLineBorder(Color.RED));
        }
    }

    @Override
    public boolean isValid() {
        BigDecimal value;
        String text = this.textField.getText();
        return this.isParsable(text) && (value = new BigDecimal(text)).compareTo(this.minValue) >= 0 && value.compareTo(this.maxValue) <= 0;
    }

    private boolean isParsable(String text) {
        try {
            new BigDecimal(text);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    public void revalidate() {
        this.validate();
    }
}

