/*
 * Decompiled with CFR 0.152.
 */
package de.eobs.setuptool.gui.inputvalidation.pinger916MHz;

import de.eobs.setuptool.gui.inputvalidation.Validator;
import java.awt.Color;
import javax.swing.BorderFactory;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class TextFieldIntegerValidatorPinger916MHz
implements Validator {
    private final JTextField textField;
    private final Border defaultBorder;
    private final ChangableRange range;

    public TextFieldIntegerValidatorPinger916MHz(JTextField textField, ChangableRange range) {
        this.textField = textField;
        this.range = range;
        this.defaultBorder = textField.getBorder();
        textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                TextFieldIntegerValidatorPinger916MHz.this.validate();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                TextFieldIntegerValidatorPinger916MHz.this.validate();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                TextFieldIntegerValidatorPinger916MHz.this.validate();
            }
        });
        this.validate();
    }

    @Override
    public void revalidate() {
        this.validate();
    }

    private void validate() {
        if (this.isValid()) {
            this.textField.setBorder(this.defaultBorder);
        } else {
            this.textField.setBorder(BorderFactory.createLineBorder(Color.RED));
        }
    }

    @Override
    public boolean isValid() {
        long value;
        String text = this.textField.getText();
        return this.isParsableAsInteger(text) && (value = Long.parseLong(text)) >= this.range.minValue && value <= this.range.maxValue;
    }

    private boolean isParsableAsInteger(String text) {
        try {
            Long.parseLong(text);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static class ChangableRange {
        public long minValue;
        public long maxValue;

        public ChangableRange(int minValue, int maxValue) {
            this.minValue = minValue;
            this.maxValue = maxValue;
        }
    }
}

