/*
 * Decompiled with CFR 0.152.
 */
package de.eobs.setuptool.gui.inputvalidation.pinger916MHz;

import de.eobs.setuptool.gui.inputvalidation.Validator;
import java.awt.Color;
import java.math.BigDecimal;
import javax.swing.BorderFactory;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class TextFieldNumericValidatorPinger916MHz
implements Validator {
    private final JTextField textField;
    private final Border defaultBorder;
    private final BigDecimal minValue1;
    private final BigDecimal maxValue1;
    private final BigDecimal minValue2;
    private final BigDecimal maxValue2;

    public TextFieldNumericValidatorPinger916MHz(JTextField textField, BigDecimal min1, BigDecimal max1, BigDecimal min2, BigDecimal max2) {
        this.textField = textField;
        this.minValue1 = min1;
        this.maxValue1 = max1;
        this.minValue2 = min2;
        this.maxValue2 = max2;
        this.defaultBorder = textField.getBorder();
        textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                TextFieldNumericValidatorPinger916MHz.this.validate();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                TextFieldNumericValidatorPinger916MHz.this.validate();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                TextFieldNumericValidatorPinger916MHz.this.validate();
            }
        });
        this.validate();
    }

    private void validate() {
        if (this.isValid()) {
            this.textField.setBorder(this.defaultBorder);
        } else {
            this.textField.setBorder(BorderFactory.createLineBorder(Color.RED));
        }
    }

    @Override
    public boolean isValid() {
        BigDecimal value;
        String text = this.textField.getText();
        return this.isParsable(text) && ((value = new BigDecimal(text)).compareTo(this.minValue1) >= 0 && value.compareTo(this.maxValue1) <= 0 || value.compareTo(this.minValue2) >= 0 && value.compareTo(this.maxValue2) <= 0);
    }

    private boolean isParsable(String text) {
        try {
            new BigDecimal(text);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    public void revalidate() {
        this.validate();
    }
}

