/*
 * Decompiled with CFR 0.152.
 */
package de.eobs.setuptool.gui.rowpanel;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.eobs.setuptool.configv0.ConfigV0PanelFactory;
import de.eobs.setuptool.gui.configurablepanel.ConfigurablePanel;
import de.eobs.setuptool.gui.rowpanel.Row;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class RowPanelFactory {
    public static final String[] SAMPLERATE_ITEMS_MMA8452_SMBUS = new String[]{"3.0", "3.1", "3.2", "3.3", "3.4", "3.6", "3.7", "3.8", "4.0", "4.2", "4.3", "4.5", "4.8", "5.0", "5.3", "5.6", "5.9", "6.3", "6.7", "7.1", "7.7", "8.3", "9.1", "10.0", "11.1", "12.5", "14.3", "16.7", "20.0", "25.0", "33.3", "50.0", "100.0"};
    public static final String[] SAMPLERATE_ITEMS = new String[]{"10", "17.78", "31.62", "56.23", "100", "177.83", "316.23", "562.34", "1000", "1778.28"};

    public static void main(String[] args) {
        ConfigurablePanel panel = new ConfigurablePanel(ConfigV0PanelFactory.create());
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(3);
        f.getContentPane().add(panel);
        f.pack();
        f.setSize(400, 800);
        f.setVisible(true);
    }

    public static DefaultComboBoxModel defaultSamplerates_MMA8452_SMBUS() {
        return new DefaultComboBoxModel<String>(SAMPLERATE_ITEMS_MMA8452_SMBUS);
    }

    public static DefaultComboBoxModel defaultSamplerates() {
        return new DefaultComboBoxModel<String>(SAMPLERATE_ITEMS);
    }

    public static DefaultComboBoxModel defaultByteCounts() {
        return new DefaultComboBoxModel<String>(new String[]{"0", "54", "117", "180", "243", "306", "369", "432", "495", "558", "621", "684", "747", "810", "873", "936", "999", "1062", "1125", "1188"});
    }

    public static DefaultComboBoxModel defaultAxes() {
        return new DefaultComboBoxModel<String>(new String[]{"X-Axis", "Y-Axis", "Z-Axis"});
    }

    public static JPanel create(Row[] rows) {
        String rowsSpec = "";
        for (Row r : rows) {
            rowsSpec = r.appendDef(rowsSpec);
        }
        String encodedColumnSpecs = "right:pref, 3dlu, fill:50dlu:grow";
        FormLayout layout = new FormLayout(encodedColumnSpecs, rowsSpec);
        PanelBuilder builder = new PanelBuilder(layout);
        builder.setDefaultDialogBorder();
        CellConstraints cc = new CellConstraints();
        int rowCount = 1;
        for (Row r : rows) {
            rowCount = r.build(builder, rowCount);
        }
        return builder.getPanel();
    }
}

