/*
 * Decompiled with CFR 0.152.
 */
package de.eobs.setuptool.gui.tagconfigaccess;

import de.eobs.setuptool.gui.configurablepanel.EobsStructs;
import de.eobs.setuptool.gui.tagconfigaccess.TagConfigAccess;
import de.eobs.setuptool.gui.tagconfigaccess.Vocabular;
import de.eobs.setuptool.tagconfig.TagConfigFactory;
import de.eobs.setuptool.tagconfig.TagConfigV0;

public class TagConfigV0Util {
    public static void main(String[] args) {
        TagConfigV0 config = TagConfigFactory.defaultConfigV0();
        TagConfigAccess access = TagConfigV0Util.bind(config);
        System.out.println(access.get(Vocabular.gps_medium_res_interval));
        System.out.println(access.get(Vocabular.gps_interval));
        System.out.println(EobsStructs.printMinutes((int)access.get(Vocabular.gps_ontime_begin)));
        System.out.println(EobsStructs.printMinutes((int)access.get(Vocabular.gps_ontime_end)));
        System.out.println(EobsStructs.printMinutes((int)access.get(Vocabular.ping_ontime_begin)));
        System.out.println(EobsStructs.printMinutes((int)access.get(Vocabular.ping_ontime_end)));
        System.out.println(access.get(Vocabular.acc_interval));
        System.out.println(access.get(Vocabular.acc_bytecnt));
        System.out.println(access.get(Vocabular.acc_samplerate));
        System.out.println(EobsStructs.printMinutes((int)access.get(Vocabular.acc_ontime_begin)));
        System.out.println(EobsStructs.printMinutes((int)access.get(Vocabular.acc_ontime_end)));
        System.out.println(access.get(Vocabular.acc_use_xaxis));
        System.out.println(access.get(Vocabular.acc_use_yaxis));
        System.out.println(access.get(Vocabular.acc_use_zaxis));
    }

    public static TagConfigAccess bind(TagConfigV0 config) {
        TagConfigAccess access = new TagConfigAccess();
        access.init(Vocabular.gps_medium_res_interval, config.gps_medium_res_interval());
        access.init(Vocabular.gps_interval, config.gps_interval());
        access.init(Vocabular.gps_ontime_begin, config.gps_ontime());
        access.init(Vocabular.gps_ontime_end, config.gps_ontime());
        access.init(Vocabular.ping_ontime_begin, config.ping_ontime());
        access.init(Vocabular.ping_ontime_end, config.ping_ontime());
        access.init(Vocabular.acc_interval, config.acc_interval());
        access.init(Vocabular.acc_samplerate, config.acc_samplerate());
        access.init(Vocabular.acc_bytecnt, config.acc_bytecnt());
        access.init(Vocabular.acc_ontime_begin, config.acc_ontime());
        access.init(Vocabular.acc_ontime_end, config.acc_ontime());
        access.init(Vocabular.acc_use_xaxis, new FlagAccessX(config));
        access.init(Vocabular.acc_use_yaxis, new FlagAccessY(config));
        access.init(Vocabular.acc_use_zaxis, new FlagAccessZ(config));
        access.init(Vocabular.gps_daydivisor, config.gps_daydivisor());
        access.init(Vocabular.gps_hourshift, config.gps_hourshift());
        access.init(Vocabular.gps_interval_retry_factor, config.gps_interval_retry_factor());
        access.init(Vocabular.lowspeed_gps_interval_factor, config.lowspeed_gps_interval_factor());
        access.init(Vocabular.gps_speed_thr, config.gps_speed_thr());
        access.init(Vocabular.gps_timeout, config.gps_timeout());
        access.init(Vocabular.burst_length, config.burst_length());
        access.init(Vocabular.burst_qperiod, config.burst_qperiod());
        access.init(Vocabular.lowspeed_acc_interval_factor, config.lowspeed_acc_interval_factor());
        access.init(Vocabular.use_inverse_low_speed_interval_factor, new FlagAccessInverseLowSpeedIntervalFactor(config));
        access.init(Vocabular.sms_time, config.sms_time());
        access.init(Vocabular.gprs_time, config.gprs_time());
        access.init(Vocabular.sms_gps_collect_interval1, config.sms_gps_collect_interval1());
        access.init(Vocabular.sms_gps_collect_offset1, config.sms_gps_collect_offset1());
        access.init(Vocabular.gsm_bigger_interval, config.gsm_bigger_interval());
        access.init(Vocabular.pinger_interval, config.pinger_interval());
        access.init(Vocabular.freq_pinger, config.freq_pinger());
        access.init(Vocabular.device_start_time, config.device_start_time());
        access.init(Vocabular.secret_key, config.secret_key());
        access.init(Vocabular.access_key, config.access_key());
        access.init(Vocabular.bat_threshold0, config.bat_threshold0());
        access.init(Vocabular.bat_threshold1, config.bat_threshold1());
        access.init(Vocabular.bat_threshold2, config.bat_threshold2());
        access.init(Vocabular.bat_acc_threshold, config.bat_acc_threshold());
        access.init(Vocabular.bat_gsm_threshold, config.bat_gsm_threshold());
        access.init(Vocabular.sms_timeout, config.sms_timeout());
        access.init(Vocabular.gprs_timeout, config.gprs_timeout());
        access.init(Vocabular.bat_gprs_download_threshold, config.bat_gprs_download_threshold());
        access.init(Vocabular.gprs_min_pk_freq, config.gprs_min_pk_freq());
        access.init(Vocabular.maccess_voltlimit, config.maccess_voltlimit());
        access.init(Vocabular.radio_interval, config.radio_interval());
        access.init(Vocabular.radio_longdelay, config.radio_longdelay());
        return access;
    }

    static class FlagAccessInverseLowSpeedIntervalFactor
    implements FlagAccess {
        private final TagConfigV0 config;

        public FlagAccessInverseLowSpeedIntervalFactor(TagConfigV0 config) {
            this.config = config;
        }

        @Override
        public void set(boolean flag) {
            if (flag) {
                this.config.setInverseLowSpeedIntervalFactor();
            } else {
                this.config.clearInverseLowSpeedIntervalFactor();
            }
        }

        @Override
        public boolean get() {
            return this.config.getInverseLowSpeedIntervalFactor();
        }
    }

    static class FlagAccessZ
    implements FlagAccess {
        private final TagConfigV0 config;

        public FlagAccessZ(TagConfigV0 config) {
            this.config = config;
        }

        @Override
        public void set(boolean flag) {
            if (flag) {
                this.config.setAccUseZAxis();
            } else {
                this.config.clearAccUseZAxis();
            }
        }

        @Override
        public boolean get() {
            return this.config.getAccUseZAxis();
        }
    }

    static class FlagAccessY
    implements FlagAccess {
        private final TagConfigV0 config;

        public FlagAccessY(TagConfigV0 config) {
            this.config = config;
        }

        @Override
        public void set(boolean flag) {
            if (flag) {
                this.config.setAccUseYAxis();
            } else {
                this.config.clearAccUseYAxis();
            }
        }

        @Override
        public boolean get() {
            return this.config.getAccUseYAxis();
        }
    }

    static class FlagAccessX
    implements FlagAccess {
        private final TagConfigV0 config;

        public FlagAccessX(TagConfigV0 config) {
            this.config = config;
        }

        @Override
        public void set(boolean flag) {
            if (flag) {
                this.config.setAccUseXAxis();
            } else {
                this.config.clearAccUseXAxis();
            }
        }

        @Override
        public boolean get() {
            return this.config.getAccUseXAxis();
        }
    }

    static interface FlagAccess {
        public void set(boolean var1);

        public boolean get();
    }
}

