/*
 * Decompiled with CFR 0.152.
 */
package de.eobs.setuptool.gui.tagconfigaccess;

import de.eobs.setuptool.gui.tagconfigaccess.TagConfigAccess;
import de.eobs.setuptool.gui.tagconfigaccess.TagConfigV0Util;
import de.eobs.setuptool.gui.tagconfigaccess.VocabularV2;
import de.eobs.setuptool.tagconfig.TagConfigV2;

public class TagConfigV2Util {
    public static TagConfigAccess bind(TagConfigV2 config) {
        TagConfigAccess access = new TagConfigAccess();
        access.init(VocabularV2.gps_ontime_begin, config.gps_ontime());
        access.init(VocabularV2.gps_ontime_end, config.gps_ontime());
        access.init(VocabularV2.gps_on2time_begin, config.gps_on2time());
        access.init(VocabularV2.gps_on2time_end, config.gps_on2time());
        access.init(VocabularV2.gps_high_res_interval, config.gps_high_res_interval());
        access.init(VocabularV2.gps_low_res_interval, config.gps_low_res_interval());
        access.init(VocabularV2.gps_low_bat_interval, config.gps_low_bat_interval());
        access.init(VocabularV2.speed_threshold1, config.speed_threshold1());
        access.init(VocabularV2.speed_threshold2, config.speed_threshold2());
        access.init(VocabularV2.speed_threshold3, config.speed_threshold3());
        access.init(VocabularV2.acc_interval, config.acc_interval());
        access.init(VocabularV2.acc_low_bat_interval, config.acc_low_bat_interval());
        access.init(VocabularV2.variance_interval, config.variance_interval());
        access.init(VocabularV2.acc_byte_count, config.acc_byte_count());
        access.init(VocabularV2.acc_samplerate, config.acc_samplerate());
        access.init(VocabularV2.acc_ontime_begin, config.acc_ontime());
        access.init(VocabularV2.acc_ontime_end, config.acc_ontime());
        access.init(VocabularV2.acc_on2time_begin, config.acc_on2time());
        access.init(VocabularV2.acc_on2time_end, config.acc_on2time());
        access.init(VocabularV2.imu_interval, config.imu_interval());
        access.init(VocabularV2.imu_lowbat_interval, config.imu_lowbat_interval());
        access.init(VocabularV2.imu_ontime_begin, config.imu_ontime());
        access.init(VocabularV2.imu_ontime_end, config.imu_ontime());
        access.init(VocabularV2.imu_on2time_begin, config.imu_on2time());
        access.init(VocabularV2.imu_on2time_end, config.imu_on2time());
        access.init(VocabularV2.imu_acc_datasetcount, config.imu_acc_datasetcount());
        access.init(VocabularV2.imu_quatcomp_datasetcount, config.imu_quatcomp_datasetcount());
        access.init(VocabularV2.imu_start_delay, config.imu_start_delay());
        access.init(VocabularV2.acc_use_xaxis, new FlagAccessX(config));
        access.init(VocabularV2.acc_use_yaxis, new FlagAccessY(config));
        access.init(VocabularV2.acc_use_zaxis, new FlagAccessZ(config));
        access.init(VocabularV2.imu_flags_2_1, new ImuFlagAccess(config, 2, 1));
        access.init(VocabularV2.imu_flags_2_2, new ImuFlagAccess(config, 2, 2));
        access.init(VocabularV2.imu_flags_2_4, new ImuFlagAccess(config, 2, 4));
        access.init(VocabularV2.imu_flags_2_8, new ImuFlagAccess(config, 2, 8));
        access.init(VocabularV2.imu_flags_2_16, new ImuFlagAccess(config, 2, 16));
        access.init(VocabularV2.imu_flags_2_32, new ImuFlagAccess(config, 2, 32));
        access.init(VocabularV2.imu_flags_2_64, new ImuFlagAccess(config, 2, 64));
        access.init(VocabularV2.imu_flags_2_128, new ImuFlagAccess(config, 2, 128));
        access.init(VocabularV2.imu_flags_3_1, new ImuFlagAccess(config, 3, 1));
        access.init(VocabularV2.lowspeed_acc_interval_factor, config.lowspeed_acc_interval_factor());
        access.init(VocabularV2.gps_day_divisor, config.gps_day_divisor());
        access.init(VocabularV2.gps_hour_shift, config.gps_hour_shift());
        access.init(VocabularV2.gps_interval_retry_factor, config.gps_interval_retry_factor());
        access.init(VocabularV2.gps_timeout, config.gps_timeout());
        access.init(VocabularV2.burst_length, config.burst_length());
        access.init(VocabularV2.burst_qperiod, config.burst_qperiod());
        access.init(VocabularV2.burst_low_speed_fix_count, config.burst_low_speed_fix_count());
        access.init(VocabularV2.lowbat_burst_length, config.lowbat_burst_length());
        access.init(VocabularV2.lowbat_burst_qperiod, config.lowbat_burst_qperiod());
        access.init(VocabularV2.device_start_time, config.device_start_time());
        access.init(VocabularV2.sm_burst_length, config.sm_burst_length());
        access.init(VocabularV2.sm_burst_qperiod, config.sm_burst_qperiod());
        access.init(VocabularV2.sm_burst_low_speed_fix_count, config.sm_burst_low_speed_fix_count());
        access.init(VocabularV2.sm_low_res_gps_interval, config.sm_low_res_gps_interval());
        access.init(VocabularV2.sm_gps_mem_limit, config.sm_gps_mem_limit());
        access.init(VocabularV2.sm_acc_interval, config.sm_acc_interval());
        access.init(VocabularV2.sm_variance_interval, config.sm_variance_interval());
        access.init(VocabularV2.sm_imu_interval, config.sm_imu_interval());
        access.init(VocabularV2.use_inverse_low_speed_interval_factor, new FlagAccessInverseLowSpeedIntervalFactor(config));
        access.init(VocabularV2.acc_var_threshold, config.acc_var_threshold());
        access.init(VocabularV2.acc_var_samplerate, config.acc_var_samplerate());
        access.init(VocabularV2.acc_var_bytecnt, config.acc_var_bytecnt());
        access.init(VocabularV2.acc_param_n1, config.acc_param_n1());
        access.init(VocabularV2.acc_param_n2, config.acc_param_n2());
        access.init(VocabularV2.speed_param_n1, config.speed_param_n1());
        access.init(VocabularV2.variance_axis, config.variance_axis());
        access.init(VocabularV2.tilt_second_axis, config.tilt_second_axis());
        access.init(VocabularV2.acc_yf, config.acc_yf());
        access.init(VocabularV2.accoffset_yf, config.accoffset_yf());
        access.init(VocabularV2.acc_zf, config.acc_zf());
        access.init(VocabularV2.accoffset_zf, config.accoffset_zf());
        access.init(VocabularV2.sm_acc_param_n1, config.sm_acc_param_n1());
        access.init(VocabularV2.sm_acc_param_n2, config.sm_acc_param_n2());
        access.init(VocabularV2.ignore_variance_in_supermode_with_high_gps_res, new FlagIgnoreVarianceInSupermodeWithHighGpsResolution(config));
        access.init(VocabularV2.ignore_angle_in_supermode_with_high_gps_res, new FlagIgnoreAngleInSupermodeWithHighGpsResolution(config));
        access.init(VocabularV2.ignore_low_res_continue_gps_burst, new FlagIgnoreLowResolutionContinueGpsBurst(config));
        access.init(VocabularV2.ping_ontime_begin, config.ping_ontime());
        access.init(VocabularV2.ping_ontime_end, config.ping_ontime());
        access.init(VocabularV2.pinger_interval, config.pinger_interval());
        access.init(VocabularV2.secret_key, config.secret_key());
        access.init(VocabularV2.access_key, config.access_key());
        access.init(VocabularV2.gprs_time, config.gprs_time());
        access.init(VocabularV2.gprs_time2, config.gprs_time2());
        access.init(VocabularV2.gprs_time3, config.gprs_time3());
        access.init(VocabularV2.gprs_min_pk_freq, config.gprs_min_pk_freq());
        access.init(VocabularV2.sms_time, config.sms_time());
        access.init(VocabularV2.sms_timeout, config.sms_timeout());
        access.init(VocabularV2.sms_gps_collect_interval1, config.sms_gps_collect_interval1());
        access.init(VocabularV2.sms_gps_collect_offset1, config.sms_gps_collect_offset1());
        access.init(VocabularV2.gsm_big_interval, config.gsm_big_interval());
        access.init(VocabularV2.ping_frequency, config.ping_frequency());
        access.init(VocabularV2.bat_threshold3, config.bat_threshold3());
        access.init(VocabularV2.bat_threshold2, config.bat_threshold2());
        access.init(VocabularV2.bat_threshold1, config.bat_threshold1());
        access.init(VocabularV2.bat_gsm_threshold, config.bat_gsm_threshold());
        access.init(VocabularV2.bat_acc_threshold, config.bat_acc_threshold());
        access.init(VocabularV2.bat_threshold0, config.bat_threshold0());
        access.init(VocabularV2.maccess_voltlimit, config.maccess_voltlimit());
        access.init(VocabularV2.bat_gprs_download_threshold, config.bat_gprs_download_threshold());
        access.init(VocabularV2.gprs_timeout, config.gprs_timeout());
        access.init(VocabularV2.radio_longdelay, config.radio_longdelay());
        access.init(VocabularV2.datalink_2017, new FlagDatalink2017(config));
        return access;
    }

    static class FlagIgnoreLowResolutionContinueGpsBurst
    implements TagConfigV0Util.FlagAccess {
        private final TagConfigV2 config;

        public FlagIgnoreLowResolutionContinueGpsBurst(TagConfigV2 config) {
            this.config = config;
        }

        @Override
        public void set(boolean flag) {
            if (flag) {
                this.config.setIgnoreLowResolutionContinueGpsBurst();
            } else {
                this.config.clearIgnoreLowResolutionContinueGpsBurst();
            }
        }

        @Override
        public boolean get() {
            return this.config.getIgnoreLowResolutionContinueGpsBurst();
        }
    }

    static class FlagIgnoreAngleInSupermodeWithHighGpsResolution
    implements TagConfigV0Util.FlagAccess {
        private final TagConfigV2 config;

        public FlagIgnoreAngleInSupermodeWithHighGpsResolution(TagConfigV2 config) {
            this.config = config;
        }

        @Override
        public void set(boolean flag) {
            if (flag) {
                this.config.setIgnoreAngleInSupermodeWithHighGpsResolution();
            } else {
                this.config.clearIgnoreAngleInSupermodeWithHighGpsResolution();
            }
        }

        @Override
        public boolean get() {
            return this.config.getIgnoreAngleInSupermodeWithHighGpsResolution();
        }
    }

    static class FlagIgnoreVarianceInSupermodeWithHighGpsResolution
    implements TagConfigV0Util.FlagAccess {
        private final TagConfigV2 config;

        public FlagIgnoreVarianceInSupermodeWithHighGpsResolution(TagConfigV2 config) {
            this.config = config;
        }

        @Override
        public void set(boolean flag) {
            if (flag) {
                this.config.setIgnoreVarianceInSupermodeWithHighGpsResolution();
            } else {
                this.config.clearIgnoreVarianceInSupermodeWithHighGpsResolution();
            }
        }

        @Override
        public boolean get() {
            return this.config.getIgnoreVarianceInSupermodeWithHighGpsResolution();
        }
    }

    static class FlagDatalink2017
    implements TagConfigV0Util.FlagAccess {
        private final TagConfigV2 config;

        public FlagDatalink2017(TagConfigV2 config) {
            this.config = config;
        }

        @Override
        public void set(boolean flag) {
            if (flag) {
                this.config.setUse_869_85_TX();
            } else {
                this.config.clearUse_869_85_TX();
            }
        }

        @Override
        public boolean get() {
            return this.config.getUse_869_85_TX();
        }
    }

    static class FlagAccessInverseLowSpeedIntervalFactor
    implements TagConfigV0Util.FlagAccess {
        private final TagConfigV2 config;

        public FlagAccessInverseLowSpeedIntervalFactor(TagConfigV2 config) {
            this.config = config;
        }

        @Override
        public void set(boolean flag) {
            if (flag) {
                this.config.setInverseLowSpeedIntervalFactor();
            } else {
                this.config.clearInverseLowSpeedIntervalFactor();
            }
        }

        @Override
        public boolean get() {
            return this.config.getInverseLowSpeedIntervalFactor();
        }
    }

    static class ImuFlagAccess
    implements TagConfigV0Util.FlagAccess {
        private final TagConfigV2 config;
        private final int flagIndex;
        private final int bitValue;

        public ImuFlagAccess(TagConfigV2 config, int flagIndex, int bitValue) {
            this.config = config;
            this.flagIndex = flagIndex;
            this.bitValue = bitValue;
        }

        @Override
        public void set(boolean flag) {
            if (this.flagIndex == 2) {
                if (flag) {
                    this.config.flags2().setMask(this.bitValue);
                } else {
                    this.config.flags2().clearMask(this.bitValue);
                }
            } else if (this.flagIndex == 3) {
                if (flag) {
                    this.config.flags3().setMask(this.bitValue);
                } else {
                    this.config.flags3().clearMask(this.bitValue);
                }
            } else {
                throw new IllegalArgumentException("flagIndex out of range: " + this.flagIndex);
            }
        }

        @Override
        public boolean get() {
            if (this.flagIndex == 2) {
                return this.config.flags2().hasMask(this.bitValue);
            }
            if (this.flagIndex == 3) {
                return this.config.flags3().hasMask(this.bitValue);
            }
            throw new IllegalArgumentException("flagIndex out of range: " + this.flagIndex);
        }
    }

    static class FlagAccessZ
    implements TagConfigV0Util.FlagAccess {
        private final TagConfigV2 config;

        public FlagAccessZ(TagConfigV2 config) {
            this.config = config;
        }

        @Override
        public void set(boolean flag) {
            if (flag) {
                this.config.setAccUseZAxis();
            } else {
                this.config.clearAccUseZAxis();
            }
        }

        @Override
        public boolean get() {
            return this.config.getAccUseZAxis();
        }
    }

    static class FlagAccessY
    implements TagConfigV0Util.FlagAccess {
        private final TagConfigV2 config;

        public FlagAccessY(TagConfigV2 config) {
            this.config = config;
        }

        @Override
        public void set(boolean flag) {
            if (flag) {
                this.config.setAccUseYAxis();
            } else {
                this.config.clearAccUseYAxis();
            }
        }

        @Override
        public boolean get() {
            return this.config.getAccUseYAxis();
        }
    }

    static class FlagAccessX
    implements TagConfigV0Util.FlagAccess {
        private final TagConfigV2 config;

        public FlagAccessX(TagConfigV2 config) {
            this.config = config;
        }

        @Override
        public void set(boolean flag) {
            if (flag) {
                this.config.setAccUseXAxis();
            } else {
                this.config.clearAccUseXAxis();
            }
        }

        @Override
        public boolean get() {
            return this.config.getAccUseXAxis();
        }
    }
}

