/*
 * Decompiled with CFR 0.152.
 */
package de.eobs.setuptool.remoteservice;

import com.google.common.base.Optional;
import de.eobs.setuptool.Setuptool;
import de.eobs.setuptool.SystemInfo;
import de.eobs.setuptool.event.SendTagConfigToServerEvent;
import de.eobs.setuptool.event.SendTagConfigsToServerEvent;
import de.eobs.setuptool.remoteservice.RemoteServiceCompatibilityCheck;
import de.eobs.setuptool.rest.api.TagId;
import de.eobs.setuptool.rest.api.TagInfo;
import de.eobs.setuptool.util.BuildProperties;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import org.apache.http.HttpException;
import org.apache.http.NoHttpResponseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.remoting.RemoteAccessException;

public class RemoteService {
    private static final Logger logger = LoggerFactory.getLogger(RemoteService.class);
    private final ThreadPoolExecutor executor = new ThreadPoolExecutor(2, 2, 50000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
    private final int tpSize = 2;

    public void getVersion(final GetVersionHandler handler) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                try {
                    final String version = Setuptool.getTagInfoService().getVersion();
                    logger.info("remote version: " + version);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            handler.onSuccess(version);
                        }
                    });
                }
                catch (RemoteAccessException e) {
                    logger.info("" + (Object)((Object)e));
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            handler.onFailure();
                        }
                    });
                }
            }
        });
    }

    public void checkCompatibility(final CheckCompatibilityHandler handler) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                logger.info(BuildProperties.getInstance().toString());
                RemoteServiceCompatibilityCheck.ClientInfo clientInfo = new RemoteServiceCompatibilityCheck.ClientInfo("SetupTool", BuildProperties.getInstance(), SystemInfo.getHashedSystemInfo());
                logger.info(clientInfo.toString());
                try {
                    final RemoteServiceCompatibilityCheck.ServiceInfo serviceInfo = Setuptool.getRemoteServiceCompatibilityCheck().checkCompatibility(clientInfo);
                    logger.info(serviceInfo.toString());
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            handler.onSuccess(serviceInfo);
                        }
                    });
                }
                catch (RemoteAccessException e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            handler.onFailure();
                        }
                    });
                }
            }
        });
    }

    public void getTagList(final GetTagListHandler handler) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                try {
                    final List tagList = Setuptool.getTagInfoService().listTagIds();
                    logger.info("remote tagList: " + tagList);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            handler.onSuccess(tagList);
                        }
                    });
                }
                catch (RemoteAccessException e) {
                    logger.info("" + (Object)((Object)e));
                    final ErrorCode ec = RemoteService.getErrorCode(e);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            handler.onFailure(ec);
                        }
                    });
                }
            }
        });
    }

    private static ErrorCode getErrorCode(RemoteAccessException e) {
        ErrorCode ec = ErrorCode.Unknown;
        Throwable cause = e.getCause();
        logger.info("cause: " + cause);
        if (cause != null && cause instanceof HttpException) {
            HttpException httpException = (HttpException)cause;
            String message = httpException.getMessage();
            logger.info("e: " + message);
            if ("Did not receive successful HTTP response: status code = 401, status message = [Unauthorized]".equals(message) || "Did not receive successful HTTP response: status code = 401, status message = [Authorization Required]".equals(message)) {
                ec = ErrorCode.Unauthorized;
            }
        } else if (cause != null && cause instanceof NoHttpResponseException) {
            NoHttpResponseException httpException = (NoHttpResponseException)cause;
            String message = httpException.getMessage();
            logger.info("e: " + message);
            if (message.contains("status code = 401")) {
                ec = ErrorCode.Unauthorized;
            }
        }
        return ec;
    }

    public void getTag(final TagId tagId, final GetTagHandler handler) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                try {
                    final Optional tagInfo = Setuptool.getTagInfoService().getTagInfo(tagId);
                    logger.info("remote tagInfo: " + (tagInfo.isPresent() ? (Serializable)tagInfo.get() : "none"));
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (tagInfo.isPresent()) {
                                handler.onSuccess(tagId, (TagInfo)tagInfo.get());
                            } else {
                                handler.onFailure(tagId, ErrorCode.Unknown);
                            }
                        }
                    });
                }
                catch (RemoteAccessException e) {
                    logger.info("" + (Object)((Object)e));
                    final ErrorCode errorCode = RemoteService.getErrorCode(e);
                    logger.info("error code: " + (Object)((Object)errorCode));
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            handler.onFailure(tagId, errorCode);
                        }
                    });
                }
                catch (Throwable t) {
                    logger.info("" + t);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            handler.onFailure(tagId, ErrorCode.InternalServerError);
                        }
                    });
                }
            }
        });
    }

    public void listTags(final ListTagsHandler handler) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                try {
                    final List tagInfos = Setuptool.getTagInfoService().listTagInfos();
                    logger.info("remote tagInfos: " + (tagInfos != null ? Integer.valueOf(tagInfos.size()) : "none"));
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (tagInfos != null) {
                                handler.onSuccess(tagInfos);
                            } else {
                                handler.onFailure(ErrorCode.Unknown);
                            }
                        }
                    });
                }
                catch (RemoteAccessException e) {
                    logger.info("" + (Object)((Object)e));
                    final ErrorCode errorCode = RemoteService.getErrorCode(e);
                    logger.info("error code: " + (Object)((Object)errorCode));
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            handler.onFailure(errorCode);
                        }
                    });
                }
                catch (Throwable t) {
                    logger.info("" + t);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            handler.onFailure(ErrorCode.InternalServerError);
                        }
                    });
                }
            }
        });
    }

    public void updateTagConfigs(final SendTagConfigsToServerEvent configs, final UpdateTagConfigHandler handler) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                try {
                    for (SendTagConfigToServerEvent config : configs.getEvents()) {
                        Setuptool.getTagInfoService().updateConfig(config.getTagId(), config.getTagConfig().toBytes());
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            handler.onSuccess();
                        }
                    });
                }
                catch (RemoteAccessException e) {
                    logger.info("" + (Object)((Object)e));
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            handler.onFailure();
                        }
                    });
                }
            }
        });
    }

    public static interface CheckCompatibilityHandler {
        public void onSuccess(RemoteServiceCompatibilityCheck.ServiceInfo var1);

        public void onFailure();
    }

    public static interface UpdateTagConfigHandler {
        public void onSuccess();

        public void onFailure();
    }

    public static interface ListTagsHandler {
        public void onSuccess(List<TagInfo> var1);

        public void onFailure(ErrorCode var1);
    }

    public static interface GetTagHandler {
        public void onSuccess(TagId var1, TagInfo var2);

        public void onFailure(TagId var1, ErrorCode var2);
    }

    public static interface GetTagListHandler {
        public void onSuccess(List<TagId> var1);

        public void onFailure(ErrorCode var1);
    }

    public static interface GetVersionHandler {
        public void onSuccess(String var1);

        public void onFailure();
    }

    public static enum ErrorCode {
        Unknown,
        Unauthorized,
        InternalServerError;

    }
}

