/*
 * Decompiled with CFR 0.152.
 */
package de.eobs.setuptool.remoteservice.gettag;

import de.eobs.setuptool.eventbus.EventBus;
import de.eobs.setuptool.eventbus.EventHandler;
import de.eobs.setuptool.remoteservice.RemoteService;
import de.eobs.setuptool.remoteservice.RemoteServiceProgressPanel;
import de.eobs.setuptool.remoteservice.gettag.NewTagInfoEvent;
import de.eobs.setuptool.rest.api.TagId;
import de.eobs.setuptool.rest.api.TagInfo;
import de.eobs.setuptool.taglistdialog.TagSelectEvent;
import java.awt.Frame;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetTagProgressDialog {
    private static final Logger logger = LoggerFactory.getLogger(GetTagProgressDialog.class);
    private JDialog dialog;
    private final EventBus eventBus;
    private JFrame frame;
    private final RemoteService remoteService;

    public GetTagProgressDialog(JFrame frame, EventBus eventBus, RemoteService remoteService) {
        this.frame = frame;
        this.eventBus = eventBus;
        this.remoteService = remoteService;
    }

    @EventHandler(swingEDT=true)
    public void handle(TagSelectEvent event) {
        logger.info("" + event);
        RemoteServiceProgressPanel panel = new RemoteServiceProgressPanel();
        panel.updateText("connecting server...");
        this.remoteService.getTag(event.getTagId(), new RemoteService.GetTagHandler(){

            @Override
            public void onSuccess(TagId id, TagInfo info) {
                GetTagProgressDialog.this.dialog.setVisible(false);
                GetTagProgressDialog.this.eventBus.publish(new NewTagInfoEvent(id, info));
            }

            @Override
            public void onFailure(TagId id, RemoteService.ErrorCode ec) {
                GetTagProgressDialog.this.dialog.setVisible(false);
                if (ec == RemoteService.ErrorCode.Unauthorized) {
                    JOptionPane.showMessageDialog(GetTagProgressDialog.this.frame, "You are not authorized to download this tag config! Please check tag-id and password.", "Remote Service", 0);
                } else {
                    JOptionPane.showMessageDialog(GetTagProgressDialog.this.frame, "Can't connect to server!", "Remote Service", 0);
                }
            }
        });
        this.dialog = new JDialog((Frame)this.frame, true);
        this.dialog.setTitle("Download tag config");
        this.dialog.getContentPane().add(panel);
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(this.frame);
        this.dialog.setVisible(true);
    }
}

