/*
 * Decompiled with CFR 0.152.
 */
package de.eobs.setuptool.remoteservice.gettaglist;

import de.eobs.setuptool.eventbus.EventBus;
import de.eobs.setuptool.eventbus.EventHandler;
import de.eobs.setuptool.remoteservice.RemoteService;
import de.eobs.setuptool.remoteservice.RemoteServiceProgressPanel;
import de.eobs.setuptool.remoteservice.gettaglist.GetTagListFromServerEvent;
import de.eobs.setuptool.remoteservice.gettaglist.NewTagListEvent;
import de.eobs.setuptool.rest.api.TagId;
import java.awt.Frame;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetTagListProgressDialog {
    private static final Logger logger = LoggerFactory.getLogger(GetTagListProgressDialog.class);
    private JDialog dialog;
    private final EventBus eventBus;
    private JFrame frame;
    private final RemoteService remoteService;

    public GetTagListProgressDialog(JFrame frame, EventBus eventBus, RemoteService remoteService) {
        this.frame = frame;
        this.eventBus = eventBus;
        this.remoteService = remoteService;
    }

    @EventHandler(swingEDT=true)
    public void handle(GetTagListFromServerEvent event) {
        logger.info("" + event);
        RemoteServiceProgressPanel panel = new RemoteServiceProgressPanel();
        panel.updateText("connecting server...");
        this.remoteService.getTagList(new RemoteService.GetTagListHandler(){

            @Override
            public void onSuccess(List<TagId> tagList) {
                GetTagListProgressDialog.this.dialog.setVisible(false);
                GetTagListProgressDialog.this.eventBus.publish(new NewTagListEvent(tagList));
            }

            @Override
            public void onFailure(RemoteService.ErrorCode ec) {
                GetTagListProgressDialog.this.dialog.setVisible(false);
                JOptionPane.showMessageDialog(GetTagListProgressDialog.this.frame, "Can't connect to server!", "Download list of tags", 0);
            }
        });
        this.dialog = new JDialog((Frame)this.frame, true);
        this.dialog.setTitle("Download list of tags");
        this.dialog.getContentPane().add(panel);
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(this.frame);
        this.dialog.setVisible(true);
    }
}

