/*
 * Decompiled with CFR 0.152.
 */
package de.eobs.setuptool.remoteservice.getversion;

import de.eobs.setuptool.CheckCompatibilityEvent;
import de.eobs.setuptool.event.RemoteServiceAbortEvent;
import de.eobs.setuptool.eventbus.EventBus;
import de.eobs.setuptool.eventbus.EventHandler;
import de.eobs.setuptool.remoteservice.RemoteService;
import de.eobs.setuptool.remoteservice.RemoteServiceCompatibilityCheck;
import de.eobs.setuptool.remoteservice.RemoteServiceProgressPanel;
import de.eobs.setuptool.remoteservice.getversion.ServiceInfoEvent;
import de.eobs.setuptool.remoteservice.getversion.ServiceInfoFailureEvent;
import java.awt.Frame;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckCompatibilityProgressDialog {
    private static final Logger logger = LoggerFactory.getLogger(CheckCompatibilityProgressDialog.class);
    private JDialog dialog;
    private final EventBus eventBus;
    private JFrame frame;
    private final RemoteService remoteService;

    public CheckCompatibilityProgressDialog(JFrame frame, EventBus eventBus, RemoteService remoteService) {
        this.frame = frame;
        this.eventBus = eventBus;
        this.remoteService = remoteService;
    }

    @EventHandler(swingEDT=true)
    public void handle(CheckCompatibilityEvent event) {
        logger.info("" + event);
        RemoteServiceProgressPanel panel = new RemoteServiceProgressPanel();
        panel.updateText("Checking compatibility.\nConnecting to server...");
        this.remoteService.checkCompatibility(new RemoteService.CheckCompatibilityHandler(){

            @Override
            public void onSuccess(RemoteServiceCompatibilityCheck.ServiceInfo info) {
                CheckCompatibilityProgressDialog.this.dialog.setVisible(false);
                CheckCompatibilityProgressDialog.this.eventBus.publish(new ServiceInfoEvent(info));
            }

            @Override
            public void onFailure() {
                CheckCompatibilityProgressDialog.this.dialog.setVisible(false);
                CheckCompatibilityProgressDialog.this.eventBus.publish(new ServiceInfoFailureEvent());
            }
        });
        this.dialog = new JDialog((Frame)this.frame, true);
        this.dialog.getContentPane().add(panel);
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(this.frame);
        this.dialog.setVisible(true);
    }

    @EventHandler(swingEDT=true)
    public void handle(RemoteServiceAbortEvent event) {
        logger.info("" + event);
    }
}

